/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.timeline;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.eventline.IEventlineModel;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.eventline.IEditEventlineObjectPolicy;
import com.dlsc.flexgantt.policy.eventline.IEventlineLabelPolicy;
import com.dlsc.flexgantt.swing.timeline.Eventline;
import com.dlsc.flexgantt.swing.timeline.IEventlineObjectRenderer;
import com.dlsc.flexgantt.util.LabelType;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import javax.swing.JLabel;

public class DefaultEventlineObjectRenderer
extends JLabel
implements IEventlineObjectRenderer {
    private final Insets activityInsets = new Insets(0, -1, 0, 0);
    private final Insets eventInsets = new Insets(0, -8, 0, -8);
    private IEventlineModel model;
    private Eventline eventline;
    private Object eventlineObject;
    private boolean selected;
    private boolean focus;
    private Color resizeHandleColor = new Color(50, 120, 50);
    private Color focusLineColor = new Color(148, 148, 215).darker();
    private Color focusFillColor1 = new Color(235, 235, 250);
    private Color focusFillColor2 = new Color(180, 180, 235);
    private Color eventLineColor = new Color(148, 215, 148).darker();
    private Color eventFillColor1 = new Color(235, 250, 235);
    private Color eventFillColor2 = new Color(180, 235, 180);
    private Color activityLineColor = new Color(148, 215, 148).darker();
    private Color activityFillColor1 = new Color(235, 250, 235);
    private Color activityFillColor2 = new Color(180, 235, 180);
    private Color pastFillColor1 = Color.LIGHT_GRAY;
    private Color pastFillColor2 = Color.GRAY;
    private Color selectionLineColor = new Color(215, 148, 148).darker();
    private Color selectionFillColor1 = new Color(250, 235, 235);
    private Color selectionFillColor2 = new Color(235, 180, 180);
    private boolean event;
    private boolean visualizingPastTime;

    public DefaultEventlineObjectRenderer() {
        this.setOpaque(false);
        this.setHorizontalAlignment(0);
    }

    @Override
    public Component getEventlineRendererComponent(Eventline eventline, Object eventlineObject, boolean selected, boolean focus) {
        this.model = eventline.getModel();
        this.eventline = eventline;
        this.eventlineObject = eventlineObject;
        this.selected = selected;
        this.focus = focus;
        this.event = eventline.getModel().getTimeSpan(eventlineObject).isEvent();
        IPolicyProvider pp = eventline.getPolicyProvider();
        IEventlineLabelPolicy lp = pp.getPolicy(IEventlineLabelPolicy.class);
        String name = lp.getLabel(eventlineObject, this.model, LabelType.NAME);
        this.setText(name);
        this.setFont(eventline.getFont());
        this.setEnabled(eventline.isEnabled());
        return this;
    }

    @Override
    public Insets getEventlineRendererInsets() {
        ITimeSpan span = this.model.getTimeSpan(this.eventlineObject);
        if (span.isEvent()) {
            return this.eventInsets;
        }
        return this.activityInsets;
    }

    @Override
    protected void paintComponent(Graphics g) {
        long timeNow = this.eventline.getTimeNow();
        int x = this.eventline.getDateline().getTimeLocation(timeNow);
        if (this.event) {
            this.paintEvent(g);
            if (this.isVisualizingPastTime() && x > this.getBounds().x) {
                Shape clip = g.getClip();
                g.clipRect(0, 0, x - this.getBounds().x, this.getHeight());
                Color fill1 = this.getEventFillColor1();
                Color fill2 = this.getEventFillColor2();
                this.setEventFillColor1(this.pastFillColor1);
                this.setEventFillColor2(this.pastFillColor2);
                this.paintEvent(g);
                this.setEventFillColor1(fill1);
                this.setEventFillColor2(fill2);
                g.setClip(clip);
            }
        } else {
            this.paintActivityContent(g);
            if (this.isVisualizingPastTime() && x > this.getBounds().x) {
                Shape clip = g.getClip();
                g.clipRect(0, 0, x - this.getBounds().x, this.getHeight());
                Color fill1 = this.getActivityFillColor1();
                Color fill2 = this.getActivityFillColor2();
                this.setActivityFillColor1(this.pastFillColor1);
                this.setActivityFillColor2(this.pastFillColor2);
                this.paintActivityContent(g);
                this.setActivityFillColor1(fill1);
                this.setActivityFillColor2(fill2);
                g.setClip(clip);
            }
            if (this.focus) {
                this.paintActivityFocus(g);
            }
            this.paintActivityBorder(g);
        }
        if (!this.isEvent()) {
            super.paintComponent(g);
        }
    }

    protected void paintEvent(Graphics g) {
        int w = this.getWidth() - 1;
        int h = this.getHeight() - 1;
        int mx = w / 2 + 1;
        int[] xx = new int[]{mx - 7, mx + 7, mx, mx - 7};
        int[] yy = new int[]{h - 7, h - 7, h, h - 7};
        Graphics2D g2d = (Graphics2D)g;
        if (this.selected) {
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.selectionFillColor1, 0.0f, h / 2, this.selectionFillColor2));
        } else {
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.eventFillColor1, 0.0f, h / 2, this.eventFillColor2));
        }
        g2d.fillPolygon(xx, yy, 4);
        if (this.focus) {
            g2d.setColor(this.focusLineColor);
        } else if (this.selected) {
            g2d.setColor(this.selectionLineColor);
        } else {
            g2d.setColor(this.eventLineColor);
        }
        g2d.drawPolygon(xx, yy, 4);
    }

    protected void paintActivityContent(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        Graphics2D g2d = (Graphics2D)g;
        if (this.selected) {
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.selectionFillColor1, 0.0f, h / 2, this.selectionFillColor2));
        } else {
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.activityFillColor1, 0.0f, h / 2, this.activityFillColor2));
        }
        g2d.fillRect(1, 0, w - 1, h);
    }

    protected void paintActivityFocus(Graphics g) {
        g.setColor(this.resizeHandleColor);
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.isDurationChangeable()) {
            int x;
            int i;
            for (i = 0; i < 3; ++i) {
                x = w - 10 + i * 2;
                g.drawLine(x, 4, x, h - 3);
            }
            if (this.isStartTimeChangeable()) {
                for (i = 0; i < 3; ++i) {
                    x = 6 + i * 2;
                    g.drawLine(x, 4, x, h - 3);
                }
            }
        }
    }

    protected boolean isStartTimeChangeable() {
        IPolicyProvider pp = this.eventline.getPolicyProvider();
        IEditEventlineObjectPolicy ep = pp.getPolicy(IEditEventlineObjectPolicy.class);
        return ep.isStartTimeChangeable(this.eventlineObject, this.model);
    }

    protected boolean isDurationChangeable() {
        IPolicyProvider pp = this.eventline.getPolicyProvider();
        IEditEventlineObjectPolicy ep = pp.getPolicy(IEditEventlineObjectPolicy.class);
        return ep.isDurationChangeable(this.eventlineObject, this.model);
    }

    protected void paintActivityBorder(Graphics g) {
        int w = this.getWidth() - 1;
        int h = this.getHeight() - 1;
        g.setColor(this.eventline.getGridColor());
        g.drawLine(0, 0, 0, h);
        g.drawLine(w, 0, w, h);
    }

    public boolean isVisualizingPastTime() {
        return this.visualizingPastTime;
    }

    public void setVisualizingPastTime(boolean b) {
        this.visualizingPastTime = b;
    }

    protected Eventline getEventline() {
        return this.eventline;
    }

    protected Object getEventlineObject() {
        return this.eventlineObject;
    }

    @Override
    public boolean hasFocus() {
        return this.focus;
    }

    protected IEventlineModel getModel() {
        return this.model;
    }

    protected boolean isSelected() {
        return this.selected;
    }

    public Color getActivityFillColor1() {
        return this.activityFillColor1;
    }

    public void setActivityFillColor1(Color color) {
        this.activityFillColor1 = color;
    }

    public Color getActivityFillColor2() {
        return this.activityFillColor2;
    }

    public void setActivityFillColor2(Color color) {
        this.activityFillColor2 = color;
    }

    public Color getFocusFillColor1() {
        return this.focusFillColor1;
    }

    public void setFocusFillColor1(Color color) {
        this.focusFillColor1 = color;
    }

    public Color getFocusFillColor2() {
        return this.focusFillColor2;
    }

    public void setFocusFillColor2(Color color) {
        this.focusFillColor2 = color;
    }

    public Color getFocusLineColor() {
        return this.focusLineColor;
    }

    public void setFocusLineColor(Color color) {
        this.focusLineColor = color;
    }

    public Color getActivityLineColor() {
        return this.activityLineColor;
    }

    public void setActivityLineColor(Color color) {
        this.activityLineColor = color;
    }

    public Color getSelectionFillColor1() {
        return this.selectionFillColor1;
    }

    public void setSelectionFillColor1(Color color) {
        this.selectionFillColor1 = color;
    }

    public Color getSelectionFillColor2() {
        return this.selectionFillColor2;
    }

    public void setSelectionFillColor2(Color color) {
        this.selectionFillColor2 = color;
    }

    public Color getSelectionLineColor() {
        return this.selectionLineColor;
    }

    public void setSelectionLineColor(Color color) {
        this.selectionLineColor = color;
    }

    public Color getEventFillColor1() {
        return this.eventFillColor1;
    }

    public void setEventFillColor1(Color color) {
        this.eventFillColor1 = color;
    }

    public Color getEventFillColor2() {
        return this.eventFillColor2;
    }

    public void setEventFillColor2(Color color) {
        this.eventFillColor2 = color;
    }

    public void setEventLineColor(Color color) {
        this.eventLineColor = color;
    }

    public Color getEventLineColor() {
        return this.eventLineColor;
    }

    protected boolean isEvent() {
        return this.event;
    }

    public Color getPastFillColor1() {
        return this.pastFillColor1;
    }

    public void setPastFillColor1(Color color) {
        this.pastFillColor1 = color;
    }

    public Color getPastFillColor2() {
        return this.pastFillColor2;
    }

    public void setPastFillColor2(Color color) {
        this.pastFillColor2 = color;
    }

    public Color getResizeHandleColor() {
        return this.resizeHandleColor;
    }

    public void setResizeHandleColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color can not be NULL");
        }
        this.resizeHandleColor = color;
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void repaint() {
    }

    @Override
    public void repaint(int x, int y, int width, int height) {
    }

    @Override
    public void repaint(long tm) {
    }

    @Override
    public boolean isVisible() {
        return false;
    }
}

