/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.timeline;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.calendar.CalendarModelEvent;
import com.dlsc.flexgantt.model.calendar.ICalendarModel;
import com.dlsc.flexgantt.model.calendar.ICalendarModelListener;
import com.dlsc.flexgantt.model.dateline.DatelineModelEvent;
import com.dlsc.flexgantt.model.dateline.DatelineModelException;
import com.dlsc.flexgantt.model.dateline.GridLine;
import com.dlsc.flexgantt.model.dateline.IDatelineModel;
import com.dlsc.flexgantt.model.dateline.IDatelineModelListener;
import com.dlsc.flexgantt.model.dateline.IGranularity;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.PolicyProvider;
import com.dlsc.flexgantt.policy.dateline.IZoomPolicy;
import com.dlsc.flexgantt.policy.dateline.TimeGranularityZoomPolicy;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.MessageTypeId;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.timeline.DefaultDatelineMenuProvider;
import com.dlsc.flexgantt.swing.timeline.IDatelineMenuProvider;
import com.dlsc.flexgantt.swing.timeline.IDatelineRenderer;
import com.dlsc.flexgantt.swing.timeline.SimpleGranularityDatelineModel;
import com.dlsc.flexgantt.swing.timeline.SimpleGranularityDatelineRenderer;
import com.dlsc.flexgantt.swing.timeline.TimeGranularityDatelineModel;
import com.dlsc.flexgantt.swing.timeline.TimeGranularityDatelineRenderer;
import com.dlsc.flexgantt.swing.timeline.Timeline;
import com.dlsc.flexgantt.swing.util.ColorUtil;
import com.dlsc.flexgantt.util.Messages;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.CellRendererPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.TimingTargetAdapter;

public class Dateline
extends JPanel
implements IDatelineModelListener,
PropertyChangeListener,
MouseListener,
MouseWheelListener,
MouseMotionListener,
ICalendarModelListener {
    private static final Logger LOGGER = Logger.getLogger(Dateline.class.getName());
    public static final String PROPERTY_MODEL = "datelineModel";
    public static final String PROPERTY_SELECTION_FOREGROUND_COLOR = "selectionForegroundColor";
    public static final String PROPERTY_SELECTION_BACKGROUND_COLOR = "selectionBackground";
    public static final String PROPERTY_FOCUS_BACKGROUND_COLOR = "focusBackground";
    public static final String PROPERTY_POLICY_PROVIDER = "policyProvider";
    public static final String PROPERTY_FOCUSED_TIME_SPAN = "focusedTimeSpan";
    private static final Cursor ZOOM_CURSOR = Cursor.getPredefinedCursor(11);
    private static final Cursor HAND_CURSOR = Cursor.getPredefinedCursor(12);
    private long timeSpanStart = Long.MAX_VALUE;
    private long timeSpanEnd = Long.MIN_VALUE;
    private Timeline timeline;
    private IDatelineModel model;
    private Color selectionForeground = ColorUtil.getSelectionForeground();
    private Color selectionBackground = ColorUtil.getSelectionBackground();
    private Color focusBackground = ColorUtil.getFocusBackground();
    private AbstractGanttChart ganttChart;
    private Map<Class<? extends IDatelineModel>, IDatelineRenderer> rendererMap;
    private IPolicyProvider policyProvider = new PolicyProvider();
    private CellRendererPane rendererPane = new CellRendererPane();
    private Point mouseLocation;
    private IDatelineMenuProvider menuProvider = new DefaultDatelineMenuProvider();
    private JPopupMenu popup;
    private ZoomStrategy zoomStrategy = ZoomStrategy.CHANGE_VISIBLE_END_TIME;
    private Color gridColor = ColorUtil.getGridColor();
    private Point dragStartPoint;
    private ITimeSpan focusedTimeSpan;
    private boolean drawZoomRectangle;
    private Color manualZoomColor = Color.BLACK;
    private Point manualZoomLocation;
    private boolean manualZoomEnabled = true;
    private int originalSpanWidth;
    private Rectangle zoomRectangle;
    private boolean animatingZoom = true;
    private int animationDuration = 400;
    private Animator animator;
    private boolean clickZoomEnabled = true;
    private boolean focusTimeSpanEnabled = true;
    private int zoomClicks = 2;

    public Dateline(Timeline timeline) {
        this.setName("Dateline");
        if (timeline == null) {
            throw new IllegalArgumentException("timeline can not be NULL");
        }
        this.timeline = timeline;
        this.ganttChart = timeline.getGanttChart();
        this.setLayout(null);
        this.setAutoscrolls(true);
        this.add(this.rendererPane);
        try {
            this.setModel(new TimeGranularityDatelineModel(this));
        }
        catch (DatelineModelException e) {
            LOGGER.throwing(Dateline.class.getName(), "<init>", e);
        }
        this.setOpaque(false);
        this.setDoubleBuffered(true);
        this.setCursor(HAND_CURSOR);
        this.setFocusable(false);
        this.addPropertyChangeListener(this);
        timeline.addPropertyChangeListener(this);
        this.ganttChart.addPropertyChangeListener(this);
        this.ganttChart.getCalendarModel().addCalendarListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.rendererMap = new HashMap<Class<? extends IDatelineModel>, IDatelineRenderer>(5);
        this.setDatelineRenderer(SimpleGranularityDatelineModel.class, new SimpleGranularityDatelineRenderer());
        this.setDatelineRenderer(TimeGranularityDatelineModel.class, new TimeGranularityDatelineRenderer());
        this.policyProvider.setPolicy(IZoomPolicy.class, new TimeGranularityZoomPolicy());
    }

    public IPolicyProvider getPolicyProvider() {
        return this.policyProvider;
    }

    public void setPolicyProvider(IPolicyProvider provider) {
        IPolicyProvider oldProvider = this.policyProvider;
        this.policyProvider = provider;
        this.firePropertyChange(PROPERTY_POLICY_PROVIDER, oldProvider, provider);
    }

    public void setModel(IDatelineModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model can not be NULL");
        }
        IDatelineModel oldModel = this.model;
        if (oldModel != null) {
            oldModel.removeDatelineModelListener(this);
        }
        this.model = model;
        this.model.addDatelineModelListener(this);
        this.firePropertyChange(PROPERTY_MODEL, oldModel, model);
        this.repaint();
    }

    public IDatelineModel getModel() {
        return this.model;
    }

    public <T extends IDatelineModel> void setDatelineRenderer(Class<T> modelClass, IDatelineRenderer<T> renderer) {
        this.rendererMap.put(modelClass, renderer);
    }

    public <T extends IDatelineModel> IDatelineRenderer<T> getDatelineRenderer(Class<T> modelClass) {
        if (modelClass == null) {
            return null;
        }
        IDatelineRenderer renderer = this.rendererMap.get(modelClass);
        if (renderer != null) {
            return renderer;
        }
        return this.getDatelineRenderer(modelClass.getSuperclass());
    }

    public Timeline getTimeline() {
        return this.timeline;
    }

    public TimeZone getTimeZone() {
        return this.model.getTimeZone();
    }

    public void setTimeZone(TimeZone timeZone) {
        try {
            this.model.setTimeZone(timeZone);
        }
        catch (DatelineModelException ex) {
            this.ganttChart.showMessage(Messages.getString("Dateline.UNABLE_TO_USE_REQUESTED_TIME_ZONE"), MessageTypeId.ERROR);
            LOGGER.throwing(Dateline.class.getName(), "setTimeZone", ex);
        }
    }

    public IDatelineRenderer getDatelineRenderer() {
        return this.getDatelineRenderer(this.model.getClass());
    }

    public void zoomIn() {
        this.zoom(true);
    }

    public void zoomOut() {
        this.zoom(false);
    }

    private void zoom(boolean zoomIn) {
        TimeSpan span = null;
        ITimeSpan visible = this.getVisibleTimeSpan();
        ITimeSpan horizon = this.getTimeSpan();
        long quarter = visible.getDuration() / 4L;
        if (zoomIn) {
            span = this.zoomStrategy.equals((Object)ZoomStrategy.CHANGE_VISIBLE_START_AND_END_TIME) ? new TimeSpan(visible.getStartTime() + quarter, visible.getEndTime() - quarter) : new TimeSpan(visible.getStartTime(), visible.getEndTime() - 2L * quarter);
        } else if (this.zoomStrategy.equals((Object)ZoomStrategy.CHANGE_VISIBLE_START_AND_END_TIME)) {
            span = new TimeSpan(visible.getStartTime() - quarter, visible.getEndTime() + quarter);
        } else {
            long targetEndTime = visible.getEndTime() + 2L * quarter;
            long newEndTime = Math.min(horizon.getEndTime(), targetEndTime);
            long unused = Math.max(0L, targetEndTime - newEndTime);
            span = new TimeSpan(visible.getStartTime() - unused, newEndTime);
        }
        span = new TimeSpan(Math.max(horizon.getStartTime(), span.getStartTime()), Math.min(horizon.getEndTime(), span.getEndTime()));
        this.requestVisibleTimeSpan(span);
    }

    public void setSelectedTimeSpan(ITimeSpan span) {
        this.model.setSelectedTimeSpan(span);
        this.setFocusedTimeSpan(span);
    }

    public ITimeSpan getSelectedTimeSpan() {
        return this.model.getSelectedTimeSpan();
    }

    private ITimeSpan createTimeSelectionSpan() {
        if (this.timeSpanStart != Long.MAX_VALUE && this.timeSpanEnd != Long.MIN_VALUE) {
            return new TimeSpan(Math.min(this.timeSpanStart, this.timeSpanEnd), Math.max(this.timeSpanStart, this.timeSpanEnd));
        }
        return null;
    }

    public int getTimeLocation(long time) {
        return this.model.getTimeLocation(time);
    }

    public ITimeSpan getTimeSpan() {
        return this.model.getTimeSpan();
    }

    public void setGranularity(IGranularity granularity) {
        try {
            this.model.setGranularity(granularity);
        }
        catch (DatelineModelException ex) {
            this.ganttChart.showMessage(Messages.getString("Dateline.UNABLE_TO_USE_REQUESTED_GRANULARITY"), MessageTypeId.ERROR);
            LOGGER.throwing(this.getClass().getName(), "setGranularity(", ex);
        }
    }

    public IGranularity getGranularity() {
        return this.model.getGranularity();
    }

    public void setTimeSpan(ITimeSpan span) {
        try {
            this.model.setTimeSpan(span);
        }
        catch (DatelineModelException ex) {
            this.ganttChart.showMessage(Messages.getString("Dateline.UNABLE_TO_USE_REQUESTED_HORIZON"), MessageTypeId.ERROR);
            LOGGER.throwing(Dateline.class.getName(), "setTimeSpan", ex);
        }
    }

    public long getTimeAt(int x) {
        return this.model.getTimeAt(x);
    }

    public ITimeSpan getTimeSpanAt(Point p) {
        boolean major = p.getY() < (double)(this.getHeight() / 2);
        return this.getTimeSpanAt(p.x, major);
    }

    public ITimeSpan getTimeSpanAt(int x, boolean major) {
        return this.model.getTimeSpanAt(x, major);
    }

    public ITimeSpan getVisibleTimeSpan() {
        Rectangle rect = this.getVisibleRect();
        long s = this.getTimeAt(rect.x);
        long e = Math.max(s, this.getTimeAt(Math.max(0, rect.x + rect.width - 1)));
        return new TimeSpan(s, e);
    }

    public void showTimeNow(boolean center) {
        Timeline timeline = this.getTimeline();
        AbstractGanttChart gc = timeline.getGanttChart();
        gc.showTimeNow(center);
    }

    public void showTime(long time, boolean center) {
        Timeline timeline = this.getTimeline();
        AbstractGanttChart gc = timeline.getGanttChart();
        gc.showTime(time, center);
    }

    public synchronized void requestVisibleTimeSpan(ITimeSpan span) {
        if (this.animator != null && this.animator.isRunning()) {
            return;
        }
        ITimeSpan horizon = this.model.getTimeSpan();
        this.setTimeSpan(horizon.union(span));
        if (this.animatingZoom) {
            ITimeSpan visible = this.getVisibleTimeSpan();
            AnimateZoomTarget target = new AnimateZoomTarget(visible, span);
            this.animator = new Animator(this.animationDuration, (TimingTarget)target);
            this.animator.start();
        } else {
            try {
                this.model.requestVisibleTimeSpan(span);
            }
            catch (DatelineModelException e) {
                this.ganttChart.showMessage(Messages.getString("Dateline.UNABLE_TO_USE_REQUESTED_TIME_SPAN"), MessageTypeId.ERROR);
                LOGGER.throwing(Dateline.class.getName(), "requestVisibleTimeSpan()", e);
            }
        }
    }

    public boolean isAnimationThreadRunning() {
        return this.animator != null && this.animator.isRunning();
    }

    @Override
    public Dimension getPreferredSize() {
        int w = this.model.getDatelineWidth();
        int h = 40;
        return new Dimension(w, h);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintGrid(g);
        if (this.drawZoomRectangle) {
            this.paintZoomRectangle(g, this.zoomRectangle);
        }
    }

    protected void paintGrid(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        int w = this.getWidth();
        int h = this.getHeight();
        Rectangle clip = g2d.getClipBounds();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("dateline width/height = " + w + "/" + h);
            LOGGER.fine("g2d.getClipBounds() = " + clip);
        }
        int x2 = clip.x + clip.width;
        List<GridLine> majorGrid = this.model.getGrid(clip.x, x2, true);
        List<GridLine> minorGrid = this.model.getGrid(clip.x, x2, false);
        int m = h / 2;
        g2d.setColor(this.gridColor);
        this.paintGrid(g2d, 0, m, majorGrid, true);
        this.paintGrid(g2d, m, h - m, minorGrid, false);
        g2d.drawLine(clip.x, m, clip.x + clip.width, m);
        this.paintSelectedTimeSpan(g);
    }

    protected void paintSelectedTimeSpan(Graphics g) {
        ITimeSpan span = this.model.getSelectedTimeSpan();
        if (span != null) {
            Graphics2D g2d = (Graphics2D)g;
            Composite comp = g2d.getComposite();
            g2d.setComposite(AlphaComposite.getInstance(3, 0.5f));
            g2d.setColor(this.focusBackground);
            int x1 = this.getTimeLocation(span.getStartTime());
            int x2 = this.getTimeLocation(span.getEndTime());
            int h = this.getHeight();
            g2d.fillRect(x1, 0, x2 - x1, h);
            g2d.setComposite(comp);
            g2d.setColor(this.getForeground());
            g2d.drawLine(x1, 0, x1, h);
            g2d.drawLine(x2, 0, x2, h);
        }
    }

    protected void paintGrid(Graphics g, int y, int height, List<GridLine> grid, boolean major) {
        int s;
        if (grid != null && (s = grid.size()) > 1) {
            boolean handleFocus = false;
            if (this.mouseLocation != null) {
                handleFocus = (major && this.mouseLocation.y < this.getHeight() / 2 || !major && this.mouseLocation.y >= this.getHeight() / 2) && this.getSelectedTimeSpan() == null && !this.isAnimationThreadRunning() && this.focusedTimeSpan != null;
            }
            Graphics2D g2d = (Graphics2D)g;
            for (int i = 0; i < s - 1; ++i) {
                int x1 = grid.get(i).getLocation();
                int x2 = grid.get(i + 1).getLocation();
                g2d.drawLine(x1, y, x1, y + height - 1);
                long t1 = Math.max(0L, grid.get(i).getTime());
                long t2 = Math.max(t1, grid.get(i + 1).getTime());
                TimeSpan span = new TimeSpan(t1, t2);
                boolean focus = false;
                if (this.mouseLocation != null) {
                    focus = x1 < this.mouseLocation.x && this.mouseLocation.x < x2 && handleFocus;
                }
                this.paintCell(g2d, span, x1 + 1, y, x2 - x1 - 1, height, major, focus);
            }
        }
    }

    protected void paintCell(Graphics g, ITimeSpan span, int x, int y, int width, int height, boolean major, boolean focus) {
        IDatelineRenderer<?> renderer = this.getDatelineRenderer(this.model.getClass());
        if (renderer == null) {
            LOGGER.severe("no renderer registered for dateline model of type " + this.model.getClass());
        } else {
            Component comp = renderer.getDatelineRendererComponent(this, this.model, span, major, focus);
            this.rendererPane.paintComponent(g, comp, this, x, y, width, height, true);
        }
    }

    protected void paintZoomRectangle(Graphics g, Rectangle rect) {
        Graphics2D g2d = (Graphics2D)g;
        Stroke stroke = g2d.getStroke();
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.setColor(this.manualZoomColor);
        g2d.drawRect(rect.x, rect.y + 1, rect.width, rect.height - 2);
        g2d.setStroke(stroke);
    }

    public Color getSelectionForegroundColor() {
        return this.selectionForeground;
    }

    public void setSelectionForegroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("selection foreground color can not be NULL");
        }
        Color oldColor = this.selectionForeground;
        this.selectionForeground = color;
        this.firePropertyChange(PROPERTY_SELECTION_FOREGROUND_COLOR, oldColor, color);
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public void setSelectionBackground(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("selection background color can not be NULL");
        }
        Color oldColor = this.selectionBackground;
        this.selectionBackground = color;
        this.firePropertyChange(PROPERTY_SELECTION_BACKGROUND_COLOR, oldColor, color);
    }

    public Color getFocusBackground() {
        return this.focusBackground;
    }

    public void setFocusBackground(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("focus background color can not be NULL");
        }
        Color oldColor = this.focusBackground;
        this.focusBackground = color;
        this.firePropertyChange(PROPERTY_FOCUS_BACKGROUND_COLOR, oldColor, color);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource().equals(this.model)) {
            this.repaint();
        } else if (evt.getSource().equals(this.ganttChart) && evt.getPropertyName().equals("calendarModel")) {
            ICalendarModel oldModel = (ICalendarModel)evt.getOldValue();
            ICalendarModel newModel = (ICalendarModel)evt.getNewValue();
            if (oldModel != null) {
                oldModel.removeCalendarListener(this);
            }
            if (newModel != null) {
                newModel.addCalendarListener(this);
            }
        }
    }

    @Override
    public void datelineModelWillChange(DatelineModelEvent evt) {
    }

    @Override
    public void datelineModelChanged(DatelineModelEvent e) {
        this.repaint();
    }

    public ZoomStrategy getZoomStrategy() {
        return this.zoomStrategy;
    }

    public void setZoomStrategy(ZoomStrategy strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException("zoom strategy can not be NULL");
        }
        this.zoomStrategy = strategy;
    }

    public void setClickZoomEnabled(boolean enabled) {
        this.clickZoomEnabled = enabled;
    }

    public boolean isClickZoomEnabled() {
        return this.clickZoomEnabled;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.maybeShowPopup(e) && SwingUtilities.isLeftMouseButton(e) && this.clickZoomEnabled && e.getClickCount() == this.zoomClicks) {
            if (this.getCursor().equals(HAND_CURSOR)) {
                Rectangle rect = this.getVisibleRect();
                int x1 = rect.x;
                int x2 = x1 + rect.width;
                List<GridLine> grid = null;
                grid = e.getY() < this.getHeight() / 2 ? this.model.getGrid(x1, x2, true) : this.model.getGrid(x1, x2, false);
                int s = grid.size();
                TimeSpan span = null;
                if (s > 1) {
                    for (int i = 0; i < s - 1; ++i) {
                        if (e.getX() < grid.get(i).getLocation() || e.getX() > grid.get(i + 1).getLocation()) continue;
                        long t1 = Math.max(0L, grid.get(i).getTime());
                        long t2 = Math.max(0L, grid.get(i + 1).getTime());
                        span = new TimeSpan(t1, t2);
                        break;
                    }
                }
                if (span != null) {
                    this.requestVisibleTimeSpan(span);
                }
            } else if (this.getCursor().equals(ZOOM_CURSOR) && e.getClickCount() == this.zoomClicks) {
                try {
                    this.getModel().setZoom(1.0);
                }
                catch (DatelineModelException ex) {
                    this.ganttChart.showMessage(Messages.getString("Dateline.UNABLE_TO_PERFORM_ZOOM"), MessageTypeId.ERROR);
                    LOGGER.throwing(Dateline.class.getName(), "requestVisibleTimeSpan()", ex);
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.ganttChart.requestFocus();
        this.maybeShowPopup(e);
        if (!e.isPopupTrigger() && SwingUtilities.isLeftMouseButton(e)) {
            if (e.isShiftDown()) {
                this.timeSpanStart = this.getTimeAt(e.getX());
                this.timeSpanEnd = this.timeSpanStart + 1L;
                this.setSelectedTimeSpan(this.createTimeSelectionSpan());
            } else {
                this.dragStartPoint = e.getPoint();
                this.manualZoomLocation = e.getPoint();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
        if (this.getCursor().equals(ZOOM_CURSOR)) {
            int newWidth = this.originalSpanWidth + (this.manualZoomLocation.x - this.dragStartPoint.x);
            double zoom = (double)newWidth / (double)this.originalSpanWidth * this.model.getZoom();
            LOGGER.fine("new span width = " + newWidth);
            LOGGER.fine("new zoom factor = " + zoom);
            try {
                this.getModel().setZoom(Math.max(1.0, zoom));
            }
            catch (DatelineModelException ex) {
                this.ganttChart.showMessage(Messages.getString("Dateline.UNABLE_TO_PERFORM_ZOOM"), MessageTypeId.ERROR);
                LOGGER.throwing(Dateline.class.getName(), "requestVisibleTimeSpan()", ex);
            }
            if (this.focusedTimeSpan != null) {
                long time = this.focusedTimeSpan.getStartTime() + this.focusedTimeSpan.getDuration() / 2L;
                this.ganttChart.showTime(time, true);
            }
        } else if (!e.isPopupTrigger() && SwingUtilities.isLeftMouseButton(e)) {
            if (this.getSelectedTimeSpan() != null) {
                this.requestVisibleTimeSpan(this.getSelectedTimeSpan());
                this.setSelectedTimeSpan(null);
            }
            this.timeSpanStart = Long.MAX_VALUE;
            this.timeSpanEnd = Long.MIN_VALUE;
        }
        this.drawZoomRectangle = false;
        this.manualZoomLocation = null;
        this.repaint();
    }

    public void setFocusTimeSpanEnabled(boolean enabled) {
        this.focusTimeSpanEnabled = enabled;
    }

    public boolean isFocusTimeSpanEnabled() {
        return this.focusTimeSpanEnabled;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.focusTimeSpanEnabled) {
            this.mouseLocation = e.getPoint();
            boolean major = e.getY() < this.getHeight() / 2;
            ITimeSpan span = this.model.getTimeSpanAt(e.getX(), major);
            int spanX1 = this.getTimeLocation(span.getStartTime());
            int spanX2 = this.getTimeLocation(span.getEndTime());
            if (major && Math.abs(e.getX() - spanX2) <= 3) {
                this.setCursor(ZOOM_CURSOR);
                this.originalSpanWidth = spanX2 - spanX1;
                this.zoomRectangle = new Rectangle(spanX1, 0, this.originalSpanWidth, this.getHeight());
                LOGGER.fine("span width = " + (spanX2 - spanX1));
                LOGGER.fine("zoom factor = " + this.model.getZoom());
                LOGGER.fine("original span width = " + this.originalSpanWidth);
            } else {
                this.setCursor(HAND_CURSOR);
            }
            this.setFocusedTimeSpan(span);
            this.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseLocation = null;
        this.setFocusedTimeSpan(null);
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.drawZoomRectangle = false;
        if (SwingUtilities.isLeftMouseButton(e)) {
            if (this.getCursor().equals(HAND_CURSOR)) {
                if (e.isShiftDown()) {
                    if (!this.getVisibleRect().contains(new Point(e.getX(), 0))) {
                        Container parent = this.getParent();
                        while (!(parent instanceof JScrollPane)) {
                            parent = parent.getParent();
                        }
                        JScrollPane sp = (JScrollPane)parent;
                        LayerContainer lc = (LayerContainer)sp.getViewport().getView();
                        Point loc = lc.getLocation();
                        lc.scrollRectToVisible(new Rectangle(e.getX(), loc.y, 1, 1));
                    }
                    this.timeSpanEnd = this.getTimeAt(e.getX());
                    ITimeSpan span = this.createTimeSelectionSpan();
                    this.setSelectedTimeSpan(span);
                } else if (!this.ganttChart.isTimeNowScrolling()) {
                    Point p = e.getPoint();
                    int dx = this.dragStartPoint.x - p.x;
                    Container con = this.getParent();
                    while (!(con instanceof JScrollPane)) {
                        con = con.getParent();
                    }
                    JScrollPane pane = (JScrollPane)con;
                    JViewport port = pane.getViewport();
                    Point pos = port.getViewPosition();
                    pos.x = Math.min(this.getWidth() - this.getVisibleRect().width, Math.max(0, pos.x + dx));
                    pane.getViewport().setViewPosition(pos);
                }
            } else {
                this.manualZoomLocation = e.getPoint();
                this.drawZoomRectangle = true;
                this.zoomRectangle.width = this.manualZoomLocation.x - this.zoomRectangle.x;
                this.zoomRectangle.width = Math.max(this.zoomRectangle.width, (int)((double)this.originalSpanWidth / this.model.getZoom()));
                this.repaint();
            }
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent evt) {
        if (!evt.isConsumed()) {
            if ((evt.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) == 0) {
                if ((evt.getSource().equals(this) || evt.isShiftDown()) && !this.ganttChart.isTimeNowScrolling()) {
                    int rotation = evt.getWheelRotation();
                    Rectangle rect = this.getVisibleRect();
                    ITimeSpan span = this.model.getTimeSpanAt(rect.x, false);
                    long duration = span.getDuration();
                    long delta = (long)rotation * duration;
                    long time = this.getTimeAt(rect.x) + delta;
                    this.ganttChart.showTime(time, false);
                    this.setFocusedTimeSpan(null);
                }
            } else {
                int rotation = evt.getWheelRotation();
                if (rotation < 0) {
                    this.zoomIn();
                } else {
                    this.zoomOut();
                }
                evt.consume();
            }
        }
    }

    private boolean maybeShowPopup(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.popup = null;
            if (this.menuProvider != null) {
                long time = this.getTimeAt(evt.getX());
                boolean major = evt.getY() < this.getHeight() / 2;
                ITimeSpan span = this.getTimeSpanAt(evt.getX(), major);
                this.popup = this.menuProvider.getPopupMenu(this, evt, major, time, span);
            } else {
                this.popup = this.getComponentPopupMenu();
            }
            if (this.popup != null) {
                this.popup.show(this, evt.getX(), evt.getY());
                return true;
            }
        }
        return false;
    }

    public IDatelineMenuProvider getMenuProvider() {
        return this.menuProvider;
    }

    public void setMenuProvider(IDatelineMenuProvider provider) {
        this.menuProvider = provider;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color color) {
        this.gridColor = color;
    }

    public void setFocusedTimeSpan(ITimeSpan span) {
        ITimeSpan oldValue = this.focusedTimeSpan;
        this.focusedTimeSpan = span;
        this.firePropertyChange(PROPERTY_FOCUSED_TIME_SPAN, oldValue, this.focusedTimeSpan);
        this.repaint();
    }

    public ITimeSpan getFocusedTimeSpan() {
        return this.focusedTimeSpan;
    }

    @Override
    public void calendarChanged(CalendarModelEvent evt) {
        this.repaint();
    }

    public Map<Class<? extends IDatelineModel>, IDatelineRenderer> getRendererMap() {
        return this.rendererMap;
    }

    public void setRendererMap(Map<Class<? extends IDatelineModel>, IDatelineRenderer> map) {
        if (map == null) {
            throw new IllegalArgumentException("renderer map can not be NULL");
        }
        this.rendererMap = map;
    }

    public void setZoomClicks(int zoomClicks) {
        if (zoomClicks < 1) {
            throw new IllegalArgumentException("click count must be larger than 0");
        }
        this.zoomClicks = zoomClicks;
    }

    public int getZoomClicks() {
        return this.zoomClicks;
    }

    public Color getManualZoomColor() {
        return this.manualZoomColor;
    }

    public void setManualZoomColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color can not be NULL");
        }
        this.manualZoomColor = color;
    }

    public boolean isManualZoomEnabled() {
        return this.manualZoomEnabled;
    }

    public void setManualZoomEnabled(boolean enabled) {
        this.manualZoomEnabled = enabled;
    }

    public boolean isAnimatingZoom() {
        return this.animatingZoom;
    }

    public void setAnimatingZoom(boolean animate) {
        this.animatingZoom = animate;
    }

    public int getAnimationDuration() {
        return this.animationDuration;
    }

    public void setAnimationDuration(int duration) {
        if (this.animationDuration < 0) {
            throw new IllegalArgumentException("animation duration can not be negative");
        }
        this.animationDuration = duration;
    }

    class AnimateZoomTarget
    extends TimingTargetAdapter {
        private ITimeSpan visibleSpan;
        private ITimeSpan requestedSpan;
        private long deltaStart;
        private long deltaEnd;

        public AnimateZoomTarget(ITimeSpan visibleSpan, ITimeSpan requestedSpan) {
            this.visibleSpan = visibleSpan;
            this.requestedSpan = requestedSpan;
            this.deltaStart = requestedSpan.getStartTime() - visibleSpan.getStartTime();
            this.deltaEnd = requestedSpan.getEndTime() - visibleSpan.getEndTime();
        }

        public void begin() {
            Dateline.this.setFocusedTimeSpan(null);
        }

        public void timingEvent(float fraction) {
            long newStart = this.visibleSpan.getStartTime() + (long)(fraction * (float)this.deltaStart);
            long newEnd = this.visibleSpan.getEndTime() + (long)(fraction * (float)this.deltaEnd);
            try {
                Dateline.this.model.requestVisibleTimeSpan(new TimeSpan(newStart, newEnd));
            }
            catch (DatelineModelException ex) {
                LOGGER.throwing(AnimateZoomTarget.class.getName(), "timingEvent()", ex);
            }
        }

        public void end() {
            try {
                Dateline.this.model.requestVisibleTimeSpan(this.requestedSpan);
            }
            catch (DatelineModelException ex) {
                LOGGER.throwing(AnimateZoomTarget.class.getName(), "timingEvent()", ex);
            }
        }
    }

    public static enum ZoomStrategy {
        CHANGE_VISIBLE_END_TIME,
        CHANGE_VISIBLE_START_AND_END_TIME;

    }
}

