/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.timeline;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.dateline.DatelineModelEvent;
import com.dlsc.flexgantt.model.dateline.IDatelineModel;
import com.dlsc.flexgantt.model.dateline.IDatelineModelListener;
import com.dlsc.flexgantt.model.dateline.IGranularity;
import com.dlsc.flexgantt.swing.timeline.Timeline;
import com.dlsc.flexgantt.util.Messages;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractTimelineControlPanel<T extends IGranularity>
extends JPanel
implements ChangeListener,
ActionListener,
IDatelineModelListener {
    private JSpinner startTimeSpinner;
    private JSpinner endTimeSpinner;
    private JComboBox granularityBox;
    private SpinnerModel startTimeModel;
    private SpinnerModel endTimeModel;
    private ComboBoxModel granularityModel;
    private Timeline timeline;
    private JButton applyButton;
    private JLabel fromLabel;
    private JLabel toLabel;
    private JLabel granularityLabel;
    private Color toLabelColor;

    protected AbstractTimelineControlPanel(Timeline timeline, boolean showGranularity) {
        this.timeline = timeline;
        this.setBorder(this.createTitledBorder(Messages.getString("AbstractTimelineControlPanel.TIMELINE_SETTINGS_TITLE")));
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        this.fromLabel = new JLabel(Messages.getString("AbstractTimelineControlPanel.START_TIME"));
        this.toLabel = new JLabel(Messages.getString("AbstractTimelineControlPanel.END_TIME"));
        this.granularityLabel = new JLabel(Messages.getString("AbstractTimelineControlPanel.GRANULARITY"));
        this.startTimeModel = this.createStartTimeModel();
        this.endTimeModel = this.createEndTimeModel();
        this.granularityModel = this.createGranularityModel();
        this.startTimeSpinner = new JSpinner(this.startTimeModel);
        this.startTimeSpinner.addChangeListener(this);
        this.endTimeSpinner = new JSpinner(this.endTimeModel);
        this.endTimeSpinner.addChangeListener(this);
        this.granularityBox = new JComboBox(this.granularityModel);
        this.applyButton = new JButton(Messages.getString("AbstractTimelineControlPanel.APPLY_BUTTON"));
        this.applyButton.addActionListener(this);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.weightx = 0.0;
        this.add((Component)this.fromLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.weightx = 0.0;
        this.add((Component)this.toLabel, gbc);
        if (showGranularity) {
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(5, 5, 5, 5);
            gbc.weightx = 0.0;
            this.add((Component)this.granularityLabel, gbc);
        }
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add((Component)this.startTimeSpinner, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add((Component)this.endTimeSpinner, gbc);
        if (showGranularity) {
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.insets = new Insets(5, 5, 5, 5);
            gbc.weightx = 1.0;
            gbc.fill = 2;
            this.add((Component)this.granularityBox, gbc);
        }
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = showGranularity ? 3 : 2;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 17;
        this.add((Component)this.applyButton, gbc);
        timeline.getDateline().getModel().addDatelineModelListener(this);
        timeline.getDateline().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("datelineModel")) {
                    IDatelineModel oldModel = (IDatelineModel)evt.getOldValue();
                    IDatelineModel newModel = (IDatelineModel)evt.getNewValue();
                    oldModel.removeDatelineModelListener(AbstractTimelineControlPanel.this);
                    newModel.addDatelineModelListener(AbstractTimelineControlPanel.this);
                    AbstractTimelineControlPanel.this.updateControlPanel();
                }
            }
        });
        this.applyButton.setEnabled(this.isValidSettings());
    }

    @Override
    public void datelineModelChanged(DatelineModelEvent evt) {
        this.updateControlPanel();
    }

    @Override
    public void datelineModelWillChange(DatelineModelEvent evt) {
    }

    public abstract void updateControlPanel();

    protected abstract SpinnerModel createStartTimeModel();

    protected abstract SpinnerModel createEndTimeModel();

    protected abstract ComboBoxModel createGranularityModel();

    protected abstract void setTimeSpan(ITimeSpan var1);

    public abstract ITimeSpan getTimeSpan();

    public abstract boolean isValidSettings();

    public void setGranularity(T value) {
        this.getGranularityBox().setSelectedItem(value);
    }

    public T getGranularity() {
        return (T)((IGranularity)this.getGranularityBox().getSelectedItem());
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        if (this.isValidSettings()) {
            if (this.toLabelColor != null) {
                this.toLabel.setForeground(this.toLabelColor);
            }
            this.toLabelColor = null;
        } else {
            if (this.toLabelColor == null) {
                this.toLabelColor = this.toLabel.getForeground();
            }
            this.toLabel.setForeground(Color.RED);
        }
        this.applyButton.setEnabled(this.isValidSettings());
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.applySettings();
    }

    protected abstract void applySettings();

    public SpinnerModel getEndTimeModel() {
        return this.endTimeModel;
    }

    public JSpinner getEndTimeSpinner() {
        return this.endTimeSpinner;
    }

    public SpinnerModel getStartTimeModel() {
        return this.startTimeModel;
    }

    public JSpinner getStartTimeSpinner() {
        return this.startTimeSpinner;
    }

    public JComboBox getGranularityBox() {
        return this.granularityBox;
    }

    public ComboBoxModel getGranularityModel() {
        return this.granularityModel;
    }

    public Timeline getTimeline() {
        return this.timeline;
    }

    public JButton getApplyButton() {
        return this.applyButton;
    }

    public JLabel getFromLabel() {
        return this.fromLabel;
    }

    public JLabel getGranularityLabel() {
        return this.granularityLabel;
    }

    public JLabel getToLabel() {
        return this.toLabel;
    }

    protected Border createTitledBorder(String title) {
        Border b = UIManager.getBorder("TitledBorder.aquaVariant");
        if (b == null) {
            TitledBorder border = new TitledBorder(title);
            return border;
        }
        TitledBorder border = new TitledBorder(b, title);
        return border;
    }
}

