/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.selector;

import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.model.bookmarks.Bookmark;
import com.dlsc.flexgantt.model.bookmarks.BookmarkEvent;
import com.dlsc.flexgantt.model.bookmarks.IBookmarkModel;
import com.dlsc.flexgantt.model.bookmarks.IBookmarkModelListener;
import com.dlsc.flexgantt.model.dateline.DatelineModelException;
import com.dlsc.flexgantt.model.dateline.IDatelineModel;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.MessageTypeId;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.print.PrintContext;
import com.dlsc.flexgantt.swing.print.PrintGanttChart;
import com.dlsc.flexgantt.swing.selector.Selector;
import com.dlsc.flexgantt.util.Messages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class BookmarksSelector
extends Selector {
    private boolean preview = true;

    public BookmarksSelector(JComponent comp, LayerContainer lc) {
        super(Messages.getString("BookmarksSelector.TITLE"), comp, Selector.Location.LEFT);
        this.setContentComponent(new BookmarksPanel(lc));
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
        BookmarksPanel panel = (BookmarksPanel)this.getContentComponent();
        panel.setPreview(preview);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            BookmarksPanel panel = (BookmarksPanel)this.getContentComponent();
            panel.updateList();
        }
        super.setVisible(b);
    }

    private class BookmarksPanel
    extends JPanel
    implements IBookmarkModelListener {
        private JList list;
        private PrintContext printContext = new PrintContext();
        private AbstractGanttChart ganttChart;

        public BookmarksPanel(LayerContainer lc) {
            this.printContext.setGanttChart(lc.getGanttChart());
            this.printContext.setLayerContainer(lc);
            this.printContext.setRowHeader(lc.getTreeTable().getRowHeader());
            this.printContext.setTimeline(lc.getTimeline());
            this.printContext.setTreeTable(lc.getTreeTable());
            this.printContext.setTreeTableHeader(lc.getTreeTable().getTreeTableHeader());
            this.ganttChart = lc.getGanttChart();
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.list = new JList();
            this.list.setOpaque(false);
            this.list.setCellRenderer(new BookmarkListWrapperRenderer(BookmarksSelector.this.preview));
            this.list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 1) {
                        int index = BookmarksPanel.this.list.locationToIndex(e.getPoint());
                        BookmarkListWrapper wrapper = (BookmarkListWrapper)BookmarksPanel.this.list.getModel().getElementAt(index);
                        Bookmark bookmark = wrapper.getBookmark();
                        try {
                            BookmarksPanel.this.showBookmark(bookmark);
                        }
                        catch (DatelineModelException ex) {
                            BookmarksPanel.this.ganttChart.showMessage(Messages.getString("BookmarksSelector.UNABLE_TO_DISPLAY"), MessageTypeId.ERROR, ex);
                        }
                    }
                }
            });
            this.list.setBorder(new EmptyBorder(10, 10, 10, 10));
            JScrollPane scroll = new JScrollPane(this.list);
            scroll.setBorder(null);
            scroll.setOpaque(false);
            scroll.getViewport().setOpaque(false);
            scroll.setViewportBorder(null);
            scroll.getViewport().setBorder(null);
            this.add("Center", scroll);
            this.updateList();
        }

        public void setPreview(boolean preview) {
            this.list.setCellRenderer(new BookmarkListWrapperRenderer(preview));
            this.updateList();
        }

        private void showBookmark(Bookmark bookmark) throws DatelineModelException {
            IDatelineModel dateline = this.ganttChart.getDatelineModel();
            dateline.setGranularity(bookmark.getGranularity());
            dateline.setTimeSpan(bookmark.getTimeSpan());
            this.ganttChart.showTime(bookmark.getTimePoint(), false);
            BookmarksSelector.this.setVisible(false);
        }

        protected void updateList() {
            DefaultListModel<BookmarkListWrapper> listModel = new DefaultListModel<BookmarkListWrapper>();
            IBookmarkModel model = this.printContext.getLayerContainer().getBookmarkModel();
            int count = model.getBookmarkCount();
            for (int i = 0; i < count; ++i) {
                Bookmark bookmark = model.getBookmark(i);
                Icon icon = IconRegistry.getIcon(IconId.BOOKMARK);
                if (BookmarksSelector.this.preview) {
                    icon = this.createIcon(bookmark);
                }
                listModel.addElement(new BookmarkListWrapper(bookmark, icon));
            }
            this.list.setModel(listModel);
            this.list.setVisibleRowCount(Math.min(count, 3));
            if (count > 0) {
                this.setVisible(true);
                this.list.setVisibleRowCount(Math.min(10, count));
            } else {
                this.setVisible(false);
            }
        }

        private Icon createIcon(Bookmark bookmark) {
            this.printContext.setTimeSpan(bookmark.getTimeSpan());
            this.printContext.getTimeline().getDateline().setGranularity(bookmark.getGranularity());
            this.printContext.validate();
            PrintGanttChart pgc = new PrintGanttChart(this.printContext);
            int width = 200;
            int height = 120;
            AbstractGanttChart gc = this.printContext.getGanttChart();
            BufferedImage img = new BufferedImage(width, height, 2);
            double sf = Math.min((double)width / (double)gc.getWidth(), (double)height / (double)gc.getHeight());
            Graphics2D g2d = img.createGraphics();
            g2d.scale(sf, sf);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            pgc.print(g2d);
            g2d.setColor(Color.BLACK);
            g2d.scale(0.0, 0.0);
            g2d.drawRect(0, 0, width, height);
            return new ImageIcon(img);
        }

        @Override
        public void bookmarksChanged(BookmarkEvent evt) {
            this.updateList();
        }

        class BookmarkListWrapperRenderer
        extends DefaultListCellRenderer {
            public BookmarkListWrapperRenderer(boolean preview) {
                if (preview) {
                    this.setHorizontalAlignment(0);
                    this.setVerticalAlignment(0);
                    this.setHorizontalTextPosition(0);
                    this.setVerticalTextPosition(3);
                }
                this.setOpaque(false);
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                BookmarkListWrapper wrapper = (BookmarkListWrapper)value;
                this.setText(wrapper.getBookmark().getName());
                this.setIcon(wrapper.getIcon());
                return this;
            }
        }

        private class BookmarkListWrapper {
            private Bookmark bookmark;
            private Icon icon;

            public BookmarkListWrapper(Bookmark bookmark, Icon icon) {
                this.bookmark = bookmark;
                this.icon = icon;
            }

            public Bookmark getBookmark() {
                return this.bookmark;
            }

            public Icon getIcon() {
                return this.icon;
            }
        }
    }
}

