/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.mac;

import com.dlsc.flexgantt.swing.layer.DefaultLayerFactory;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.AbstractSystemLayer;
import com.dlsc.flexgantt.swing.layer.system.TimeNowLayer;
import java.awt.Color;
import java.awt.Graphics;

public class MacLayerFactory
extends DefaultLayerFactory {
    private static final MacLayerFactory instance = new MacLayerFactory();

    public static MacLayerFactory getInstance() {
        return instance;
    }

    @Override
    public <T extends AbstractSystemLayer> T createSystemLayer(LayerContainer lc, Class<T> layerType) {
        if (layerType == TimeNowLayer.class) {
            return (T)new MyTimeNowLayer(lc);
        }
        return super.createSystemLayer(lc, layerType);
    }

    class MyTimeNowLayer
    extends TimeNowLayer {
        public MyTimeNowLayer(LayerContainer lc) {
            super(lc);
        }

        @Override
        protected void paintTimeNow(Graphics g, int x) {
            Color c = new Color(255, 100, 100);
            g.setColor(c);
            g.drawLine(x - 1, 0, x - 1, this.getHeight());
            g.setColor(c.darker());
            g.drawLine(x, 0, x, this.getHeight());
            g.setColor(c);
            g.drawLine(x + 1, 0, x + 1, this.getHeight());
        }
    }
}

