/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.mac;

import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.model.gantt.DefaultResourceNode;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.treetable.ITreeTableModel;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.DefaultComponentFactory;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.LayerContainerRowHeader;
import com.dlsc.flexgantt.swing.layer.LayerContainerScrollPane;
import com.dlsc.flexgantt.swing.layer.system.DefaultResourceRowRenderer;
import com.dlsc.flexgantt.swing.layer.system.RowLayer;
import com.dlsc.flexgantt.swing.mac.EmphasizedLabelUI;
import com.dlsc.flexgantt.swing.mac.MacColumnHeaderRenderer;
import com.dlsc.flexgantt.swing.mac.MacDateline;
import com.dlsc.flexgantt.swing.mac.MacEventline;
import com.dlsc.flexgantt.swing.mac.MacLayerContainerRowHeader;
import com.dlsc.flexgantt.swing.mac.MacLayerFactory;
import com.dlsc.flexgantt.swing.mac.MacTimeGranularityDatelineRenderer;
import com.dlsc.flexgantt.swing.mac.MacTreeTableRowHeader;
import com.dlsc.flexgantt.swing.mac.MacTreeTableRowHeaderRenderer;
import com.dlsc.flexgantt.swing.selector.ISelectorFactory;
import com.dlsc.flexgantt.swing.selector.Selector;
import com.dlsc.flexgantt.swing.timeline.Dateline;
import com.dlsc.flexgantt.swing.timeline.Eventline;
import com.dlsc.flexgantt.swing.timeline.TimeGranularityDatelineModel;
import com.dlsc.flexgantt.swing.timeline.Timeline;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import com.dlsc.flexgantt.swing.treetable.TreeTableHeader;
import com.dlsc.flexgantt.swing.treetable.TreeTableRowHeader;
import com.dlsc.flexgantt.swing.treetable.TreeTableScrollPane;
import com.dlsc.flexgantt.swing.util.CornerStone;
import com.dlsc.flexgantt.swing.util.CustomizableLineBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class MacComponentFactory
extends DefaultComponentFactory {
    private static MacComponentFactory instance;
    private static Image glossyImage;

    protected MacComponentFactory() {
        try {
            glossyImage = ImageIO.read(MacComponentFactory.class.getResource("shiny_background.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static synchronized MacComponentFactory getInstance() {
        if (instance == null) {
            instance = new MacComponentFactory();
        }
        return instance;
    }

    @Override
    public LayerContainer createLayerContainer(AbstractGanttChart gc, TreeTable table, IGanttChartModel model) {
        LayerContainer lc = new LayerContainer(gc, model, table, new MacLayerFactory());
        lc.setBackground(Color.WHITE);
        lc.setAlternatingBackground(new Color(240, 240, 240));
        lc.setTimelineObjectStatusColor("ERROR", Color.RED);
        lc.setTimelineObjectStatusIcon("WARNING", IconRegistry.getIcon(IconId.WARNING));
        DefaultResourceRowRenderer rowRenderer = new DefaultResourceRowRenderer();
        rowRenderer.setMajorCapacityLineColor(Color.LIGHT_GRAY);
        RowLayer rl = lc.getSystemLayer(RowLayer.class);
        rl.setRowRenderer(DefaultResourceNode.class, rowRenderer);
        return lc;
    }

    @Override
    public JComponent createLayerContainerCorner(LayerContainer lc, String corner) {
        if (corner.equals("UPPER_LEFT_CORNER")) {
            JPanel control = new JPanel(){

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    MacComponentFactory.paintGlossyBackground(this, g, this.getWidth(), this.getHeight());
                }
            };
            control.setBorder(new CustomizableLineBorder(true, false, true, true));
            control.setBackground(new Color(230, 230, 230));
            return control;
        }
        return super.createLayerContainerCorner(lc, corner);
    }

    @Override
    public LayerContainerRowHeader createLayerContainerRowHeader(LayerContainer lc) {
        MacLayerContainerRowHeader header = new MacLayerContainerRowHeader(lc);
        header.setBackground(new Color(230, 230, 230));
        header.setBorder(new CustomizableLineBorder(false, false, false, true));
        return header;
    }

    @Override
    public TreeTable createTreeTable(AbstractGanttChart gc, ITreeTableModel model) {
        TreeTable table = super.createTreeTable(gc, model);
        table.setRootVisible(true);
        table.setBackground(Color.WHITE);
        table.setAlternatingBackground(new Color(240, 240, 240));
        return table;
    }

    @Override
    public Dateline createDateline(Timeline timeline) {
        MacDateline dateline = new MacDateline(timeline);
        dateline.setOpaque(false);
        dateline.setDatelineRenderer(TimeGranularityDatelineModel.class, new MacTimeGranularityDatelineRenderer());
        return dateline;
    }

    @Override
    public Eventline createEventline(Timeline timeline, Dateline dateline) {
        MacEventline eventline = new MacEventline(timeline, dateline);
        eventline.setOpaque(false);
        return eventline;
    }

    @Override
    public TreeTableRowHeader createTreeTableRowHeader(TreeTable table) {
        MacTreeTableRowHeader header = new MacTreeTableRowHeader(table);
        header.setBackground(new Color(230, 230, 230));
        header.setBorder(new CustomizableLineBorder(false, false, false, true));
        MacTreeTableRowHeaderRenderer renderer = new MacTreeTableRowHeaderRenderer();
        renderer.setShowingSelection(false);
        renderer.setShowingFocus(false);
        header.setRowHeaderRenderer(Object.class, renderer);
        return header;
    }

    @Override
    public TreeTableHeader createTreeTableHeader(AbstractGanttChart gc) {
        TreeTableHeader header = super.createTreeTableHeader(gc);
        header.setBackground(Color.WHITE);
        header.setColumnHeaderRenderer(Object.class, new MacColumnHeaderRenderer());
        return header;
    }

    @Override
    public JComponent createTreeTableCorner(TreeTable table, String corner) {
        JPanel comp = null;
        if (corner.equals("UPPER_RIGHT_CORNER")) {
            comp = new CornerStone(table.getGanttChart());
            comp.setBorder(new CustomizableLineBorder(true, false, true, true));
        } else if (corner.equals("LOWER_RIGHT_CORNER")) {
            comp = new CornerStone(table.getGanttChart());
        } else if (corner.equals("LOWER_LEFT_CORNER")) {
            comp = new CornerStone(table.getGanttChart());
            comp.setBorder(new CustomizableLineBorder(false, false, false, true));
        } else if (corner.equals("UPPER_LEFT_CORNER")) {
            final JPanel control = new JPanel(){

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    MacComponentFactory.paintGlossyBackground(this, g, this.getWidth(), this.getHeight());
                }
            };
            control.setBorder(new CustomizableLineBorder(true, false, true, true));
            final TreeTable fTable = table;
            control.addMouseListener(new MouseAdapter(){
                private Selector selector;

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (this.selector == null) {
                        ISelectorFactory sf = fTable.getGanttChart().getSelectorFactory();
                        this.selector = sf.createSelector(fTable.getGanttChart(), (JComponent)control, ISelectorFactory.SelectorID.COLUMNS);
                    }
                    this.selector.setVisible(!this.selector.isVisible());
                    this.selector.requestFocusInWindow();
                }
            });
            comp = control;
        }
        comp.setBackground(new Color(230, 230, 230));
        return comp;
    }

    @Override
    public Timeline createTimeline(AbstractGanttChart gc) {
        Timeline timeline = new Timeline(gc){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                MacComponentFactory.paintGlossyBackground(this, g, this.getWidth(), this.getHeight());
            }
        };
        return timeline;
    }

    public static void makeEmphasizedLabelsRecursively(Component comp) {
        if (comp instanceof JLabel) {
            MacComponentFactory.makeEmphasizedLabel((JLabel)comp);
        } else if (comp instanceof Container) {
            Container container = (Container)comp;
            for (Component child : container.getComponents()) {
                MacComponentFactory.makeEmphasizedLabelsRecursively(child);
            }
        }
    }

    public static JLabel createEmphasizedLabel(String text) {
        return MacComponentFactory.makeEmphasizedLabel(new JLabel(text));
    }

    public static JLabel makeEmphasizedLabel(JLabel label) {
        label.setUI(new EmphasizedLabelUI());
        return label;
    }

    public static JLabel makeEmphasizedLabel(JLabel label, Color focusedColor, Color unfocusedColor, Color emphasisColor) {
        label.setUI(new EmphasizedLabelUI(focusedColor, unfocusedColor, emphasisColor));
        return label;
    }

    @Override
    public LayerContainerScrollPane createLayerContainerScrollPane(LayerContainer lc, LayerContainerRowHeader rowHeader, Timeline timeline, boolean primary) {
        LayerContainerScrollPane pane = super.createLayerContainerScrollPane(lc, rowHeader, timeline, primary);
        pane.setBorder(BorderFactory.createEmptyBorder());
        return pane;
    }

    @Override
    public TreeTableScrollPane createTreeTableScrollPane(TreeTable table, TreeTableRowHeader rowHeader, TreeTableHeader header, boolean primary) {
        TreeTableScrollPane pane = super.createTreeTableScrollPane(table, rowHeader, header, primary);
        pane.setBorder(BorderFactory.createEmptyBorder());
        return pane;
    }

    @Override
    public JSplitPane createSplitPane() {
        JSplitPane pane = super.createSplitPane();
        pane.setContinuousLayout(true);
        pane.setBorder(BorderFactory.createEmptyBorder());
        if (pane.getUI() instanceof BasicSplitPaneUI) {
            ((BasicSplitPaneUI)pane.getUI()).getDivider().setBorder(new Border(){
                private Insets insets = new Insets(1, 1, 1, 1);

                @Override
                public Insets getBorderInsets(Component c) {
                    return this.insets;
                }

                @Override
                public boolean isBorderOpaque() {
                    return false;
                }

                @Override
                public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                    Graphics2D g2d = (Graphics2D)g;
                    g2d.setPaint(new GradientPaint(x, y, Color.WHITE, x + width, x, Color.LIGHT_GRAY));
                    g2d.fillRect(x, y, width, height);
                    g2d.setColor(Color.LIGHT_GRAY);
                    g2d.drawLine(x, y, x, y + height);
                    g2d.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
                }
            });
        }
        return pane;
    }

    public static void paintGlossyBackground(Component comp, Graphics g, int w, int h) {
        g.drawImage(glossyImage, 0, 0, w, h, comp);
    }
}

