/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.timeline;

import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.swing.layer.timeline.ITimelineObjectSelectionModel;
import java.util.EventObject;
import java.util.List;

public class TimelineObjectSelectionEvent
extends EventObject {
    private List<TimelineObjectPath> paths;
    private ID id;

    public TimelineObjectSelectionEvent(ITimelineObjectSelectionModel model, ID id, List<TimelineObjectPath> paths) {
        super(model);
        if (id == null) {
            throw new IllegalArgumentException("ID can not be NULL");
        }
        if (paths == null) {
            throw new IllegalArgumentException("timeline object paths can not be NULL");
        }
        this.id = id;
        this.paths = paths;
    }

    public List<TimelineObjectPath> getTimelineObjectPaths() {
        return this.paths;
    }

    public ID getId() {
        return this.id;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("\n\t");
        sb.append((Object)this.id);
        sb.append("\n\ttimeline object paths:");
        for (TimelineObjectPath path : this.paths) {
            sb.append("\n\t\t");
            sb.append(path);
        }
        return sb.toString();
    }

    public static enum ID {
        TIMELINE_OBJECTS_ADDED,
        TIMELINE_OBJECTS_REMOVED;

    }
}

