/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.timeline;

import com.dlsc.flexgantt.model.gantt.ICapacityObject;
import com.dlsc.flexgantt.model.gantt.IResourceNode;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.swing.layer.timeline.ITimelineObjectRenderer;
import com.dlsc.flexgantt.swing.layer.timeline.TimelineObjectLayer;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Stroke;
import javax.swing.JPanel;

public class DefaultCapacityObjectRenderer
extends JPanel
implements ITimelineObjectRenderer {
    private ICapacityObject capacityObject;
    private final Insets insets = new Insets(0, 0, 0, 0);
    private Color fillColor = new Color(180, 180, 235);
    private Color focusColor = Color.BLACK;
    private Color overallocationFillColor = new Color(255, 0, 0);
    private Color pastFillColor = Color.GRAY;
    private Color selectionFillColor = new Color(235, 180, 180);
    private Color highlightFillColor = new Color(235, 235, 180);
    private boolean selected;
    private boolean focus;
    private boolean highlighted;
    private int row;
    private TimelineObjectLayer layer;
    private IResourceNode node;
    private TimelineObjectPath timelineObjectPath;

    public DefaultCapacityObjectRenderer() {
        this.setLayout(null);
    }

    @Override
    public Component getTimelineObjectRendererComponent(TimelineObjectLayer layer, TimelineObjectPath path, boolean selected, boolean hasFocus, boolean highlighted, int row) {
        this.timelineObjectPath = path;
        this.node = (IResourceNode)path.getLastPathComponent();
        this.layer = layer;
        this.selected = selected;
        this.focus = hasFocus;
        this.highlighted = highlighted;
        this.capacityObject = (ICapacityObject)path.getTimelineObject();
        this.row = row;
        return this;
    }

    @Override
    public Insets getTimelineObjectRendererInsets(int x, int y, int width, int height) {
        int y2;
        int y1 = this.node.getCapacityLocation(height, this.capacityObject.getCapacityUsed());
        if (y1 <= (y2 = this.node.getCapacityLocation(height, 0.0))) {
            this.insets.top = y1;
            this.insets.bottom = height - y2;
        } else {
            this.insets.top = y2;
            this.insets.bottom = height - y1;
        }
        return this.insets;
    }

    @Override
    protected void paintComponent(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        Graphics2D g2d = (Graphics2D)g;
        if (this.highlighted) {
            g2d.setPaint(this.highlightFillColor);
        } else if (this.selected) {
            g2d.setPaint(this.selectionFillColor);
        } else {
            g2d.setPaint(this.fillColor);
        }
        double max = this.node.getMaximumCapacity();
        if (this.capacityObject.getCapacityUsed() > max) {
            g2d.setPaint(this.overallocationFillColor);
        }
        g2d.fillRect(0, 0, w, h);
        if (this.focus) {
            Composite comp = g2d.getComposite();
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
            Stroke stroke = g2d.getStroke();
            g2d.setStroke(new BasicStroke(2.0f));
            g2d.setColor(this.focusColor);
            g2d.drawRect(1, 1, w - 2, h - 2);
            g2d.setStroke(stroke);
            g2d.setComposite(comp);
        }
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
    }

    public Color getFocusColor() {
        return this.focusColor;
    }

    public void setFocusColor(Color color) {
        this.focusColor = color;
    }

    public Color getHighlightFillColor() {
        return this.highlightFillColor;
    }

    public void setHighlightFillColor(Color color) {
        this.highlightFillColor = color;
    }

    public Color getPastFillColor() {
        return this.pastFillColor;
    }

    public void setPastFillColor(Color color) {
        this.pastFillColor = color;
    }

    public Color getSelectionFillColor() {
        return this.selectionFillColor;
    }

    public void setSelectionFillColor(Color color) {
        this.selectionFillColor = color;
    }

    @Override
    public boolean hasFocus() {
        return this.focus;
    }

    protected ICapacityObject getCapacityObject() {
        return this.capacityObject;
    }

    protected boolean isSelected() {
        return this.selected;
    }

    protected boolean isHighlighted() {
        return this.highlighted;
    }

    protected int getRow() {
        return this.row;
    }

    protected TimelineObjectLayer getLayer() {
        return this.layer;
    }

    @Override
    public void validate() {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void repaint() {
    }

    @Override
    public void repaint(int x, int y, int width, int height) {
    }

    @Override
    public void repaint(long tm) {
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    public Color getOverallocationFillColor() {
        return this.overallocationFillColor;
    }

    public void setOverallocationFillColor(Color overallocationFillColor) {
        this.overallocationFillColor = overallocationFillColor;
    }

    public TimelineObjectPath getTimelineObjectPath() {
        return this.timelineObjectPath;
    }
}

