/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.timeline;

import com.dlsc.flexgantt.model.gantt.IActivityObject;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.swing.layer.timeline.DefaultTimelineObjectRenderer;
import com.dlsc.flexgantt.swing.layer.timeline.TimelineObjectLayer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;

public class DefaultActivityObjectRenderer
extends DefaultTimelineObjectRenderer {
    private Color percentageFillColor1 = new Color(203, 218, 245).darker();
    private Color percentageFillColor2 = new Color(153, 183, 236).darker();
    private IActivityObject activityObject;

    public DefaultActivityObjectRenderer() {
        this.setForeground(Color.BLACK);
        this.setFont(new Font("helvetica", 1, 9));
    }

    @Override
    public Component getTimelineObjectRendererComponent(TimelineObjectLayer layer, TimelineObjectPath path, boolean selected, boolean hasFocus, boolean highlighted, int row) {
        super.getTimelineObjectRendererComponent(layer, path, selected, hasFocus, highlighted, row);
        this.activityObject = (IActivityObject)path.getTimelineObject();
        return this;
    }

    @Override
    protected void paintActivityContent(Graphics g) {
        super.paintActivityContent(g);
        Color fillColor1Old = this.getActivityFillColor1();
        Color fillColor2Old = this.getActivityFillColor2();
        double p = this.activityObject.getPercentageComplete();
        int x = (int)((double)this.getWidth() / 100.0 * p);
        this.setActivityFillColor1(this.percentageFillColor1);
        this.setActivityFillColor2(this.percentageFillColor2);
        Shape clip = g.getClip();
        g.clipRect(0, 0, x, this.getHeight());
        super.paintActivityContent(g);
        this.setActivityFillColor1(fillColor1Old);
        this.setActivityFillColor2(fillColor2Old);
        g.setClip(clip);
        if (x < this.getWidth() - 6 || !this.isRoundedCorners()) {
            g.setColor(this.getActivityLineColor());
            g.drawLine(x - 1, 2, x - 1, this.getHeight() - 2);
        }
    }

    @Override
    protected void paintActivityFocus(Graphics g) {
        super.paintActivityFocus(g);
        Graphics2D g2d = (Graphics2D)g;
        double p = this.activityObject.getPercentageComplete();
        int x = Math.max(4, (int)((double)this.getWidth() / 100.0 * p));
        int h = this.getHeight() - 1;
        int[] xx = new int[]{x - 4, x - 4, x, x + 4, x + 4, x - 4};
        int[] yy = new int[]{h, h - 4, h - 8, h - 4, h, h};
        g2d.setColor(new Color(240, 240, 240));
        g2d.fillPolygon(xx, yy, 6);
        g2d.setColor(Color.BLACK);
        g2d.drawPolygon(xx, yy, 6);
    }

    public Color getPercentageFillColor1() {
        return this.percentageFillColor1;
    }

    public void setPercentageFillColor1(Color color) {
        this.percentageFillColor1 = color;
    }

    public Color getPercentageFillColor2() {
        return this.percentageFillColor2;
    }

    public void setPercentageFillColor2(Color color) {
        this.percentageFillColor2 = color;
    }

    protected IActivityObject getActivityObject() {
        return this.activityObject;
    }
}

