/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.system;

import com.dlsc.flexgantt.model.dateline.GridLine;
import com.dlsc.flexgantt.model.dateline.IDatelineModel;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.layer.IGridLinePolicy;
import com.dlsc.flexgantt.policy.treetable.IRowPolicy;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.AbstractSystemLayer;
import com.dlsc.flexgantt.swing.timeline.Dateline;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import com.dlsc.flexgantt.swing.treetable.TreeTableNode;
import com.dlsc.flexgantt.swing.util.ColorUtil;
import com.dlsc.flexgantt.util.GridLineMode;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;

public class GridLayer
extends AbstractSystemLayer
implements PropertyChangeListener {
    public static final String PROPERTY_MAJOR_GRID_COLOR = "majorGridColor";
    public static final String PROPERTY_MINOR_GRID_COLOR = "minorGridColor";
    public static final String PROPERTY_HORIZONTAL_LINE_COLOR = "horizontalLineColor";
    private Color majorGridColor = ColorUtil.getGridColor().darker();
    private Color minorGridColor = ColorUtil.getGridColor();
    private boolean thickMajorGridLines = true;
    private boolean verticalLinesOnTop = true;
    private Color horizontalLineColor = ColorUtil.getGridColor();
    private boolean horizontalLinesVisible = true;

    public GridLayer(LayerContainer lc) {
        super("Grid", lc);
        this.getGanttChart().addPropertyChangeListener(this);
    }

    @Override
    protected void paintLayer(Graphics g) {
        super.paintLayer(g);
        Graphics2D g2d = (Graphics2D)g;
        Composite comp = g2d.getComposite();
        g2d.setComposite(AlphaComposite.getInstance(3, this.alpha));
        if (this.verticalLinesOnTop) {
            this.paintHorizontalLines(g);
            this.paintVerticalLines(g);
        } else {
            this.paintVerticalLines(g);
            this.paintHorizontalLines(g);
        }
        g2d.setComposite(comp);
    }

    protected void paintVerticalLines(Graphics g) {
        int x;
        Rectangle clip = g.getClipBounds();
        Dateline dateline = this.getDateline();
        IDatelineModel gridModel = dateline.getModel();
        List<GridLine> majorGrid = null;
        List<GridLine> minorGrid = null;
        GridLineMode mode = this.ganttChart.getGridLineMode();
        switch (mode) {
            case MAJOR_GRID_LINES: {
                majorGrid = gridModel.getGrid(clip.x, clip.x + clip.width, true);
                break;
            }
            case MINOR_GRID_LINES: {
                minorGrid = gridModel.getGrid(clip.x, clip.x + clip.width, false);
                break;
            }
            case COMBINED_GRID_LINES: {
                majorGrid = gridModel.getGrid(clip.x, clip.x + clip.width, true);
                minorGrid = gridModel.getGrid(clip.x, clip.x + clip.width, false);
                break;
            }
        }
        IPolicyProvider pp = this.layerContainer.getPolicyProvider();
        IGridLinePolicy gp = pp.getPolicy(IGridLinePolicy.class);
        IDatelineModel datelineModel = this.ganttChart.getDatelineModel();
        if (minorGrid != null && gp.isMinorGridLinesVisible(datelineModel, mode)) {
            g.setColor(this.getMinorGridColor());
            for (GridLine gl : minorGrid) {
                x = gl.getLocation();
                g.drawLine(x, clip.y, x, clip.y + clip.height);
            }
        }
        if (majorGrid != null && gp.isMajorGridLinesVisible(datelineModel, mode)) {
            g.setColor(this.getMajorGridColor());
            for (GridLine gl : majorGrid) {
                x = gl.getLocation();
                if (x < 0) continue;
                g.drawLine(x, clip.y, x, clip.y + clip.height);
                if (!this.thickMajorGridLines) continue;
                g.drawLine(x + 1, clip.y, x + 1, clip.y + clip.height);
            }
        }
    }

    protected void paintHorizontalLines(Graphics g) {
        if (this.isHorizontalLinesVisible()) {
            Rectangle clip = g.getClipBounds();
            int y = 0;
            if (this.layerContainer.hasClipNodes()) {
                IPolicyProvider pp = this.getTreeTablePolicyProvider();
                IRowPolicy rp = pp.getPolicy(IRowPolicy.class);
                IGanttChartModel model = this.getModel();
                int clipLine = 0;
                for (TreeTableNode node : this.layerContainer.getClipNodes()) {
                    if (y == 0) {
                        y = node.getY();
                    }
                    g.setColor(this.horizontalLineColor);
                    g.clipRect(0, Math.max(clipLine, y), this.getWidth(), this.getHeight());
                    int rowHeight = node.getHeight();
                    if (rp.isRowLineVisible(node.getModelNode(), node.isExpanded(), model)) {
                        g.drawLine(clip.x, y + rowHeight - 1, clip.x + clip.width - 1, y + rowHeight - 1);
                    }
                    g.setClip(clip);
                    y += node.getHeight();
                    TreeTable table = this.getTreeTable();
                    if (node != table.getAnimationNode()) continue;
                    clipLine = y;
                    y -= (int)((double)node.getTotalChildrenHeight() * (1.0 - table.getAnimationPercentage()));
                }
            }
            g.setClip(clip);
            int defaultRowHeight = this.getTreeTable().getDefaultRowHeight();
            g.setColor(this.horizontalLineColor);
            while (y < clip.y + clip.height + 1) {
                g.drawLine(clip.x, y - 1, clip.x + clip.width, y - 1);
                y += defaultRowHeight;
            }
        }
    }

    public boolean isThickMajorGridLines() {
        return this.thickMajorGridLines;
    }

    public void setThickMajorGridLines(boolean thickMajorGridLines) {
        this.thickMajorGridLines = thickMajorGridLines;
    }

    public boolean isVerticalLinesOnTop() {
        return this.verticalLinesOnTop;
    }

    public void setVerticalLinesOnTop(boolean verticalLinesOnTop) {
        this.verticalLinesOnTop = verticalLinesOnTop;
    }

    public void setMajorGridColor(Color color) {
        Color oldColor = this.majorGridColor;
        this.majorGridColor = color;
        this.changeSupport.firePropertyChange(PROPERTY_MAJOR_GRID_COLOR, oldColor, this.majorGridColor);
    }

    public Color getMajorGridColor() {
        return this.majorGridColor;
    }

    public void setMinorGridColor(Color color) {
        Color oldColor = this.minorGridColor;
        this.minorGridColor = color;
        this.changeSupport.firePropertyChange(PROPERTY_MINOR_GRID_COLOR, oldColor, this.minorGridColor);
    }

    public Color getMinorGridColor() {
        return this.minorGridColor;
    }

    public Color getHorizontalLineColor() {
        return this.horizontalLineColor;
    }

    public void setHorizontalLineColor(Color color) {
        Color oldColor = this.horizontalLineColor;
        this.horizontalLineColor = color;
        this.changeSupport.firePropertyChange(PROPERTY_HORIZONTAL_LINE_COLOR, oldColor, this.horizontalLineColor);
    }

    public boolean isHorizontalLinesVisible() {
        return this.horizontalLinesVisible;
    }

    public void setHorizontalLinesVisible(boolean visible) {
        this.horizontalLinesVisible = visible;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        AbstractGanttChart gc = this.getGanttChart();
        if (evt.getSource().equals(gc) && evt.getPropertyName().equals("gridLineMode")) {
            this.setVisible(gc.getGridLineMode() != GridLineMode.NO_GRID_LINES);
            this.repaint();
        }
    }
}

