/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.system;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.eventline.IEventlineModel;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.AbstractSystemLayer;
import com.dlsc.flexgantt.swing.timeline.Dateline;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class EventlineLayer
extends AbstractSystemLayer {
    private static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f, 2, 1, 0.0f, new float[]{4.0f, 4.0f}, 0.0f);
    private static final Paint DEFAULT_PAINT = Color.GREEN.darker().darker();
    private Map<Class, Paint> paintMap = new HashMap<Class, Paint>();
    private Map<Class, Paint> paintCache = new HashMap<Class, Paint>();
    private Map<Class, Stroke> strokeMap = new HashMap<Class, Stroke>();
    private Map<Class, Stroke> strokeCache = new HashMap<Class, Stroke>();
    private boolean paintingEvents = true;
    private boolean paintingActivities = true;

    public EventlineLayer(LayerContainer lc) {
        super("Eventline", lc);
        this.setAlpha(0.5f);
    }

    @Override
    protected void paintLayer(Graphics g) {
        Dateline dateline = this.getDateline();
        Rectangle visibleRect = this.layerContainer.getVisibleRect();
        long t1 = dateline.getTimeAt(visibleRect.x);
        long t2 = dateline.getTimeAt(visibleRect.x + visibleRect.width);
        TimeSpan visibleSpan = new TimeSpan(t1, t2);
        IEventlineModel model = this.getEventline().getModel();
        Iterator iterator = model.getEventlineObjectsIterator(visibleSpan);
        Rectangle clip = g.getClipBounds();
        Graphics2D g2d = (Graphics2D)g;
        Composite prevComp = g2d.getComposite();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            Stroke stroke = g2d.getStroke();
            g2d.setStroke(this.getStroke(obj.getClass()));
            g2d.setPaint(this.getPaint(obj.getClass()));
            ITimeSpan span = model.getTimeSpan(obj);
            int x = dateline.getTimeLocation(span.getStartTime());
            if (span.isActivity() && this.paintingActivities) {
                int width = dateline.getTimeLocation(span.getEndTime()) - x;
                g2d.setComposite(AlphaComposite.getInstance(3, this.getAlpha()));
                g2d.fillRect(x, clip.y, width, clip.height);
                g2d.setComposite(prevComp);
            } else if (span.isEvent() && this.paintingEvents) {
                g2d.drawLine(x, 0, x, this.layerContainer.getHeight());
            }
            g2d.setStroke(stroke);
        }
        super.paintLayer(g);
    }

    public void setPaint(Class eventlineObjectType, Paint paint) {
        this.paintMap.put(eventlineObjectType, paint);
        this.paintCache.clear();
    }

    public Paint getPaint(Class cl) {
        if (cl == null) {
            return DEFAULT_PAINT;
        }
        Paint paint = this.paintCache.get(cl);
        if (paint != null) {
            return paint;
        }
        paint = this.paintMap.get(cl);
        if (paint != null) {
            this.paintCache.put(cl, paint);
            return paint;
        }
        return this.getPaint(cl.getSuperclass());
    }

    public void setStroke(Class eventlineObjectType, Stroke paint) {
        this.strokeMap.put(eventlineObjectType, paint);
        this.strokeCache.clear();
    }

    public Stroke getStroke(Class cl) {
        if (cl == null) {
            return DEFAULT_STROKE;
        }
        Stroke stroke = this.strokeCache.get(cl);
        if (stroke != null) {
            return stroke;
        }
        stroke = this.strokeMap.get(cl);
        if (stroke != null) {
            this.strokeCache.put(cl, stroke);
            return stroke;
        }
        return this.getStroke(cl.getSuperclass());
    }

    public boolean isPaintingActivities() {
        return this.paintingActivities;
    }

    public void setPaintingActivities(boolean paint) {
        this.paintingActivities = paint;
    }

    public boolean isPaintingEvents() {
        return this.paintingEvents;
    }

    public void setPaintingEvents(boolean paint) {
        this.paintingEvents = paint;
    }
}

