/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.system;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.gantt.CapacityLine;
import com.dlsc.flexgantt.model.gantt.IResourceNode;
import com.dlsc.flexgantt.swing.layer.system.DefaultRowRenderer;
import com.dlsc.flexgantt.swing.layer.system.RowLayer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.List;

public class DefaultResourceRowRenderer
extends DefaultRowRenderer {
    private IResourceNode resourceNode;
    private Color majorCapacityLineColor = Color.GRAY;
    private Color minorCapacityLineColor = Color.LIGHT_GRAY;
    private boolean paintMajorCapacityLines = true;
    private boolean paintMinorCapacityLines = true;

    public DefaultResourceRowRenderer() {
        this.setOpaque(false);
        this.setFocusVisible(true);
    }

    public Color getMajorCapacityLineColor() {
        return this.majorCapacityLineColor;
    }

    public void setMajorCapacityLineColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("major capacity line color can not be NULL");
        }
        this.majorCapacityLineColor = color;
    }

    public Color getMinorCapacityLineColor() {
        return this.minorCapacityLineColor;
    }

    public void setMinorCapacityLineColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("minor capacity line color can not be NULL");
        }
        this.minorCapacityLineColor = color;
    }

    @Override
    public Component getRowRendererComponent(RowLayer layer, Object node, boolean selected, int row, ITimeSpan span, boolean hasFocus) {
        super.getRowRendererComponent(layer, node, selected, row, span, hasFocus);
        this.resourceNode = (IResourceNode)node;
        this.setOpaque(this.hasFocus() || selected && this.isShowingSelection());
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isPaintMinorCapacityLines()) {
            g.setColor(this.minorCapacityLineColor);
            this.paintLines(g, false);
        }
        if (this.isPaintMajorCapacityLines()) {
            g.setColor(this.majorCapacityLineColor);
            this.paintLines(g, true);
        }
    }

    protected void paintLines(Graphics g, boolean major) {
        Rectangle bounds = g.getClipBounds();
        int height = this.getHeight() - 1;
        List<CapacityLine> capLines = this.resourceNode.getCapacityLines(height, major);
        int xx = bounds.x;
        for (CapacityLine line : capLines) {
            int y = this.resourceNode.getCapacityLocation(height, line.getCapacity());
            if (major) {
                g.setColor(this.majorCapacityLineColor);
            } else {
                g.setColor(this.minorCapacityLineColor);
            }
            g.drawLine(xx, y, bounds.x + bounds.width, y);
        }
    }

    protected IResourceNode getResourceNode() {
        return this.resourceNode;
    }

    public boolean isPaintMajorCapacityLines() {
        return this.paintMajorCapacityLines;
    }

    public void setPaintMajorCapacityLines(boolean paintMajorCapacityLines) {
        this.paintMajorCapacityLines = paintMajorCapacityLines;
    }

    public boolean isPaintMinorCapacityLines() {
        return this.paintMinorCapacityLines;
    }

    public void setPaintMinorCapacityLines(boolean paintMinorCapacityLines) {
        this.paintMinorCapacityLines = paintMinorCapacityLines;
    }
}

