/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.system;

import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.IActionProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;

public class DefaultActionProvider
implements IActionProvider {
    private Map<Class, List<Action>> actionMap;

    @Override
    public List<Action> getTimelineObjectActions(LayerContainer lc, TimelineObjectPath path) {
        if (lc == null) {
            throw new IllegalArgumentException("layer container can not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("path can not be null");
        }
        if (this.actionMap != null) {
            Class<?> cl = path.getTimelineObject().getClass();
            do {
                if (!this.actionMap.containsKey(cl)) continue;
                return this.actionMap.get(cl);
            } while (!(cl = cl.getSuperclass()).equals(Object.class));
        }
        return null;
    }

    public void addAction(Class timelineObjectType, Action ... action) {
        List<Action> list;
        if (this.actionMap == null) {
            this.actionMap = new HashMap<Class, List<Action>>();
        }
        if ((list = this.actionMap.get(timelineObjectType)) == null) {
            list = new ArrayList<Action>();
            this.actionMap.put(timelineObjectType, list);
        }
        for (Action a : action) {
            list.add(a);
        }
    }

    public void setActions(Class timelineObjectType, List<Action> actions) {
        if (this.actionMap != null) {
            this.actionMap.remove(timelineObjectType);
        }
        for (Action a : actions) {
            this.addAction(timelineObjectType, a);
        }
    }

    public void removeAction(Class timelineObjectType, Action ... action) {
        List<Action> list;
        if (this.actionMap != null && (list = this.actionMap.get(timelineObjectType)) != null) {
            for (Action a : action) {
                list.remove(a);
            }
        }
    }
}

