/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.system;

import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.AbstractSystemLayer;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import com.dlsc.flexgantt.swing.treetable.TreeTableNode;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.util.List;

public class BackgroundLayer
extends AbstractSystemLayer {
    private Image texture;
    private TexturePaint texturePaint;

    public BackgroundLayer(LayerContainer lc) {
        super("Background", lc);
    }

    @Override
    protected void paintLayer(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Rectangle clip = g.getClipBounds();
        if (this.texturePaint != null) {
            g2d.setPaint(this.texturePaint);
        } else {
            g2d.setColor(this.layerContainer.getBackground());
        }
        g2d.fillRect(clip.x, clip.y, clip.width, clip.height);
        Color alternatingBackgroundColor = this.layerContainer.getAlternatingBackground();
        if (alternatingBackgroundColor != null) {
            Composite comp = g2d.getComposite();
            g2d.setComposite(AlphaComposite.getInstance(3, this.alpha));
            int row = 0;
            int y = 0;
            if (this.layerContainer.hasClipNodes()) {
                List<TreeTableNode> clipNodes = this.layerContainer.getClipNodes();
                int clipLine = 0;
                for (TreeTableNode node : clipNodes) {
                    if (y == 0) {
                        y = node.getY();
                    }
                    g.clipRect(0, Math.max(clipLine, y), this.getWidth(), this.getHeight());
                    row = node.getRow();
                    int rowHeight = node.getHeight();
                    if (row % 2 == 1) {
                        g2d.setColor(alternatingBackgroundColor);
                        g2d.fillRect(clip.x, y, clip.width, rowHeight);
                    }
                    g.setClip(clip);
                    y += node.getHeight();
                    TreeTable table = this.getTreeTable();
                    if (node != table.getAnimationNode()) continue;
                    clipLine = y;
                    y -= (int)((double)node.getTotalChildrenHeight() * (1.0 - table.getAnimationPercentage()));
                }
                ++row;
            }
            g.setClip(clip);
            TreeTable table = this.getTreeTable();
            int defaultRowHeight = table.getDefaultRowHeight();
            g2d.setColor(alternatingBackgroundColor);
            while (y < clip.y + clip.height) {
                if (row % 2 == 1) {
                    g2d.fillRect(clip.x, y, clip.width, defaultRowHeight);
                }
                y += defaultRowHeight;
                ++row;
            }
            g2d.setComposite(comp);
        }
        super.paintLayer(g);
    }

    public Image getTexture() {
        return this.texture;
    }

    public void setTexture(Image texture) {
        this.texture = texture;
        if (texture != null) {
            BufferedImage buffer = new BufferedImage(texture.getWidth(this.layerContainer), texture.getHeight(this.layerContainer), 1);
            Graphics2D bg = buffer.createGraphics();
            bg.drawImage(texture, 0, 0, this.layerContainer);
            this.texturePaint = new TexturePaint(buffer, new Rectangle(0, 0, buffer.getWidth(), buffer.getHeight()));
        } else {
            this.texturePaint = null;
        }
        this.repaint();
    }
}

