/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.action.timeline;

import com.dlsc.flexgantt.swing.action.timeline.AbstractTimelineAction;
import com.dlsc.flexgantt.swing.timeline.Timeline;
import com.dlsc.flexgantt.util.Messages;
import java.awt.event.ActionEvent;

public class ScrollTimelineAction
extends AbstractTimelineAction {
    private ScrollDirection direction;
    private boolean fast;

    public ScrollTimelineAction(Timeline timeline, ScrollDirection dir, boolean fast) {
        super(timeline, "");
        this.direction = dir;
        this.fast = fast;
        switch (this.direction) {
            case LEFT: {
                if (fast) {
                    this.putValue("Name", Messages.getString("ScrollTimelineAction.SCROLL_LEFT_FAST"));
                    break;
                }
                this.putValue("Name", Messages.getString("ScrollTimelineAction.SCROLL_LEFT"));
                break;
            }
            case RIGHT: {
                if (fast) {
                    this.putValue("Name", Messages.getString("ScrollTimelineAction.SCROLL_RIGHT_FAST"));
                    break;
                }
                this.putValue("Name", Messages.getString("ScrollTimelineAction.SCROLL_RIGHT"));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (this.direction) {
            case LEFT: {
                this.timeline.scrollLeft(this.fast);
                break;
            }
            case RIGHT: {
                this.timeline.scrollRight(this.fast);
            }
        }
    }

    public ScrollDirection getDirection() {
        return this.direction;
    }

    public boolean isFast() {
        return this.fast;
    }

    public static enum ScrollDirection {
        LEFT,
        RIGHT;

    }
}

