/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.action.gantt;

import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.treetable.INodeEditPolicy;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.action.gantt.AbstractGanttChartAction;
import com.dlsc.flexgantt.swing.treetable.CellFocusManager;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import com.dlsc.flexgantt.util.Messages;
import java.awt.event.ActionEvent;
import javax.swing.tree.TreePath;

public class SelectRowsAction<T extends AbstractGanttChart>
extends AbstractGanttChartAction<T> {
    private boolean down;

    public SelectRowsAction(T gc, boolean down) {
        super(gc, "");
        this.down = down;
        if (down) {
            this.putValue("Name", Messages.getString("SelectRowsAction.SELECT_NEXT_ROW"));
        } else {
            this.putValue("Name", Messages.getString("SelectRowsAction.SELECT_PREVIOUS_ROW"));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TreeTable table = this.findTable(this.ganttChart.getTreeTables());
        CellFocusManager mgr = table.getCellFocusManager();
        if (this.down) {
            mgr.focusOnCellBelow();
        } else {
            mgr.focusOnCellAbove();
        }
        TreePath focusedPath = mgr.getFocusedPath();
        Object node = focusedPath.getLastPathComponent();
        IPolicyProvider pp = table.getPolicyProvider();
        INodeEditPolicy nep = pp.getPolicy(INodeEditPolicy.class);
        if (nep.isSelectable(node, table.getModel())) {
            table.addSelectionPath(focusedPath);
        }
    }

    private TreeTable findTable(TreeTable[] tables) {
        for (TreeTable table : tables) {
            CellFocusManager mgr = table.getCellFocusManager();
            if (!mgr.hasFocus()) continue;
            return table;
        }
        return tables[0];
    }
}

