/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.gantt.ILayer;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.swing.layer.timeline.TimelineObjectLayer;
import com.dlsc.flexgantt.swing.treetable.TreeTableNode;
import java.awt.Rectangle;

public class ObjectBounds
extends Rectangle {
    private IGanttChartModel model;
    private TreeTableNode treeTableNode;
    private TimelineObjectLayer layer;
    private TimelineObjectPath timelineObjectPath;

    public ObjectBounds(TimelineObjectPath path, IGanttChartModel model, int x, int y, int width, int height, TreeTableNode treeTableNode, TimelineObjectLayer layer) {
        super(x, y, width, height);
        this.timelineObjectPath = path;
        this.model = model;
        this.treeTableNode = treeTableNode;
        this.layer = layer;
    }

    public IGanttChartModel getModel() {
        return this.model;
    }

    public ILayer getLayer() {
        return this.layer.getLayer();
    }

    public TimelineObjectLayer getLayerUI() {
        return this.layer;
    }

    public Object getNode() {
        return this.timelineObjectPath.getLastPathComponent();
    }

    public Object getObject() {
        return this.timelineObjectPath.getTimelineObject();
    }

    public ITimeSpan getTimeSpan() {
        return this.model.getTimeSpan(this.getObject());
    }

    public TreeTableNode getTreeTableNode() {
        return this.treeTableNode;
    }

    public TimelineObjectPath getPath() {
        return this.timelineObjectPath;
    }

    @Override
    public boolean equals(Object otherObject) {
        if (otherObject == null) {
            return false;
        }
        if (!(otherObject instanceof ObjectBounds)) {
            return false;
        }
        ObjectBounds otherBounds = (ObjectBounds)otherObject;
        if (this.getObject() != otherBounds.getObject()) {
            return false;
        }
        ObjectBounds ob = (ObjectBounds)otherObject;
        return this.getTimeSpan().equals(ob.getTimeSpan()) && this.getObject().equals(ob.getObject()) && this.getModel().equals(ob.getModel());
    }
}

