/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing;

import com.dlsc.flexgantt.command.IProgressMonitor;
import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.dateline.DatelineModelEvent;
import com.dlsc.flexgantt.model.dateline.IDatelineModel;
import com.dlsc.flexgantt.model.dateline.IDatelineModelListener;
import com.dlsc.flexgantt.model.dateline.IGranularity;
import com.dlsc.flexgantt.model.eventline.IEventlineModel;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.gantt.IRelationship;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.eventline.IEventlineLabelPolicy;
import com.dlsc.flexgantt.policy.gantt.IStatusBarPolicy;
import com.dlsc.flexgantt.policy.gantt.StatusBarField;
import com.dlsc.flexgantt.policy.layer.IGridPolicy;
import com.dlsc.flexgantt.policy.layer.ILabelPolicy;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.IGridComponent;
import com.dlsc.flexgantt.swing.IMessage;
import com.dlsc.flexgantt.swing.IMessageListener;
import com.dlsc.flexgantt.swing.IMultiGanttChartContainer;
import com.dlsc.flexgantt.swing.IMultiGanttChartContainerListener;
import com.dlsc.flexgantt.swing.MessageTypeId;
import com.dlsc.flexgantt.swing.MultiGanttChartContainerEvent;
import com.dlsc.flexgantt.swing.ObjectBounds;
import com.dlsc.flexgantt.swing.StatusBar;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.LayerContainerScrollPane;
import com.dlsc.flexgantt.swing.layer.system.DragLayer;
import com.dlsc.flexgantt.swing.layer.system.DragLayerEvent;
import com.dlsc.flexgantt.swing.layer.system.IDragLayerListener;
import com.dlsc.flexgantt.swing.layer.system.ILassoLayerListener;
import com.dlsc.flexgantt.swing.layer.system.LassoLayer;
import com.dlsc.flexgantt.swing.layer.system.LassoLayerEvent;
import com.dlsc.flexgantt.swing.layer.system.RelationshipLayer;
import com.dlsc.flexgantt.swing.selector.ISelectorFactory;
import com.dlsc.flexgantt.swing.selector.Selector;
import com.dlsc.flexgantt.swing.timeline.Dateline;
import com.dlsc.flexgantt.swing.timeline.Eventline;
import com.dlsc.flexgantt.util.LabelType;
import com.dlsc.flexgantt.util.Messages;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class GanttChartStatusBar<T extends AbstractGanttChart>
extends StatusBar
implements IMessageListener,
PropertyChangeListener,
IDatelineModelListener,
MouseMotionListener,
IMultiGanttChartContainerListener,
IProgressMonitor,
ILassoLayerListener,
IDragLayerListener {
    private static final Logger LOGGER = Logger.getLogger(GanttChartStatusBar.class.getName());
    private JLabel gridLabel;
    private JLabel popupLabel;
    private JLabel crosshairLabel;
    private JLabel timeNowLabel;
    private JLabel timeNowLockLabel;
    private JLabel timeZoneLabel;
    private JLabel messagesLabel;
    private JLabel memoryLabel;
    private JLabel timeLabel;
    private JLabel actionSelectorLabel;
    private T ganttChart;
    private Dateline dateline;
    private MemoryThread memoryThread;
    private T previousGantt;
    private JProgressBar progressBar;
    private boolean cancelled;

    public GanttChartStatusBar(T gc, boolean separatorsVisible) {
        super(separatorsVisible);
        this.updateStatusBar(gc);
    }

    public GanttChartStatusBar(T gc) {
        this.updateStatusBar(gc);
    }

    public GanttChartStatusBar(IMultiGanttChartContainer<T> container, boolean separatorsVisible) {
        super(separatorsVisible);
        T gc = container.getSelectedGanttChart();
        if (gc != null) {
            this.updateStatusBar(container.getSelectedGanttChart());
        }
        container.addMultiGanttChartContainerListener(this);
    }

    public GanttChartStatusBar(IMultiGanttChartContainer<T> container) {
        T gc = container.getSelectedGanttChart();
        if (gc != null) {
            this.updateStatusBar(container.getSelectedGanttChart());
        }
        container.addMultiGanttChartContainerListener(this);
    }

    protected void updateStatusBar(T gc) {
        LassoLayer lassoLayer;
        DragLayer dragLayer;
        LayerContainer lc;
        this.removeAllItems();
        this.setName("GanttChartStatusBar");
        IPolicyProvider pp = ((AbstractGanttChart)gc).getPolicyProvider();
        IStatusBarPolicy sbp = pp.getPolicy(IStatusBarPolicy.class);
        this.ganttChart = gc;
        ((Container)this.ganttChart).addPropertyChangeListener(this);
        ((AbstractGanttChart)this.ganttChart).getEventline().addMouseMotionListener(this);
        for (LayerContainerScrollPane sp : ((AbstractGanttChart)gc).getLayerContainerScrollPanes()) {
            lc = sp.getLayerContainer();
            lc.addMouseMotionListener(this);
            dragLayer = lc.getSystemLayer(DragLayer.class);
            dragLayer.addDragLayerListener(this);
            lassoLayer = lc.getSystemLayer(LassoLayer.class);
            lassoLayer.addLassoLayerListener(this);
        }
        if (this.previousGantt != null) {
            for (LayerContainerScrollPane sp : ((AbstractGanttChart)this.previousGantt).getLayerContainerScrollPanes()) {
                lc = sp.getLayerContainer();
                lc.removeMouseMotionListener(this);
                dragLayer = lc.getSystemLayer(DragLayer.class);
                dragLayer.removeDragLayerListener(this);
                lassoLayer = lc.getSystemLayer(LassoLayer.class);
                lassoLayer.removeLassoLayerListener(this);
            }
        }
        this.dateline = ((AbstractGanttChart)gc).getDateline();
        this.dateline.addPropertyChangeListener(this);
        this.dateline.addMouseMotionListener(this);
        this.dateline.getModel().addDatelineModelListener(this);
        if (this.previousGantt != null) {
            Dateline previousDateline = ((AbstractGanttChart)this.previousGantt).getDateline();
            previousDateline.removePropertyChangeListener(this);
            previousDateline.removeMouseMotionListener(this);
            previousDateline.getModel().removeDatelineModelListener(this);
        }
        this.timeLabel = new JLabel("");
        this.timeLabel.setIcon(IconRegistry.getIcon(IconId.TIME));
        this.timeLabel.setToolTipText(Messages.getString("GanttChartStatusBar.TOOLTIP_SELECTED_TIME"));
        this.timeNowLabel = new JLabel("");
        this.timeNowLabel.setIcon(IconRegistry.getIcon(IconId.TIME_NOW));
        this.timeNowLabel.setToolTipText(Messages.getString("GanttChartStatusBar.TOOLTIP_TIME_NOW"));
        this.timeNowLockLabel = new JLabel("");
        if (((AbstractGanttChart)gc).isTimeNowScrolling()) {
            this.timeNowLockLabel.setIcon(IconRegistry.getIcon(IconId.SCROLLING_LOCKED));
        } else {
            this.timeNowLockLabel.setIcon(IconRegistry.getIcon(IconId.SCROLLING_UNLOCKED));
        }
        this.timeNowLockLabel.setToolTipText(Messages.getString("GanttChartStatusBar.TOOLTIP_LOCK_TIME_NOW"));
        this.timeZoneLabel = new JLabel("");
        this.timeZoneLabel.setIcon(IconRegistry.getIcon(IconId.TIME_ZONE));
        this.timeZoneLabel.setToolTipText(Messages.getString("GanttChartStatusBar.TOOLTIP_TIME_NOW"));
        this.timeZoneLabel.addMouseListener(new MouseAdapter(){
            private Selector timeZoneSelector;

            @Override
            public void mouseClicked(MouseEvent e) {
                if (this.timeZoneSelector == null) {
                    ISelectorFactory sf = GanttChartStatusBar.this.ganttChart.getSelectorFactory();
                    this.timeZoneSelector = sf.createSelector(GanttChartStatusBar.this.ganttChart, (JComponent)GanttChartStatusBar.this.timeZoneLabel, ISelectorFactory.SelectorID.TIMEZONE);
                }
                this.timeZoneSelector.setVisible(!this.timeZoneSelector.isVisible());
            }
        });
        this.gridLabel = new JLabel("");
        this.gridLabel.setIcon(IconRegistry.getIcon(IconId.BLANK));
        this.gridLabel.setToolTipText(Messages.getString("GanttChartStatusBar.TOOLTIP_GRID_LINES"));
        this.popupLabel = new JLabel("");
        this.popupLabel.setToolTipText(Messages.getString("GanttChartStatusBar.TOOLTIP_ANNOTATIONS"));
        if (((AbstractGanttChart)this.ganttChart).isPopupVisible()) {
            this.popupLabel.setIcon(IconRegistry.getIcon(IconId.POPUP));
        } else {
            this.popupLabel.setIcon(IconRegistry.getIcon(IconId.BLANK));
        }
        this.crosshairLabel = new JLabel("");
        this.crosshairLabel.setIcon(IconRegistry.getIcon(IconId.BLANK));
        this.crosshairLabel.setToolTipText(Messages.getString("GanttChartStatusBar.TOOLTIP_CROSSHAIR"));
        this.messagesLabel = new JLabel("");
        this.messagesLabel.setToolTipText(Messages.getString("GanttChartStatusBar.TOOLTIP_MESSAGES"));
        this.memoryLabel = new JLabel("");
        this.memoryLabel.setIcon(IconRegistry.getIcon(IconId.MEMORY));
        this.memoryLabel.setToolTipText(Messages.getString("GanttChartStatusBar.TOOLTIP_MEMORY"));
        this.memoryLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                GanttChartStatusBar.this.memoryLabel.setIcon(IconRegistry.getIcon(IconId.GARBAGE_COLLECTION));
                GanttChartStatusBar.this.memoryLabel.setText(Messages.getString("GanttChartStatusBar.GARBAGE_COLLECTION"));
                System.gc();
            }
        });
        this.actionSelectorLabel = new JLabel();
        this.actionSelectorLabel.setIcon(IconRegistry.getIcon(IconId.HELP));
        this.actionSelectorLabel.setToolTipText(Messages.getString("GanttChartStatusBar.KEY_STROKES_TOOLTIP"));
        this.actionSelectorLabel.addMouseListener(new MouseAdapter(){
            private Selector actionSelector;

            @Override
            public void mouseClicked(MouseEvent e) {
                if (this.actionSelector == null) {
                    ISelectorFactory sf = GanttChartStatusBar.this.ganttChart.getSelectorFactory();
                    this.actionSelector = sf.createSelector(GanttChartStatusBar.this.ganttChart, (JComponent)GanttChartStatusBar.this.actionSelectorLabel, ISelectorFactory.SelectorID.ACTIONS);
                }
                this.actionSelector.setVisible(!this.actionSelector.isVisible());
            }
        });
        this.progressBar = new JProgressBar();
        this.progressBar.setMinimumSize(new Dimension(60, 10));
        if (sbp.isStatusBarFieldVisible(StatusBarField.PROGRESS_BAR)) {
            this.addItem(this.progressBar);
            this.progressBar.setVisible(false);
        }
        if (sbp.isStatusBarFieldVisible(StatusBarField.TIME)) {
            this.addSeparator();
            this.addItem(this.timeLabel);
        }
        if (sbp.isStatusBarFieldVisible(StatusBarField.TIME_NOW)) {
            this.addSeparator();
            this.addItem(this.timeNowLabel);
        }
        if (sbp.isStatusBarFieldVisible(StatusBarField.TIME_NOW_LOCK)) {
            this.addItem(this.timeNowLockLabel);
            this.timeNowLockLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    GanttChartStatusBar.this.ganttChart.setTimeNowScrolling(!GanttChartStatusBar.this.ganttChart.isTimeNowScrolling());
                    if (GanttChartStatusBar.this.ganttChart.isTimeNowScrolling()) {
                        GanttChartStatusBar.this.timeNowLockLabel.setIcon(IconRegistry.getIcon(IconId.SCROLLING_LOCKED));
                    } else {
                        GanttChartStatusBar.this.timeNowLockLabel.setIcon(IconRegistry.getIcon(IconId.SCROLLING_UNLOCKED));
                    }
                }
            });
        }
        if (sbp.isStatusBarFieldVisible(StatusBarField.TIME_ZONE)) {
            this.addSeparator();
            this.addItem(this.timeZoneLabel);
            this.updateTimeZoneStatus(((AbstractGanttChart)gc).getTimeline().getDateline().getTimeZone());
        }
        if (sbp.isStatusBarFieldVisible(StatusBarField.MEMORY)) {
            this.addSeparator();
            this.addItem(this.memoryLabel);
            if (this.memoryThread != null) {
                this.memoryThread.stopThread();
            }
            this.memoryThread = new MemoryThread(this.memoryLabel);
            this.memoryThread.start();
        }
        if (sbp.isStatusBarFieldVisible(StatusBarField.GRID) || sbp.isStatusBarFieldVisible(StatusBarField.POPUP)) {
            this.addSeparator();
        }
        if (sbp.isStatusBarFieldVisible(StatusBarField.GRID)) {
            this.addItem(this.gridLabel);
        }
        if (sbp.isStatusBarFieldVisible(StatusBarField.POPUP)) {
            this.addItem(this.popupLabel);
        }
        if (sbp.isStatusBarFieldVisible(StatusBarField.CROSSHAIR)) {
            this.addItem(this.crosshairLabel);
        }
        if (sbp.isStatusBarFieldVisible(StatusBarField.MESSAGE)) {
            this.addSeparator();
            this.addItem(this.messagesLabel);
        }
        if (sbp.isStatusBarFieldVisible(StatusBarField.KEY_STROKES)) {
            this.addSeparator();
            this.addItem(this.actionSelectorLabel);
        }
        ((AbstractGanttChart)gc).getEventline().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("timeNow")) {
                    GanttChartStatusBar.this.updateTimeNow();
                }
            }
        });
        this.messagesLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    GanttChartStatusBar.this.ganttChart.showMessages();
                }
            }
        });
        ((AbstractGanttChart)this.ganttChart).addMessageListener(this);
        if (this.previousGantt != null) {
            ((AbstractGanttChart)this.previousGantt).removeMessageListener(this);
        }
        this.updateTimeNow();
        this.updateGrid();
        this.previousGantt = gc;
    }

    @Override
    public void datelineModelWillChange(DatelineModelEvent evt) {
    }

    @Override
    public void datelineModelChanged(DatelineModelEvent e) {
        if (e.getId().equals((Object)DatelineModelEvent.ID.TIME_ZONE_CHANGED)) {
            IDatelineModel model = e.getModel();
            this.updateTimeZoneStatus(model.getTimeZone());
        } else if (e.getId() == DatelineModelEvent.ID.SELECTED_TIME_SPAN_CHANGED) {
            this.setStatusTimeSpan(this.dateline.getSelectedTimeSpan());
        }
    }

    public AbstractGanttChart getGanttChart() {
        return this.ganttChart;
    }

    private void updateTimeNow() {
        long timeNow = ((AbstractGanttChart)this.ganttChart).getTimeline().getEventline().getTimeNow();
        IPolicyProvider pp = ((AbstractGanttChart)this.ganttChart).getPolicyProvider();
        IStatusBarPolicy sp = pp.getPolicy(IStatusBarPolicy.class);
        String str = sp.getTimeNowString(((AbstractGanttChart)this.ganttChart).getDatelineModel(), timeNow);
        this.timeNowLabel.setText(str);
    }

    private void updateGrid() {
        switch (((AbstractGanttChart)this.ganttChart).getGridLineMode()) {
            case NO_GRID_LINES: {
                this.gridLabel.setIcon(IconRegistry.getIcon(IconId.BLANK));
                this.gridLabel.setToolTipText(Messages.getString("GanttChartStatusBar.TOOLTIP_GRID_DISABLED"));
                break;
            }
            case MINOR_GRID_LINES: {
                this.gridLabel.setIcon(IconRegistry.getIcon(IconId.MINOR_GRID));
                this.gridLabel.setToolTipText(Messages.getString("GanttChartStatusBar.TOOLTIP_GRID_ENABLED_FINE"));
                break;
            }
            case MAJOR_GRID_LINES: {
                this.gridLabel.setIcon(IconRegistry.getIcon(IconId.MAJOR_GRID));
                this.gridLabel.setToolTipText(Messages.getString("GanttChartStatusBar.TOOLTIP_GRID_ENABLED"));
                break;
            }
            case COMBINED_GRID_LINES: {
                this.gridLabel.setIcon(IconRegistry.getIcon(IconId.COMBINED_GRID));
                this.gridLabel.setToolTipText(Messages.getString("GanttChartStatusBar.TOOLTIP_GRID_ENABLED_COMBINED"));
            }
        }
    }

    public JLabel getGridLabel() {
        return this.gridLabel;
    }

    public JLabel getPopupLabel() {
        return this.popupLabel;
    }

    public JLabel getCrosshairLabel() {
        return this.crosshairLabel;
    }

    public JLabel getMemoryLabel() {
        return this.memoryLabel;
    }

    public JLabel getMessagesLabel() {
        return this.messagesLabel;
    }

    public JLabel getTimeLabel() {
        return this.timeLabel;
    }

    public JLabel getTimeNowLabel() {
        return this.timeNowLabel;
    }

    public JLabel getTimeZoneLabel() {
        return this.timeZoneLabel;
    }

    private void updateTimeZoneStatus(TimeZone timeZone) {
        this.timeZoneLabel.setText(timeZone.getDisplayName());
        this.timeZoneLabel.setToolTipText(Messages.getString("GanttChartStatusBar.TOOLTIP_TIME_ZONE_ID") + timeZone.getID());
    }

    protected String format(long time) {
        IPolicyProvider pp = ((AbstractGanttChart)this.ganttChart).getPolicyProvider();
        IStatusBarPolicy sp = pp.getPolicy(IStatusBarPolicy.class);
        return sp.getTimeString(((AbstractGanttChart)this.ganttChart).getDatelineModel(), time);
    }

    protected String format(ITimeSpan span) {
        if (span == null) {
            throw new IllegalArgumentException("span can not be NULL");
        }
        IPolicyProvider pp = ((AbstractGanttChart)this.ganttChart).getPolicyProvider();
        IStatusBarPolicy sp = pp.getPolicy(IStatusBarPolicy.class);
        return sp.getTimeSpanString(((AbstractGanttChart)this.ganttChart).getDatelineModel(), span);
    }

    @Override
    public void messageAdded(IMessage msg) {
        Icon currentIcon = this.messagesLabel.getIcon();
        switch (msg.getMessageTypeId()) {
            case INFORMATION: {
                if (currentIcon == IconRegistry.getIcon(IconId.ERROR) || currentIcon == IconRegistry.getIcon(IconId.WARNING)) break;
                this.updateMessageIcon(MessageTypeId.INFORMATION);
                break;
            }
            case WARNING: {
                if (currentIcon == IconRegistry.getIcon(IconId.ERROR)) break;
                this.updateMessageIcon(MessageTypeId.WARNING);
                break;
            }
            case ERROR: {
                this.updateMessageIcon(MessageTypeId.ERROR);
                break;
            }
        }
    }

    @Override
    public void messageRemoved(IMessage msg) {
        Collection<IMessage> messages = ((AbstractGanttChart)this.ganttChart).getMessages();
        if (messages.size() > 0) {
            MessageTypeId id = MessageTypeId.INFORMATION;
            for (IMessage m : messages) {
                switch (m.getMessageTypeId()) {
                    case ERROR: {
                        id = MessageTypeId.ERROR;
                        break;
                    }
                    case WARNING: {
                        id = MessageTypeId.WARNING;
                        break;
                    }
                }
            }
            this.updateMessageIcon(id);
        } else {
            this.messagesCleared();
        }
    }

    @Override
    public void messagesCleared() {
        this.messagesLabel.setIcon(IconRegistry.getIcon(IconId.BLANK));
    }

    private void updateMessageIcon(MessageTypeId id) {
        switch (id) {
            case INFORMATION: {
                this.messagesLabel.setIcon(IconRegistry.getIcon(IconId.INFORMATION));
                break;
            }
            case WARNING: {
                this.messagesLabel.setIcon(IconRegistry.getIcon(IconId.WARNING));
                break;
            }
            case ERROR: {
                this.messagesLabel.setIcon(IconRegistry.getIcon(IconId.ERROR));
                break;
            }
            default: {
                this.messagesLabel.setIcon(IconRegistry.getIcon(IconId.BLANK));
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if (evt.getSource().equals(this.ganttChart)) {
            if (propName.equals("popupVisible")) {
                if (((AbstractGanttChart)this.ganttChart).isPopupVisible()) {
                    this.popupLabel.setIcon(IconRegistry.getIcon(IconId.POPUP));
                } else {
                    this.popupLabel.setIcon(IconRegistry.getIcon(IconId.BLANK));
                }
            } else if (propName.equals("crosshairVisible")) {
                if (((AbstractGanttChart)this.ganttChart).isCrosshairVisible()) {
                    this.crosshairLabel.setIcon(IconRegistry.getIcon(IconId.CROSSHAIR));
                } else {
                    this.crosshairLabel.setIcon(IconRegistry.getIcon(IconId.BLANK));
                }
            } else if (propName.equals("gridLineMode")) {
                this.updateGrid();
            }
        } else if (evt.getSource().equals(this.dateline) && propName.equals("datelineModel")) {
            IDatelineModel oldModel = (IDatelineModel)evt.getOldValue();
            IDatelineModel newModel = (IDatelineModel)evt.getNewValue();
            oldModel.removeDatelineModelListener(this);
            newModel.addDatelineModelListener(this);
        }
    }

    public JLabel getActionSelectorLabel() {
        return this.actionSelectorLabel;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Object source = e.getSource();
        if (source instanceof LayerContainer) {
            LayerContainer lc = (LayerContainer)source;
            ObjectBounds activeBounds = lc.getObjectBoundsAt(e.getX(), e.getY());
            RelationshipLayer rl = lc.getSystemLayer(RelationshipLayer.class);
            List<IRelationship> relationships = rl.getRelationshipsAt(e.getX(), e.getY());
            IGanttChartModel model = lc.getModel();
            IPolicyProvider pp = lc.getPolicyProvider();
            ILabelPolicy lp = pp.getPolicy(ILabelPolicy.class);
            if (activeBounds != null) {
                if (lp.isLabelTypeVisible(activeBounds.getPath(), model, LabelType.STATUS)) {
                    String status = lp.getLabel(activeBounds.getPath(), model, LabelType.STATUS);
                    this.setStatus(status);
                }
                this.setStatusTimeSpan(activeBounds.getTimeSpan());
            } else if (!relationships.isEmpty()) {
                this.setStatus(lp.getLabel(relationships.get(0), model, LabelType.STATUS));
            } else {
                this.setStatus("");
                long time = this.dateline.getTimeAt(e.getX());
                this.setStatusTime(time, lc);
            }
        } else if (source instanceof Dateline) {
            this.setStatusTime(this.dateline.getTimeAt(e.getX()));
        } else if (source instanceof Eventline) {
            Eventline eventline = (Eventline)source;
            Object[] eventlineObjects = eventline.getEventlineObjectsAt(e.getX(), e.getY());
            if (eventlineObjects != null && eventlineObjects.length > 0) {
                Object first = eventlineObjects[0];
                IEventlineModel model = eventline.getModel();
                ITimeSpan span = model.getTimeSpan(first);
                this.setStatusTimeSpan(span);
                IPolicyProvider pp = eventline.getPolicyProvider();
                IEventlineLabelPolicy lp = pp.getPolicy(IEventlineLabelPolicy.class);
                String name = lp.getLabel(first, model, LabelType.STATUS);
                this.setStatus(name);
            } else {
                this.setStatusTime(this.dateline.getTimeAt(e.getX()), eventline);
            }
        }
    }

    protected void setStatusTime(long time, IGridComponent gridComp) {
        boolean autoGrid = gridComp.isGridAutomatic();
        IGranularity granularity = gridComp.getGridGranularity();
        IGridPolicy gp = gridComp.getGridPolicy();
        IDatelineModel datelineModel = this.dateline.getModel();
        long adjustedTime = gp.getGridAdjustedStartTime(granularity, time, datelineModel, autoGrid);
        this.setStatusTime(adjustedTime);
    }

    protected void setStatusTime(long time) {
        this.timeLabel.setText(this.format(time));
    }

    protected void setStatusTimeSpan(ITimeSpan span) {
        if (span != null) {
            if (span.getDuration() == 0L) {
                this.setStatusTime(span.getStartTime());
            } else {
                this.timeLabel.setText(this.format(span));
            }
        } else {
            this.timeLabel.setText("");
        }
    }

    @Override
    public void containerChanged(MultiGanttChartContainerEvent evt) {
        switch (evt.getId()) {
            case GANTT_CHART_CHANGED: {
                this.updateStatusBar(evt.getGanttChart());
                break;
            }
        }
    }

    @Override
    public void beginTask(String name, int totalWork) {
        this.setStatus(name);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(totalWork);
        this.progressBar.setValue(0);
        this.progressBar.setVisible(true);
    }

    @Override
    public void done() {
        this.progressBar.setVisible(false);
        this.setStatus("");
    }

    @Override
    public void internalWorked(double work) {
    }

    @Override
    public boolean isCanceled() {
        return this.cancelled;
    }

    @Override
    public void setCanceled(boolean value) {
        this.cancelled = value;
    }

    @Override
    public void setTaskName(String name) {
        this.setStatus(name);
    }

    @Override
    public void subTask(String name) {
        this.setStatus(name);
    }

    @Override
    public void worked(int work) {
        this.progressBar.setValue(this.progressBar.getValue() + work);
    }

    @Override
    public void lassoChanged(LassoLayerEvent evt) {
        this.setStatusTimeSpan(evt.getTimeSpan());
    }

    @Override
    public void dragging(DragLayerEvent evt) {
        this.setStatusTimeSpan(evt.getTimeSpan());
    }

    public void tearDown() {
        this.memoryThread.stopThread();
    }

    static class MemoryThread
    extends Thread {
        private JLabel label;
        private boolean running = true;
        private NumberFormat format = NumberFormat.getNumberInstance();

        public MemoryThread(JLabel label) {
            super("Status Bar Memory Thread");
            this.setDaemon(true);
            this.label = label;
            this.format.setMinimumFractionDigits(1);
            this.format.setMaximumFractionDigits(1);
        }

        @Override
        public void run() {
            while (this.running) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        label.setIcon(IconRegistry.getIcon(IconId.MEMORY));
                        label.setText(this.getMemoryUsed() + " " + Messages.getString("GanttChartStatusBar.MEGABYTE") + " / " + this.getMemoryAvailable() + "  " + Messages.getString("GanttChartStatusBar.MEGABYTE"));
                    }
                });
                try {
                    MemoryThread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.WARNING, "error in memory thread", e);
                }
            }
        }

        public void stopThread() {
            this.running = false;
        }

        private String getMemoryUsed() {
            long total = Runtime.getRuntime().totalMemory();
            long free = Runtime.getRuntime().freeMemory();
            long used = total - free;
            double mb = (double)used / 1048576.0;
            return this.format.format(mb);
        }

        private String getMemoryAvailable() {
            long total = Runtime.getRuntime().totalMemory();
            double mb = (double)total / 1048576.0;
            return this.format.format(mb);
        }
    }

    static class TimeZoneEntry
    implements Comparable<TimeZoneEntry> {
        private TimeZone timeZone;

        public TimeZoneEntry(TimeZone tz) {
            if (tz == null) {
                throw new IllegalArgumentException("time zone can not be NULL");
            }
            this.timeZone = tz;
        }

        public TimeZone getTimeZone() {
            return this.timeZone;
        }

        public String toString() {
            return this.timeZone.getID();
        }

        public int hashCode() {
            return this.timeZone.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof TimeZoneEntry)) {
                return false;
            }
            TimeZoneEntry entry = (TimeZoneEntry)obj;
            return this.timeZone.equals(entry.getTimeZone());
        }

        @Override
        public int compareTo(TimeZoneEntry entry) {
            return this.toString().compareTo(entry.toString());
        }
    }
}

