/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing;

import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.GanttChartGlassPane;
import com.dlsc.flexgantt.swing.GanttChartStatusBar;
import com.dlsc.flexgantt.swing.GanttChartToolBar;
import com.dlsc.flexgantt.util.Messages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class GanttChartFrame<T extends AbstractGanttChart>
extends JFrame {
    private T ganttChart;
    private JToolBar toolBar;
    private JComponent statusBar;
    private GanttChartGlassPane busyPanel;
    private boolean tearingDownWindowOnDispose = true;

    public GanttChartFrame(String title, T gc, boolean showStatusBar, boolean showToolBar) {
        super(title);
        this.ganttChart = gc;
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)this.ganttChart, "Center");
        this.add((Component)p, "Center");
        if (showToolBar) {
            this.toolBar = this.createToolBar(gc);
            this.add((Component)this.toolBar, "North");
        }
        if (showStatusBar) {
            this.statusBar = this.createStatusBar(gc);
            this.add((Component)this.statusBar, "South");
        }
        this.busyPanel = new GanttChartGlassPane((AbstractGanttChart)gc);
        this.getRootPane().setGlassPane(this.busyPanel);
        this.setIconImage(IconRegistry.getImage(IconId.FLEXGANTT_16));
        this.setSize(900, 700);
        ((Component)this.ganttChart).setFocusable(true);
        ((JComponent)this.ganttChart).requestFocusInWindow();
        this.getRootPane().setActionMap(((JComponent)this.ganttChart).getActionMap());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (GanttChartFrame.this.isTearingDownWindowOnDispose() && GanttChartFrame.this.getDefaultCloseOperation() == 2) {
                    Object ganttChart = GanttChartFrame.this.getGanttChart();
                    ((AbstractGanttChart)ganttChart).tearDown();
                    if (GanttChartFrame.this.statusBar != null && GanttChartFrame.this.statusBar instanceof GanttChartStatusBar) {
                        ((GanttChartStatusBar)GanttChartFrame.this.statusBar).tearDown();
                    }
                }
            }
        });
    }

    public GanttChartFrame(String title, T gc) {
        this(title, gc, true, true);
    }

    public T getGanttChart() {
        return this.ganttChart;
    }

    public JComponent getStatusBar() {
        return this.statusBar;
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    protected JToolBar createToolBar(T gc) {
        return new GanttChartToolBar<T>(Messages.getString("GanttChartFrame.TOOLBAR_NAME"), gc);
    }

    protected JComponent createStatusBar(T gc) {
        return new GanttChartStatusBar<T>(gc);
    }

    public void center() {
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        int xOffset = (size.width - this.getSize().width) / 2;
        int yOffset = (size.height - this.getSize().height) / 2;
        this.setLocation(xOffset, yOffset);
    }

    public void showBusy() {
        this.busyPanel.setVisible(true);
    }

    public void showReady() {
        this.busyPanel.setVisible(false);
    }

    public void setTearingDownWindowOnDispose(boolean tearDown) {
        this.tearingDownWindowOnDispose = tearDown;
    }

    public boolean isTearingDownWindowOnDispose() {
        return this.tearingDownWindowOnDispose;
    }

    @Override
    public void dispose() {
        ((AbstractGanttChart)this.ganttChart).tearDown();
        if (this.statusBar != null && this.statusBar instanceof GanttChartStatusBar) {
            ((GanttChartStatusBar)this.statusBar).tearDown();
        }
        super.dispose();
    }
}

