/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.policy.layer;

import com.dlsc.flexgantt.command.ICommand;
import com.dlsc.flexgantt.command.layer.DefaultChangeMultipleTimelineObjectsTimeSpanCommand;
import com.dlsc.flexgantt.command.layer.DefaultChangeTimelineObjectTimeSpanCommand;
import com.dlsc.flexgantt.command.layer.DefaultCreateTimelineObjectCommand;
import com.dlsc.flexgantt.command.layer.DefaultDeleteMultipleTimelineObjectsCommand;
import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartModel;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartNode;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.gantt.IGanttChartNode;
import com.dlsc.flexgantt.model.gantt.ILayer;
import com.dlsc.flexgantt.model.gantt.ITimelineObject;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.policy.AbstractPolicy;
import com.dlsc.flexgantt.policy.layer.IEditTimelineObjectPolicy;
import java.util.Collection;
import java.util.List;

public class DefaultEditTimelineObjectPolicy
extends AbstractPolicy
implements IEditTimelineObjectPolicy {
    @Override
    public boolean isInPlaceEditable(TimelineObjectPath path, IGanttChartModel model) {
        this.assertClass("isEditable", "timelineObject", ITimelineObject.class, path.getTimelineObject());
        return ((ITimelineObject)path.getTimelineObject()).isInPlaceEditable();
    }

    @Override
    public boolean isStartTimeChangeable(TimelineObjectPath path, IGanttChartModel model) {
        this.assertClass("isStartTimeChangeable", "path.getTimelineObject()", ITimelineObject.class, path.getTimelineObject());
        return ((ITimelineObject)path.getTimelineObject()).isStartTimeChangeable();
    }

    @Override
    public boolean isDurationChangeable(TimelineObjectPath path, IGanttChartModel model) {
        this.assertClass("isDurationChangeable", "timelineObject", ITimelineObject.class, path.getTimelineObject());
        return ((ITimelineObject)path.getTimelineObject()).isDurationChangeable();
    }

    @Override
    public boolean isCreatable(Object node, IGanttChartModel model, ILayer layer, ITimeSpan span) {
        this.assertClass("getCreateCommand", "node", IGanttChartNode.class, node);
        this.assertClass("getCreateCommand", "model", DefaultGanttChartModel.class, model);
        return ((IGanttChartNode)node).isTimelineObjectCreatableAt(span, layer);
    }

    @Override
    public boolean isDeletable(TimelineObjectPath path, IGanttChartModel model) {
        this.assertClass("isDeletable", "path.getTimelineObject()", ITimelineObject.class, path.getTimelineObject());
        return ((ITimelineObject)path.getTimelineObject()).isDeletable();
    }

    @Override
    public ICommand getChangeTimeSpanCommand(TimelineObjectPath path, IGanttChartModel model, ITimeSpan span, int dropAction) {
        this.assertClass("getChangeTimeSpanCommand", "path.getLastPathComponent()", DefaultGanttChartNode.class, path.getLastPathComponent());
        this.assertClass("getChangeTimeSpanCommand", "path.getTimelineObject()", ITimelineObject.class, path.getTimelineObject());
        this.assertClass("getChangeTimeSpanCommand", "model", DefaultGanttChartModel.class, model);
        return new DefaultChangeTimelineObjectTimeSpanCommand((DefaultGanttChartNode)path.getLastPathComponent(), path.getLayer(), (ITimelineObject)path.getTimelineObject(), (DefaultGanttChartModel)model, span, dropAction);
    }

    @Override
    public ICommand getChangeTimeSpansCommand(IGanttChartModel model, List<TimelineObjectPath> timelineObjects, List<ITimeSpan> timeSpans, int dropAction) {
        this.assertClass("getChangeTimeSpanCommand", "model", DefaultGanttChartModel.class, model);
        if (timelineObjects == null) {
            throw new IllegalArgumentException("list of timeline object paths can not be null");
        }
        if (timeSpans == null) {
            throw new IllegalArgumentException("list of time spans can not be null");
        }
        if (timelineObjects.size() != timeSpans.size()) {
            throw new IllegalArgumentException("the number of timeline objects has to be equal to the number of time spans");
        }
        return new DefaultChangeMultipleTimelineObjectsTimeSpanCommand((DefaultGanttChartModel)model, timelineObjects, timeSpans, dropAction);
    }

    @Override
    public ICommand getCreateCommand(Object node, IGanttChartModel model, ILayer layer, ITimeSpan span, int lineIndex) {
        this.assertClass("getCreateCommand", "node", DefaultGanttChartNode.class, node);
        this.assertClass("getCreateCommand", "model", DefaultGanttChartModel.class, model);
        return new DefaultCreateTimelineObjectCommand((DefaultGanttChartNode)node, (DefaultGanttChartModel)model, layer, span, lineIndex);
    }

    @Override
    public ICommand getDeleteCommand(IGanttChartModel model, Collection<TimelineObjectPath> timelineObjects) {
        this.assertClass("getDeleteCommand", "model", DefaultGanttChartModel.class, model);
        return new DefaultDeleteMultipleTimelineObjectsCommand((DefaultGanttChartModel)model, timelineObjects);
    }
}

