/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.model.treetable;

import com.dlsc.flexgantt.model.treetable.ITreeTableModel;
import com.dlsc.flexgantt.model.treetable.ITreeTableModelListener;
import com.dlsc.flexgantt.model.treetable.ITreeTableNode;
import com.dlsc.flexgantt.model.treetable.TreeTableModelEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class DefaultTreeTableModel<T extends ITreeTableNode>
extends DefaultTreeModel
implements ITreeTableModel<T> {
    public DefaultTreeTableModel(T root) {
        super((TreeNode)root);
    }

    public DefaultTreeTableModel(T root, boolean asksAllowsChildren) {
        super((TreeNode)root, asksAllowsChildren);
    }

    @Override
    public Object getKey(T node) {
        return node.getKey();
    }

    @Override
    public void setKey(T node, Object newKey) {
        Object oldKey = node.getKey();
        node.setKey(newKey);
        Object[] path = this.getPathToRoot((TreeNode)node);
        this.fireTreeNodeKeyChanged(path, oldKey, newKey);
    }

    @Override
    public Object getColumnValue(T node, int index) {
        return node.getColumnValue(index);
    }

    @Override
    public void setColumnValue(T node, Object newValue, int columnModelIndex) {
        Object oldValue = node.getColumnValue(columnModelIndex);
        node.setColumnValue(newValue, columnModelIndex);
        Object[] path = this.getPathToRoot((TreeNode)node);
        this.fireTreeNodeValuesChanged(path, oldValue, newValue, columnModelIndex);
    }

    @Override
    public Object getRowHeaderValue(T node) {
        return node.getRowHeaderValue();
    }

    public void setRowHeaderValue(T node, Object value) {
        node.setRowHeaderValue(value);
    }

    @Override
    public void addTreeTableModelListener(ITreeTableModelListener l) {
        super.addTreeModelListener(l);
        this.listenerList.add(ITreeTableModelListener.class, l);
    }

    @Override
    public void removeTreeTableModelListener(ITreeTableModelListener l) {
        super.removeTreeModelListener(l);
        this.listenerList.remove(ITreeTableModelListener.class, l);
    }

    protected void fireTreeNodeKeyChanged(Object[] path, Object oldKey, Object newKey) {
        if (oldKey != null && newKey != null && oldKey.equals(newKey)) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        TreeTableModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ITreeTableModelListener.class) continue;
            if (e == null) {
                e = new TreeTableModelEvent((ITreeTableModel)this, path, oldKey, newKey, -1);
            }
            ((ITreeTableModelListener)listeners[i + 1]).treeNodeKeyChanged(e);
        }
    }

    protected void fireTreeNodeValuesChanged(Object[] path, Object oldValue, Object newValue, int columnModelIndex) {
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        TreeTableModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ITreeTableModelListener.class) continue;
            if (e == null) {
                e = new TreeTableModelEvent((ITreeTableModel)this, path, oldValue, newValue, columnModelIndex);
            }
            ((ITreeTableModelListener)listeners[i + 1]).treeNodeValueChanged(e);
        }
    }

    public void sort() {
        this.sort(this.getRoot());
    }

    public void sort(T node) {
        if (node == null) {
            throw new IllegalArgumentException("node can not be NULL");
        }
        this.sort(node, new int[]{-1});
    }

    public void sort(T node, int[] modelIndices) {
        if (node == null) {
            throw new IllegalArgumentException("node can not be NULL");
        }
        if (modelIndices == null) {
            throw new IllegalArgumentException("model indices can not be NULL");
        }
        boolean[] sortDirection = new boolean[modelIndices.length];
        for (int i = 0; i < sortDirection.length; ++i) {
            sortDirection[i] = true;
        }
        this.sort(node, modelIndices, sortDirection);
    }

    @Override
    public void sort(T node, int[] modelIndices, boolean[] sortDirection) {
        if (modelIndices == null) {
            throw new IllegalArgumentException("model indices can not be NULL");
        }
        if (sortDirection == null) {
            throw new IllegalArgumentException("sort directions can not be NULL");
        }
        if (modelIndices.length != sortDirection.length) {
            throw new IllegalArgumentException("the length of the model indices array is different than the length of the sort direction array");
        }
        node.sort(modelIndices, sortDirection);
        int count = node.getChildCount();
        int[] childIndices = new int[count];
        Object[] children = new Object[count];
        for (int i = 0; i < count; ++i) {
            children[i] = node.getChildAt(i);
        }
        this.fireTreeStructureChanged(node, this.getPathToRoot((TreeNode)node), childIndices, children);
    }

    @Override
    @Deprecated
    public void setRoot(TreeNode node) {
        super.setRoot(node);
    }

    public void setRoot(T root) {
        super.setRoot((TreeNode)root);
    }

    public T getRoot() {
        return (T)((ITreeTableNode)super.getRoot());
    }
}

