/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.model.paging;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.paging.IPagingModel;
import com.dlsc.flexgantt.model.paging.IPagingModelListener;
import com.dlsc.flexgantt.model.paging.Page;
import com.dlsc.flexgantt.model.paging.PagingEvent;
import com.dlsc.flexgantt.model.paging.PagingVetoException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;

public class DefaultPagingModel
implements IPagingModel {
    private static final Logger LOGGER = Logger.getLogger(DefaultPagingModel.class.getName());
    private EventListenerList listenerList = new EventListenerList();
    private ArrayList<Page> pages = new ArrayList();
    private int pageIndex = 0;

    public DefaultPagingModel(List<Page> pages) {
        this.setPages(pages);
    }

    public DefaultPagingModel() {
    }

    public void setPages(List<Page> pages) {
        if (pages == null) {
            throw new IllegalArgumentException("pages can not be NULL");
        }
        this.clearPages();
        for (Page page : pages) {
            this.addPage(page);
        }
    }

    public void clearPages() {
        ArrayList<Page> list = new ArrayList<Page>(this.pages);
        for (Page page : list) {
            this.removePage(page);
        }
    }

    public void addPage(Page page) {
        LOGGER.fine("adding page " + page);
        try {
            this.firePageWillChangeEvent(new PagingEvent(this, PagingEvent.ID.PAGE_ADDED, page));
            this.pages.add(page);
            Collections.sort(this.pages, new Comparator<Page>(){

                @Override
                public int compare(Page o1, Page o2) {
                    ITimeSpan s1 = o1.getTimeSpan();
                    ITimeSpan s2 = o2.getTimeSpan();
                    return s1.compareTo(s2);
                }
            });
            this.firePageChangedEvent(new PagingEvent(this, PagingEvent.ID.PAGE_ADDED, page));
        }
        catch (PagingVetoException ex) {
            LOGGER.throwing(this.getClass().getName(), "removePage", ex);
        }
    }

    public void removePage(Page page) {
        LOGGER.fine("removing page " + page);
        try {
            this.firePageWillChangeEvent(new PagingEvent(this, PagingEvent.ID.PAGE_REMOVED, page));
            this.pages.remove(page);
            this.firePageChangedEvent(new PagingEvent(this, PagingEvent.ID.PAGE_REMOVED, page));
        }
        catch (PagingVetoException ex) {
            LOGGER.throwing(this.getClass().getName(), "removePage", ex);
        }
    }

    @Override
    public Page getPage() {
        if (this.pageIndex < this.pages.size()) {
            return this.pages.get(this.pageIndex);
        }
        return null;
    }

    @Override
    public void setPage(Page page) {
        if (page == null) {
            throw new IllegalArgumentException("page can not be NULL");
        }
        if (!this.pages.contains(page)) {
            throw new IllegalArgumentException("page is not a member of this model");
        }
        int newIndex = this.pages.indexOf(page);
        if (newIndex != this.pageIndex) {
            try {
                this.firePageWillChangeEvent(new PagingEvent(this, PagingEvent.ID.PAGE_CHANGED, page));
                this.pageIndex = newIndex;
                this.firePageChangedEvent(new PagingEvent(this, PagingEvent.ID.PAGE_CHANGED, page));
            }
            catch (PagingVetoException ex) {
                LOGGER.throwing(this.getClass().getName(), "setPage()", ex);
            }
        }
    }

    @Override
    public int getPageCount() {
        return this.pages.size();
    }

    @Override
    public Page getPage(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("page index must be larger than 0");
        }
        if (index > this.pages.size() - 1) {
            throw new IllegalArgumentException("page index must be smaller than " + this.pages.size());
        }
        return this.pages.get(index);
    }

    @Override
    public void addPagingModelListener(IPagingModelListener l) {
        this.listenerList.add(IPagingModelListener.class, l);
    }

    @Override
    public void removePagingModelListener(IPagingModelListener l) {
        this.listenerList.remove(IPagingModelListener.class, l);
    }

    protected void firePageWillChangeEvent(PagingEvent evt) throws PagingVetoException {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IPagingModelListener.class) continue;
            ((IPagingModelListener)listeners[i + 1]).pageWillChange(evt);
        }
    }

    protected void firePageChangedEvent(PagingEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IPagingModelListener.class) continue;
            ((IPagingModelListener)listeners[i + 1]).pageChanged(evt);
        }
    }

    @Override
    public void firstPage() {
        this.setPage(this.pages.get(0));
    }

    @Override
    public void earlierPage() {
        int newIndex = Math.max(0, this.pageIndex - 1);
        if (newIndex != this.pageIndex) {
            Page page = this.getPage(newIndex);
            this.setPage(page);
        }
    }

    @Override
    public void laterPage() {
        int newIndex = Math.min(this.getPageCount() - 1, this.pageIndex + 1);
        if (newIndex != this.pageIndex) {
            Page page = this.getPage(newIndex);
            this.setPage(page);
        }
    }

    @Override
    public void lastPage() {
        this.setPage(this.pages.get(this.pages.size() - 1));
    }

    @Override
    public boolean hasEarlierPage() {
        return this.pageIndex > 0;
    }

    @Override
    public boolean hasLaterPage() {
        return this.pageIndex < this.getPageCount() - 1;
    }
}

