/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.model.gantt;

import com.dlsc.flexgantt.model.gantt.ILayer;
import javax.swing.tree.TreePath;

public class TimelineObjectPath<T>
extends TreePath {
    private T timelineObject;
    private ILayer layer;

    public TimelineObjectPath(Object singlePath, T timelineObject, ILayer layer) {
        super(singlePath);
        if (timelineObject == null) {
            throw new IllegalArgumentException("timeline object can not be NULL");
        }
        if (layer == null) {
            throw new IllegalArgumentException("layer can not be NULL");
        }
        this.timelineObject = timelineObject;
        this.layer = layer;
    }

    public TimelineObjectPath(Object[] path, T timelineObject, ILayer layer) {
        super(path);
        if (timelineObject == null) {
            throw new IllegalArgumentException("timeline object can not be NULL");
        }
        if (layer == null) {
            throw new IllegalArgumentException("layer can not be NULL");
        }
        this.timelineObject = timelineObject;
        this.layer = layer;
    }

    public TimelineObjectPath(TreePath path, T timelineObject, ILayer layer) {
        this(path.getPath(), timelineObject, layer);
    }

    public T getTimelineObject() {
        return this.timelineObject;
    }

    public Object getNode() {
        return this.getLastPathComponent();
    }

    public ILayer getLayer() {
        return this.layer;
    }

    public TreePath getTreePath() {
        return new TreePath(this.getPath());
    }

    @Override
    public boolean equals(Object o) {
        boolean equal = super.equals(o);
        TimelineObjectPath path = (TimelineObjectPath)o;
        return equal && this.timelineObject.equals(path.getTimelineObject()) && this.layer.equals(path.getLayer());
    }
}

