/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.model.gantt;

import com.dlsc.flexgantt.model.gantt.IRelationship;
import com.dlsc.flexgantt.model.gantt.RelationshipType;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.util.LabelType;
import com.dlsc.flexgantt.util.LabelTypeSupport;

public class DefaultRelationship<T>
implements IRelationship<T> {
    private TimelineObjectPath<T> sourcePath;
    private TimelineObjectPath<T> targetPath;
    private LabelTypeSupport labelSupport = new LabelTypeSupport();
    private boolean selectable = true;
    private boolean deletable = true;
    private Object popupTitle = "Relationship";
    private Object popupObject;
    private Object extendedPopupObject;
    private RelationshipType type = RelationshipType.END_TO_START;

    public DefaultRelationship(TimelineObjectPath<T> sourcePath, TimelineObjectPath<T> targetPath, RelationshipType type) {
        if (sourcePath == null) {
            throw new IllegalArgumentException("source path can not be NULL");
        }
        if (targetPath == null) {
            throw new IllegalArgumentException("target path can not be NULL");
        }
        if (type == null) {
            throw new IllegalArgumentException("relationship type can not be NULL");
        }
        this.sourcePath = sourcePath;
        this.targetPath = targetPath;
        this.type = type;
        this.setPopupObject("Link between " + sourcePath.getTimelineObject().toString() + " and " + targetPath.getTimelineObject().toString(), false);
    }

    public DefaultRelationship(TimelineObjectPath<T> sourcePath, TimelineObjectPath<T> targetPath) {
        this(sourcePath, targetPath, RelationshipType.END_TO_START);
    }

    public void setLabel(String label, LabelType type) {
        this.labelSupport.setLabel(label, type);
    }

    @Override
    public String getLabel(LabelType type) {
        String label = this.labelSupport.getLabel(type);
        if (label == null) {
            String labelFrom = this.sourcePath.getTimelineObject().toString();
            String labelTo = this.targetPath.getTimelineObject().toString();
            label = labelFrom + " -> " + labelTo;
        }
        return label;
    }

    @Override
    public void setSourcePath(TimelineObjectPath<T> path) {
        if (path == null) {
            throw new IllegalArgumentException("source path can not be NULL");
        }
        this.sourcePath = path;
    }

    @Override
    public TimelineObjectPath<T> getSourcePath() {
        return this.sourcePath;
    }

    @Override
    public void setTargetPath(TimelineObjectPath<T> path) {
        if (path == null) {
            throw new IllegalArgumentException("target path can not be NULL");
        }
        this.targetPath = path;
    }

    @Override
    public TimelineObjectPath<T> getTargetPath() {
        return this.targetPath;
    }

    public void setSelectable(boolean b) {
        this.selectable = b;
    }

    @Override
    public boolean isSelectable() {
        return this.selectable;
    }

    @Override
    public boolean isDeletable() {
        return this.deletable;
    }

    public void setDeletable(boolean b) {
        this.deletable = b;
    }

    public void setPopupObject(Object popupObject, boolean extended) {
        if (extended) {
            this.extendedPopupObject = popupObject;
        } else {
            this.popupObject = popupObject;
        }
    }

    @Override
    public Object getPopupObject(boolean extended) {
        if (extended) {
            return this.extendedPopupObject;
        }
        return this.popupObject;
    }

    public void setPopupTitleObject(Object titleObject) {
        this.popupTitle = titleObject;
    }

    @Override
    public Object getPopupTitleObject() {
        return this.popupTitle;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Relationship ");
        sb.append(this.hashCode());
        sb.append("[source path = ");
        sb.append(this.sourcePath);
        sb.append(", target path = ");
        sb.append(this.targetPath);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void setType(RelationshipType type) {
        if (type == null) {
            throw new IllegalArgumentException("type can not be NULL");
        }
        this.type = type;
    }

    @Override
    public RelationshipType getType() {
        return this.type;
    }
}

