/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.model.gantt;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.gantt.GanttChartModelEvent;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.gantt.IGanttChartModelListener;
import com.dlsc.flexgantt.model.gantt.IGanttChartNode;
import com.dlsc.flexgantt.model.gantt.ILayer;
import com.dlsc.flexgantt.model.gantt.IRelationship;
import com.dlsc.flexgantt.model.gantt.ISpreadsheet;
import com.dlsc.flexgantt.model.gantt.ITimelineObject;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.model.treetable.DefaultTreeTableModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.TreeNode;

public class DefaultGanttChartModel<T extends IGanttChartNode<S>, S extends ITimelineObject>
extends DefaultTreeTableModel<T>
implements IGanttChartModel<T, S> {
    private static final Logger LOGGER = Logger.getLogger(DefaultGanttChartModel.class.getName());
    private List<ILayer> layers = new ArrayList<ILayer>();
    private List<ISpreadsheet> spreadsheets = new ArrayList<ISpreadsheet>();
    private Collection<IRelationship<S>> relationships = new ArrayList<IRelationship<S>>();
    private final Map<S, Collection<IRelationship<S>>> map = new HashMap<S, Collection<IRelationship<S>>>();

    public DefaultGanttChartModel(T node, boolean asksAllowsChildren) {
        super(node, asksAllowsChildren);
    }

    public DefaultGanttChartModel(T node) {
        this(node, false);
    }

    public void addLayer(ILayer layer) {
        if (layer == null) {
            throw new IllegalArgumentException("attempt to add NULL layer");
        }
        if (this.layers.contains(layer)) {
            throw new IllegalArgumentException("the same layer can not be added twice");
        }
        this.layers.add(layer);
        this.fireGanttChartChanged(new GanttChartModelEvent((IGanttChartModel)this, GanttChartModelEvent.ID.LAYER_ADDED, layer));
    }

    public void removeLayer(ILayer layer) {
        if (layer == null) {
            throw new IllegalArgumentException("attempt to remove NULL layer");
        }
        if (!this.layers.contains(layer)) {
            throw new IllegalArgumentException("layer " + layer + " is not a member of the model");
        }
        this.layers.remove(layer);
        this.fireGanttChartChanged(new GanttChartModelEvent((IGanttChartModel)this, GanttChartModelEvent.ID.LAYER_REMOVED, layer));
    }

    @Override
    public Iterator<ILayer> getLayers() {
        return new ArrayList<ILayer>(this.layers).iterator();
    }

    @Override
    public void addGanttChartModelListener(IGanttChartModelListener l) {
        if (l == null) {
            throw new IllegalArgumentException("attempt to add NULL listener");
        }
        this.listenerList.add(IGanttChartModelListener.class, l);
    }

    @Override
    public void removeGanttChartModelListener(IGanttChartModelListener l) {
        if (l == null) {
            throw new IllegalArgumentException("attempt to remove NULL listener");
        }
        this.listenerList.remove(IGanttChartModelListener.class, l);
    }

    public void fireGanttChartChanged(GanttChartModelEvent evt) {
        if (evt == null) {
            throw new IllegalArgumentException("model event can not be NULL");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(evt.toString());
        }
        if (this.listenerList != null) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != IGanttChartModelListener.class) continue;
                ((IGanttChartModelListener)listeners[i + 1]).ganttChartChanged(evt);
            }
        }
    }

    public void addTimelineObject(T node, ILayer layer, S timelineObject) {
        ArrayList<S> list = new ArrayList<S>(1);
        list.add(timelineObject);
        this.addTimelineObjects(node, layer, list);
    }

    public void addTimelineObjects(T node, ILayer layer, Collection<S> timelineObjects) {
        if (node == null) {
            throw new IllegalArgumentException("node can not be NULL");
        }
        if (layer == null) {
            throw new IllegalArgumentException("layer can not be NULL");
        }
        if (timelineObjects == null) {
            throw new IllegalArgumentException("collection may not be NULL");
        }
        if (!this.layers.contains(layer)) {
            this.addLayer(layer);
        }
        node.addTimelineObjects(layer, timelineObjects);
        Object[] path = this.getPathToRoot((TreeNode)node);
        int s = timelineObjects.size();
        TimelineObjectPath[] tops = new TimelineObjectPath[s];
        int counter = 0;
        for (S object : timelineObjects) {
            tops[counter] = new TimelineObjectPath<S>(path, object, layer);
            ++counter;
        }
        this.fireGanttChartChanged(new GanttChartModelEvent((IGanttChartModel)this, GanttChartModelEvent.ID.TIMELINE_OBJECTS_ADDED, node, layer, tops));
    }

    public void clearTimelineObjects(T node, ILayer layer) {
        if (node == null) {
            throw new IllegalArgumentException("node can not be NULL");
        }
        if (layer == null) {
            throw new IllegalArgumentException("layer can not be NULL");
        }
        if (!this.layers.contains(layer)) {
            throw new IllegalArgumentException("layer " + layer + " is not a member of the model");
        }
        List timelineObjects = node.getTimelineObjects(layer);
        node.clearTimelineObjects(layer);
        Object[] path = this.getPathToRoot((TreeNode)node);
        int s = timelineObjects.size();
        TimelineObjectPath[] tops = new TimelineObjectPath[s];
        int counter = 0;
        for (Object object : timelineObjects) {
            tops[counter] = new TimelineObjectPath(path, object, layer);
            ++counter;
        }
        this.fireGanttChartChanged(new GanttChartModelEvent((IGanttChartModel)this, GanttChartModelEvent.ID.TIMELINE_OBJECTS_REMOVED, node, layer, tops));
    }

    public void clearTimelineObjects(T node) {
        if (node == null) {
            throw new IllegalArgumentException("node can not be NULL");
        }
        for (ILayer layer : this.layers) {
            this.clearTimelineObjects(node, layer);
        }
    }

    public void clearTimelineObjects(ILayer layer) {
        if (layer == null) {
            throw new IllegalArgumentException("layer can not be NULL");
        }
        this.doClearTimelineObjects((IGanttChartNode)this.getRoot(), layer);
    }

    public void clearTimelineObjects() {
        for (ILayer layer : this.layers) {
            this.doClearTimelineObjects((IGanttChartNode)this.getRoot(), layer);
        }
    }

    private void doClearTimelineObjects(T node, ILayer layer) {
        this.clearTimelineObjects(node, layer);
        int count = this.getChildCount(node);
        for (int i = 0; i < count; ++i) {
            IGanttChartNode child = (IGanttChartNode)this.getChild(node, i);
            this.doClearTimelineObjects(child, layer);
        }
    }

    @Override
    public Iterator<S> getTimelineObjectsIterator(T node, ILayer layer, ITimeSpan span) {
        if (node == null) {
            throw new IllegalArgumentException("owner can not be NULL");
        }
        if (layer == null) {
            throw new IllegalArgumentException("layer can not be NULL");
        }
        if (span == null) {
            throw new IllegalArgumentException("time span can not be NULL");
        }
        return node.getTimelineObjectsIterator(layer, span);
    }

    @Override
    public ITimeSpan getTimeSpan(S timelineObject) {
        return timelineObject.getTimeSpan();
    }

    public void removeTimelineObject(T node, ILayer layer, S timelineObject) {
        ArrayList<S> list = new ArrayList<S>(1);
        list.add(timelineObject);
        this.removeTimelineObjects(node, layer, list);
    }

    public void removeTimelineObjects(T node, ILayer layer, Collection<S> timelineObjects) {
        if (timelineObjects == null) {
            throw new IllegalArgumentException("collection may not be NULL");
        }
        if (!this.layers.contains(layer)) {
            throw new IllegalArgumentException("layer " + layer + " is not a member of the model");
        }
        node.removeTimelineObjects(layer, timelineObjects);
        Object[] path = this.getPathToRoot((TreeNode)node);
        int s = timelineObjects.size();
        TimelineObjectPath[] tops = new TimelineObjectPath[s];
        int counter = 0;
        for (S object : timelineObjects) {
            tops[counter] = new TimelineObjectPath<S>(path, object, layer);
            ++counter;
        }
        this.fireGanttChartChanged(new GanttChartModelEvent((IGanttChartModel)this, GanttChartModelEvent.ID.TIMELINE_OBJECTS_REMOVED, node, layer, tops));
    }

    public void setTimeSpan(S timelineObject, ITimeSpan span) {
        timelineObject.setTimeSpan(span);
        this.fireGanttChartChanged(new GanttChartModelEvent(this, GanttChartModelEvent.ID.TIMELINE_OBJECT_CHANGED, timelineObject, span));
    }

    public void addRelationship(IRelationship<S> relationship) {
        if (relationship == null) {
            throw new IllegalArgumentException("relationship can not be NULL");
        }
        ArrayList<IRelationship<S>> list = new ArrayList<IRelationship<S>>();
        list.add(relationship);
        this.addRelationships(list);
    }

    public void addRelationships(Collection<IRelationship<S>> relationships) {
        if (relationships == null) {
            throw new IllegalArgumentException("relationships can not be NULL");
        }
        if (relationships.size() > 0) {
            this.relationships.addAll(relationships);
            for (IRelationship<S> r : relationships) {
                TimelineObjectPath<S> targetPath;
                ITimelineObject target;
                Collection<IRelationship<S>> targetCollection;
                TimelineObjectPath<S> sourcePath;
                ITimelineObject source;
                Collection<IRelationship<S>> sourceCollection;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("adding relationship " + r);
                }
                if ((sourceCollection = this.map.get(source = (ITimelineObject)(sourcePath = r.getSourcePath()).getTimelineObject())) == null) {
                    sourceCollection = new ArrayList<IRelationship<S>>();
                    this.map.put(source, sourceCollection);
                }
                if (!sourceCollection.contains(r)) {
                    sourceCollection.add(r);
                }
                if ((targetCollection = this.map.get(target = (ITimelineObject)(targetPath = r.getTargetPath()).getTimelineObject())) == null) {
                    targetCollection = new ArrayList<IRelationship<S>>();
                    this.map.put(target, targetCollection);
                }
                if (targetCollection.contains(r)) continue;
                targetCollection.add(r);
            }
            ArrayList<IRelationship> addedRelationships = new ArrayList<IRelationship>();
            addedRelationships.addAll(relationships);
            GanttChartModelEvent e = new GanttChartModelEvent((IGanttChartModel)this, GanttChartModelEvent.ID.RELATIONSHIP_ADDED, addedRelationships);
            this.fireGanttChartChanged(e);
        }
    }

    public void clearRelationships() {
        LOGGER.fine("clearning all relationships");
        ArrayList<IRelationship> removedRelationships = new ArrayList<IRelationship>();
        removedRelationships.addAll(this.relationships);
        this.relationships.clear();
        this.map.clear();
        GanttChartModelEvent e = new GanttChartModelEvent((IGanttChartModel)this, GanttChartModelEvent.ID.RELATIONSHIP_REMOVED, removedRelationships);
        this.fireGanttChartChanged(e);
    }

    @Override
    public Iterator<IRelationship<S>> getRelationships() {
        return new ArrayList<IRelationship<S>>(this.relationships).iterator();
    }

    public void setRelationships(Collection<IRelationship<S>> relationships) {
        if (relationships == null) {
            throw new IllegalArgumentException("relationships can not be NULL");
        }
        this.clearRelationships();
        for (IRelationship<S> r : relationships) {
            this.addRelationship(r);
        }
    }

    @Override
    public Iterator<IRelationship<S>> getRelationships(S obj) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("getting relationships for " + obj);
            LOGGER.fine("model = " + this + ", relationship map = " + this.map);
        }
        if (this.map != null) {
            Collection<IRelationship<S>> rs = this.map.get(obj);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("relationships = " + this.relationships);
            }
            if (rs != null) {
                return new ArrayList<IRelationship<S>>(rs).iterator();
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("relationship map is NULL, returning no relationships");
        }
        return null;
    }

    public void removeRelationship(IRelationship relationship) {
        if (relationship == null) {
            throw new IllegalArgumentException("relationship can not be NULL");
        }
        ArrayList<IRelationship> list = new ArrayList<IRelationship>();
        list.add(relationship);
        this.removeRelationships(list);
    }

    public void removeRelationships(Collection<IRelationship> rel) {
        if (rel == null) {
            throw new IllegalArgumentException("relationships can not be NULL");
        }
        this.relationships.removeAll(rel);
        for (IRelationship r : rel) {
            Object target;
            Collection<IRelationship<S>> targetCollection;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("removing relationship " + r);
            }
            Object source = r.getSourcePath().getTimelineObject();
            Collection<IRelationship<S>> sourceCollection = this.map.get(source);
            boolean removed = false;
            if (sourceCollection != null) {
                sourceCollection.remove(r);
                removed = true;
            }
            if ((targetCollection = this.map.get(target = r.getTargetPath().getTimelineObject())) != null) {
                targetCollection.remove(r);
                removed = true;
            }
            if (removed) continue;
            throw new IllegalArgumentException("relationship " + r + " was not found in model");
        }
        ArrayList<IRelationship> removedRelationships = new ArrayList<IRelationship>();
        removedRelationships.addAll(rel);
        GanttChartModelEvent e = new GanttChartModelEvent((IGanttChartModel)this, GanttChartModelEvent.ID.RELATIONSHIP_REMOVED, removedRelationships);
        this.fireGanttChartChanged(e);
    }

    public void timelineObjectChanged(S timelineObject) {
        GanttChartModelEvent evt = new GanttChartModelEvent(this, GanttChartModelEvent.ID.TIMELINE_OBJECT_CHANGED, timelineObject, null);
        this.fireGanttChartChanged(evt);
    }

    public TimelineObjectPath getTimelineObjectPath(T node, S timelineObject, ILayer layer) {
        Object[] path = this.getPathToRoot((TreeNode)node);
        return new TimelineObjectPath<S>(path, timelineObject, layer);
    }

    @Override
    public Iterator<S> getChildrenTimelineObjects(S parent) {
        return parent.getChildren();
    }

    @Override
    public boolean isParentTimelineObject(S timelineObject) {
        return timelineObject.isParent();
    }

    public void addSpreadsheet(ISpreadsheet spreadsheet) {
        if (spreadsheet == null) {
            throw new IllegalArgumentException("attempt to add NULL spreadsheet");
        }
        if (this.spreadsheets.contains(spreadsheet)) {
            throw new IllegalArgumentException("the same spreadsheet can not be added twice");
        }
        this.spreadsheets.add(spreadsheet);
        this.fireGanttChartChanged(new GanttChartModelEvent((IGanttChartModel)this, GanttChartModelEvent.ID.SPREADSHEET_ADDED, spreadsheet));
    }

    public void removeSpreadsheet(ISpreadsheet spreadsheet) {
        if (spreadsheet == null) {
            throw new IllegalArgumentException("attempt to remove NULL spreadsheet");
        }
        if (!this.spreadsheets.contains(spreadsheet)) {
            throw new IllegalArgumentException("spreadsheet " + spreadsheet + " is not a member of the model");
        }
        this.spreadsheets.remove(spreadsheet);
        this.fireGanttChartChanged(new GanttChartModelEvent((IGanttChartModel)this, GanttChartModelEvent.ID.SPREADSHEET_REMOVED, spreadsheet));
    }

    @Override
    public Iterator<ISpreadsheet> getSpreadsheets() {
        return new ArrayList<ISpreadsheet>(this.spreadsheets).iterator();
    }

    @Override
    public Object getSpreadsheetValue(ISpreadsheet spreadsheet, T node, ITimeSpan span) {
        return node.getSpreadsheetValue(spreadsheet, span);
    }

    @Override
    public Class getSpreadsheetValueType(ISpreadsheet spreadsheet, T node, ITimeSpan span) {
        Object value = this.getSpreadsheetValue(spreadsheet, node, span);
        if (value != null) {
            return value.getClass();
        }
        return spreadsheet.getDefaultValueType();
    }

    public void setSpreadsheetValue(T node, ISpreadsheet spreadsheet, ITimeSpan span, Object value) {
        node.setSpreadsheetValue(spreadsheet, value, span);
        this.fireGanttChartChanged(new GanttChartModelEvent((IGanttChartModel)this, GanttChartModelEvent.ID.SPREADSHEET_VALUE_CHANGED, node, span, value));
    }
}

