/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.model.eventline;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.eventline.EventlineModelEvent;
import com.dlsc.flexgantt.model.eventline.IEventlineModel;
import com.dlsc.flexgantt.model.eventline.IEventlineModelListener;
import com.dlsc.flexgantt.model.eventline.IEventlineObject;
import com.dlsc.flexgantt.model.gantt.LinearSearchTimelineObjectIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.EventListenerList;

public class DefaultEventlineModel<T extends IEventlineObject>
implements IEventlineModel<T> {
    private EventListenerList listenerList = new EventListenerList();
    private List<T> objectList = new ArrayList<T>();

    @Override
    public Iterator<T> getEventlineObjectsIterator(ITimeSpan span) {
        if (span == null) {
            throw new IllegalArgumentException("time span can not be NULL");
        }
        return new LinearSearchTimelineObjectIterator<T>(this.objectList, span);
    }

    @Override
    public ITimeSpan getTimeSpan(T eventlineObject) {
        if (eventlineObject == null) {
            throw new IllegalArgumentException("eventline object can not be NULL");
        }
        return eventlineObject.getTimeSpan();
    }

    public void setTimeSpan(T eventlineObject, ITimeSpan span) {
        eventlineObject.setTimeSpan(span);
        this.fireEventlineModelEvent(new EventlineModelEvent((IEventlineModel)this, EventlineModelEvent.ID.EVENTLINE_OBJECT_TIME_SPAN_CHANGED, eventlineObject));
    }

    public void addEventlineObject(T eventlineObject) {
        if (eventlineObject == null) {
            throw new IllegalArgumentException("eventline object can not be NULL");
        }
        ArrayList<T> list = new ArrayList<T>(1);
        list.add(eventlineObject);
        this.addEventlineObjects(list);
    }

    @Override
    public void addEventlineObjects(Collection<T> eventlineObjects) {
        if (eventlineObjects == null) {
            throw new IllegalArgumentException("list of eventline objects can not be NULL");
        }
        this.objectList.addAll(eventlineObjects);
        Collections.sort(this.objectList);
        EventlineModelEvent evt = new EventlineModelEvent((IEventlineModel)this, EventlineModelEvent.ID.EVENTLINE_OBJECTS_ADDED, eventlineObjects);
        this.fireEventlineModelEvent(evt);
    }

    public void removeEventlineObject(T eventlineObject) {
        if (eventlineObject == null) {
            throw new IllegalArgumentException("eventline object can not be NULL");
        }
        ArrayList<T> list = new ArrayList<T>(1);
        list.add(eventlineObject);
        this.removeEventlineObjects(list);
    }

    @Override
    public void removeEventlineObjects(Collection<T> eventlineObjects) {
        if (eventlineObjects == null) {
            throw new IllegalArgumentException("list of eventline objects can not be NULL");
        }
        this.objectList.removeAll(eventlineObjects);
        EventlineModelEvent evt = new EventlineModelEvent((IEventlineModel)this, EventlineModelEvent.ID.EVENTLINE_OBJECTS_REMOVED, eventlineObjects);
        this.fireEventlineModelEvent(evt);
    }

    public void clearEventlineObjects() {
        this.removeEventlineObjects(this.objectList);
    }

    public List<T> getEventlineObjects() {
        return this.objectList;
    }

    @Override
    public void addEventlineModelListener(IEventlineModelListener l) {
        if (l == null) {
            throw new IllegalArgumentException("listener can not be NULL");
        }
        this.listenerList.add(IEventlineModelListener.class, l);
    }

    @Override
    public void removeEventlineModelListener(IEventlineModelListener l) {
        if (l == null) {
            throw new IllegalArgumentException("listener can not be NULL");
        }
        this.listenerList.remove(IEventlineModelListener.class, l);
    }

    protected void fireEventlineModelEvent(EventlineModelEvent evt) {
        if (evt == null) {
            throw new IllegalArgumentException("event object can not be NULL");
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IEventlineModelListener.class) continue;
            ((IEventlineModelListener)listeners[i + 1]).eventlineChanged(evt);
        }
    }
}

