/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.model.dateline;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.dateline.IGranularity;
import com.dlsc.flexgantt.model.dateline.MarkerType;
import com.dlsc.flexgantt.util.Messages;
import java.util.logging.Level;
import java.util.logging.Logger;

public enum SimpleGranularity implements IGranularity<SimpleGranularity>
{
    ONE(Messages.getString("SimpleGranularity.ONE"), 1L),
    TEN(Messages.getString("SimpleGranularity.TEN"), 10L),
    HUNDRED(Messages.getString("SimpleGranularity.ONE_HUNDRED"), 100L),
    THOUSAND(Messages.getString("SimpleGranularity.ONE_THOUSAND"), 1000L),
    THOUSAND_TEN(Messages.getString("SimpleGranularity.TEN_THOUSAND"), 10000L),
    THOUSAND_HUNDRED(Messages.getString("SimpleGranularity.ONE_HUNDRED_THOUSAND"), 100000L),
    MILLION(Messages.getString("SimpleGranularity.ONE_MILLION"), 1000000L),
    MILLION_TEN(Messages.getString("SimpleGranularity.TEN_MILLION"), 10000000L),
    MILLION_HUNDRED(Messages.getString("SimpleGranularity.ONE_HUNDRED_MILLION"), 100000000L),
    BILLION(Messages.getString("SimpleGranularity.ONE_BILLION"), 1000000000L),
    BILLION_TEN(Messages.getString("SimpleGranularity.TEN_BILLION"), 10000000000L),
    BILLION_HUNDRED(Messages.getString("SimpleGranularity.ONE_HUNDRED_BILLION"), 100000000000L),
    TRILLION(Messages.getString("SimpleGranularity.ONE_TRILLION"), 1000000000000L);

    private static final Logger LOGGER;
    private String name;
    private long millis;

    private SimpleGranularity(String name, long millis) {
        this.name = name;
        this.millis = millis;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSingularName() {
        return this.getName();
    }

    public long increment(long time) {
        return time + this.millis;
    }

    public long decrement(long time) {
        long result = time - this.millis;
        return result;
    }

    public long adjust(long time) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("raw time = " + time);
            LOGGER.fine("granularity = " + this);
        }
        long adjusted = time / this.millis * this.millis;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("adjusted time = " + time);
        }
        return adjusted;
    }

    public long getMillis() {
        return this.millis;
    }

    @Override
    public long getStandardDuration() {
        return this.getMillis();
    }

    public double getDelta(ITimeSpan span) {
        if (span == null) {
            throw new IllegalArgumentException("time span can not be NULL");
        }
        long diff = span.getEndTime() - span.getStartTime();
        return (double)diff / (double)this.millis;
    }

    public SimpleGranularity next() {
        int ordinal = this.ordinal();
        if (ordinal < SimpleGranularity.values().length - 1) {
            return SimpleGranularity.values()[ordinal + 1];
        }
        return null;
    }

    public SimpleGranularity previous() {
        int ordinal = this.ordinal();
        if (ordinal > 0) {
            return SimpleGranularity.values()[ordinal - 1];
        }
        return null;
    }

    @Override
    public boolean isSmaller(SimpleGranularity sg) {
        return this.millis < sg.getMillis();
    }

    @Override
    public boolean isLarger(SimpleGranularity sg) {
        return this.millis > sg.getMillis();
    }

    @Override
    public boolean isDisplayingMarkerType(MarkerType type) {
        return false;
    }

    static {
        LOGGER = Logger.getLogger(SimpleGranularity.class.getName());
    }
}

