/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.command.layer;

import com.dlsc.flexgantt.command.AbstractCommand;
import com.dlsc.flexgantt.command.CommandException;
import com.dlsc.flexgantt.command.IProgressMonitor;
import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartModel;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartNode;
import com.dlsc.flexgantt.model.gantt.ILayer;
import com.dlsc.flexgantt.model.gantt.ITimelineObject;
import com.dlsc.flexgantt.util.Messages;

public class DefaultChangeTimelineObjectTimeSpanCommand
extends AbstractCommand {
    private ITimeSpan oldTimeSpan;
    private ITimeSpan newTimeSpan;
    private ITimelineObject timelineObject;
    private DefaultGanttChartModel model;
    private DefaultGanttChartNode node;
    private ILayer layer;
    private int dropAction;

    public DefaultChangeTimelineObjectTimeSpanCommand(DefaultGanttChartNode node, ILayer layer, ITimelineObject object, DefaultGanttChartModel model, ITimeSpan span, int dropAction) {
        super(Messages.getString("DefaultChangeTimelineObjectTimeSpanCommand.NAME"));
        if (node == null) {
            throw new IllegalArgumentException("node can not be NULL");
        }
        if (layer == null) {
            throw new IllegalArgumentException("layer can not be NULL");
        }
        if (object == null) {
            throw new IllegalArgumentException("timeline object can not be NULL");
        }
        if (model == null) {
            throw new IllegalArgumentException("model can not be NULL");
        }
        if (span == null) {
            throw new IllegalArgumentException("span can not be NULL");
        }
        this.node = node;
        this.layer = layer;
        this.timelineObject = object;
        this.model = model;
        this.newTimeSpan = span;
        this.oldTimeSpan = model.getTimeSpan(this.timelineObject);
        this.dropAction = dropAction;
    }

    @Override
    public void executeCommand(IProgressMonitor monitor) throws CommandException {
        this.model.setTimeSpan(this.timelineObject, this.newTimeSpan);
        this.node.sortTimelineObjects(this.layer);
    }

    @Override
    public void undoCommand(IProgressMonitor monitor) throws CommandException {
        this.model.setTimeSpan(this.timelineObject, this.oldTimeSpan);
        this.node.sortTimelineObjects(this.layer);
    }

    public DefaultGanttChartModel getModel() {
        return this.model;
    }

    public ITimeSpan getNewTimeSpan() {
        return this.newTimeSpan;
    }

    public ITimeSpan getOldTimeSpan() {
        return this.oldTimeSpan;
    }

    public ITimelineObject getTimelineObject() {
        return this.timelineObject;
    }

    public ILayer getLayer() {
        return this.layer;
    }

    public DefaultGanttChartNode getNode() {
        return this.node;
    }

    public int getDropAction() {
        return this.dropAction;
    }
}

