/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

public class InternalTypeEnumeration {
    private String descriptor;
    private int firstIndex;
    private int lastIndex;
    private int index;

    public InternalTypeEnumeration(String string) {
        this.descriptor = string;
        this.firstIndex = string.indexOf(40);
        this.lastIndex = string.indexOf(41);
        this.index = this.firstIndex + 1;
        if (this.lastIndex < 0) {
            this.lastIndex = string.length();
        }
    }

    public String formalTypeParameters() {
        return this.descriptor.substring(0, this.firstIndex);
    }

    public boolean hasMoreTypes() {
        return this.index < this.lastIndex;
    }

    public String nextType() {
        int n = this.index;
        this.skipArray();
        char c2 = this.descriptor.charAt(this.index++);
        switch (c2) {
            case 'L': 
            case 'T': {
                this.skipClass();
                break;
            }
            case '<': {
                this.skipGeneric();
            }
        }
        return this.descriptor.substring(n, this.index);
    }

    public String returnType() {
        return this.descriptor.substring(this.lastIndex + 1);
    }

    private void skipArray() {
        while (this.descriptor.charAt(this.index) == '[') {
            ++this.index;
        }
    }

    private void skipClass() {
        while (true) {
            char c2 = this.descriptor.charAt(this.index++);
            switch (c2) {
                case '<': {
                    this.skipGeneric();
                    break;
                }
                case ';': {
                    return;
                }
            }
        }
    }

    private void skipGeneric() {
        int n = 1;
        do {
            char c2 = this.descriptor.charAt(this.index++);
            switch (c2) {
                case '<': {
                    ++n;
                    break;
                }
                case '>': {
                    --n;
                }
            }
        } while (n > 0);
    }

    public static void main(String[] stringArray) {
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                System.out.println("Descriptor [" + string + "]");
                InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(string);
                if (internalTypeEnumeration.firstIndex >= 0) {
                    System.out.println("  Formal type parameters [" + internalTypeEnumeration.formalTypeParameters() + "]");
                }
                while (internalTypeEnumeration.hasMoreTypes()) {
                    System.out.println("  Type [" + internalTypeEnumeration.nextType() + "]");
                }
                if (internalTypeEnumeration.lastIndex >= string.length()) continue;
                System.out.println("  Return type [" + internalTypeEnumeration.returnType() + "]");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

