/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractOsmTileSource;

public class OsmTileSource {
    public static final String MAP_MAPNIK = "http://tile.openstreetmap.org";

    public static class CycleMap
    extends AbstractOsmTileSource {
        private static final String PATTERN = "http://%s.tile.opencyclemap.org/cycle";
        private static final String[] SERVER = new String[]{"a", "b", "c"};
        private int SERVER_NUM = 0;

        public CycleMap() {
            super("OSM Cycle Map", PATTERN);
        }

        @Override
        public String getBaseUrl() {
            String url = String.format(this.baseUrl, SERVER[this.SERVER_NUM]);
            this.SERVER_NUM = (this.SERVER_NUM + 1) % SERVER.length;
            return url;
        }

        @Override
        public int getMaxZoom() {
            return 18;
        }

        @Override
        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.LastModified;
        }
    }

    public static class Mapnik
    extends AbstractOsmTileSource {
        public Mapnik() {
            super("Mapnik", OsmTileSource.MAP_MAPNIK);
        }

        @Override
        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }
    }
}

