/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import org.openstreetmap.gui.jmapviewer.AbstractLayer;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.Layer;
import org.openstreetmap.gui.jmapviewer.LayerGroup;
import org.openstreetmap.gui.jmapviewer.checkBoxTree.CheckBoxNodePanel;
import org.openstreetmap.gui.jmapviewer.checkBoxTree.CheckBoxTree;
import org.openstreetmap.gui.jmapviewer.interfaces.MapObject;

public class JMapViewerTree
extends JPanel {
    private static final long serialVersionUID = 3050203054402323972L;
    private JMapViewer map;
    private CheckBoxTree tree;
    private JPanel treePanel;
    private JSplitPane splitPane = new JSplitPane(1);

    public JMapViewerTree(String name) {
        this(name, false);
    }

    public JMapViewerTree(String name, boolean treeVisible) {
        this.tree = new CheckBoxTree(name);
        this.treePanel = new JPanel();
        this.treePanel.setLayout(new BorderLayout());
        this.treePanel.add((Component)this.tree, "Center");
        this.treePanel.add((Component)new JLabel("<html><center>Use right mouse button to<br />show/hide texts</center></html>"), "South");
        this.map = new JMapViewer();
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(150);
        Dimension minimumSize = new Dimension(100, 50);
        this.map.setMinimumSize(minimumSize);
        this.createRefresh();
        this.setLayout(new BorderLayout());
        this.setTreeVisible(treeVisible);
        this.tree.addNodeListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    e.getSource();
                    AbstractLayer layer = ((CheckBoxNodePanel)e.getComponent()).getData().getAbstractLayer();
                    if (layer != null) {
                        JMapViewerTree.this.createPopupMenu(layer).show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }
        });
    }

    private JPopupMenu createPopupMenu(final AbstractLayer layer) {
        JMenuItem menuItemShow = new JMenuItem("show texts");
        JMenuItem menuItemHide = new JMenuItem("hide texts");
        JPopupMenu popup = new JPopupMenu();
        if (layer.isVisibleTexts() == null) {
            popup.add(menuItemShow);
            popup.add(menuItemHide);
        } else if (layer.isVisibleTexts().booleanValue()) {
            popup.add(menuItemHide);
        } else {
            popup.add(menuItemShow);
        }
        menuItemShow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JMapViewerTree.this.setVisibleTexts(layer, true);
                if (layer.getParent() != null) {
                    layer.getParent().calculateVisibleTexts();
                }
                JMapViewerTree.this.map.repaint();
            }
        });
        menuItemHide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JMapViewerTree.this.setVisibleTexts(layer, false);
                if (layer.getParent() != null) {
                    layer.getParent().calculateVisibleTexts();
                }
                JMapViewerTree.this.map.repaint();
            }
        });
        return popup;
    }

    private void setVisibleTexts(AbstractLayer layer, boolean visible) {
        LayerGroup group;
        layer.setVisibleTexts(visible);
        if (layer instanceof LayerGroup && (group = (LayerGroup)layer).getLayers() != null) {
            for (AbstractLayer al : group.getLayers()) {
                this.setVisibleTexts(al, visible);
            }
        }
    }

    public Layer addLayer(String name) {
        Layer layer = new Layer(name);
        this.addLayer(layer);
        return layer;
    }

    public JMapViewerTree addLayer(Layer layer) {
        this.tree.addLayer(layer);
        return this;
    }

    public JMapViewerTree addLayer(MapObject element) {
        return this.addLayer(element.getLayer());
    }

    public Layer removeFromLayer(MapObject element) {
        element.getLayer().getElements().remove(element);
        return element.getLayer();
    }

    public static int size(List<?> list) {
        return list == null ? 0 : list.size();
    }

    public JMapViewer getViewer() {
        return this.map;
    }

    public CheckBoxTree getTree() {
        return this.tree;
    }

    public void addMapObject(MapObject o) {
    }

    public void setTreeVisible(boolean visible) {
        this.removeAll();
        this.revalidate();
        if (visible) {
            this.splitPane.setLeftComponent(this.treePanel);
            this.splitPane.setRightComponent(this.map);
            this.add((Component)this.splitPane, "Center");
        } else {
            this.add((Component)this.map, "Center");
        }
        this.repaint();
    }

    private void createRefresh() {
        this.tree.getModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                JMapViewerTree.this.repaint();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent arg0) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent arg0) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent arg0) {
            }
        });
    }
}

