/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.table;

import impl.org.controlsfx.table.DupeCounter;
import impl.org.controlsfx.table.FilterPanel;
import impl.org.controlsfx.table.FilterValue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.BiPredicate;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.TableColumn;
import org.controlsfx.control.table.TableFilter;

public final class ColumnFilter<T, R> {
    private final TableFilter<T> tableFilter;
    private final TableColumn<T, R> tableColumn;
    private final ObservableList<FilterValue<T, R>> filterValues;
    private final DupeCounter<R> filterValuesDupeCounter;
    private final DupeCounter<R> visibleValuesDupeCounter;
    private final HashSet<R> unselectedValues;
    private final HashMap<CellIdentity<T>, ChangeListener<R>> trackedCells;
    private boolean lastFilter;
    private boolean isDirty;
    private BiPredicate<String, String> searchStrategy;
    private volatile FilterPanel filterPanel;
    private boolean initialized;

    /*
     * Exception decompiling
     */
    public ColumnFilter(TableFilter<T> tableFilter, TableColumn<T, R> tableColumn) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void setFilterPanel(FilterPanel filterPanel) {
        this.filterPanel = filterPanel;
    }

    FilterPanel getFilterPanel() {
        return this.filterPanel;
    }

    public void initialize() {
        if (!this.initialized) {
            this.initializeListeners();
            this.initializeValues();
            this.initialized = true;
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void selectValue(Object value) {
        this.filterPanel.selectValue(value);
    }

    public void unselectValue(Object value) {
        this.filterPanel.unSelectValue(value);
    }

    public void selectAllValues() {
        this.filterPanel.selectAllValues();
    }

    public void unSelectAllValues() {
        this.filterPanel.unSelectAllValues();
    }

    public boolean wasLastFiltered() {
        return this.lastFilter;
    }

    public boolean hasUnselections() {
        return this.unselectedValues.size() != 0;
    }

    public void setSearchStrategy(BiPredicate<String, String> searchStrategy) {
        this.searchStrategy = searchStrategy;
    }

    public BiPredicate<String, String> getSearchStrategy() {
        return this.searchStrategy;
    }

    public boolean isFiltered() {
        return this.isDirty || this.unselectedValues.size() > 0;
    }

    public boolean valueIsVisible(R value) {
        return this.visibleValuesDupeCounter.get(value) > 0;
    }

    public void applyFilter() {
        this.tableFilter.executeFilter();
        this.lastFilter = true;
        this.tableFilter.getColumnFilters().stream().filter(c2 -> !c2.equals(this)).forEach(c2 -> {
            c2.lastFilter = false;
        });
        this.tableFilter.getColumnFilters().stream().flatMap(c2 -> c2.filterValues.stream()).forEach(FilterValue::refreshScope);
        this.isDirty = false;
    }

    public void resetAllFilters() {
        this.tableFilter.getColumnFilters().stream().flatMap(c2 -> c2.filterValues.stream()).forEach(fv -> fv.selectedProperty().set(true));
        this.tableFilter.resetFilter();
        this.tableFilter.getColumnFilters().stream().forEach(c2 -> {
            c2.lastFilter = false;
        });
        this.tableFilter.getColumnFilters().stream().flatMap(c2 -> c2.filterValues.stream()).forEach(FilterValue::refreshScope);
        this.isDirty = false;
    }

    public ObservableList<FilterValue<T, R>> getFilterValues() {
        return this.filterValues;
    }

    public TableColumn<T, ?> getTableColumn() {
        return this.tableColumn;
    }

    public TableFilter<T> getTableFilter() {
        return this.tableFilter;
    }

    public boolean evaluate(T item) {
        ObservableValue value = this.tableColumn.getCellObservableValue(item);
        return this.unselectedValues.size() == 0 || !this.unselectedValues.contains(value.getValue());
    }

    private void initializeValues() {
        this.tableFilter.getBackingList().stream().forEach(t -> this.addBackingItem(t, this.tableColumn.getCellObservableValue(t)));
        this.tableFilter.getTableView().getItems().stream().map(arg_0 -> this.tableColumn.getCellObservableValue(arg_0)).forEach(this::addVisibleItem);
    }

    private void addBackingItem(T item, ObservableValue<R> cellValue) {
        if (cellValue == null) {
            return;
        }
        if (this.filterValuesDupeCounter.add(cellValue.getValue()) == 1) {
            this.filterValues.add(new FilterValue(cellValue.getValue(), this));
        }
        CellIdentity<T> trackedCellValue = new CellIdentity<T>(item);
        ChangeListener changeListener = (observable, oldValue, newValue) -> {
            if (this.filterValuesDupeCounter.add(newValue) == 1) {
                this.filterValues.add(new FilterValue(newValue, this));
            }
            if (this.filterValuesDupeCounter.remove(oldValue) == 0) {
                FilterValue existingFilterValue = this.filterValues.stream().filter(fv -> Optional.ofNullable(fv.getValue()).equals(Optional.ofNullable(oldValue))).findAny().get();
                this.filterValues.remove((Object)existingFilterValue);
            }
        };
        cellValue.addListener(changeListener);
        this.trackedCells.put(trackedCellValue, changeListener);
    }

    private void removeBackingItem(T item, ObservableValue<R> cellValue) {
        if (cellValue == null) {
            return;
        }
        if (this.filterValuesDupeCounter.remove(cellValue.getValue()) == 0) {
            FilterValue existingFilterValue = this.filterValues.stream().filter(fv -> Optional.ofNullable(fv.getValue()).equals(Optional.ofNullable(cellValue.getValue()))).findAny().get();
            this.filterValues.remove((Object)existingFilterValue);
        }
        ChangeListener<R> listener = this.trackedCells.get(new CellIdentity<T>(item));
        cellValue.removeListener(listener);
        this.trackedCells.remove(new CellIdentity<T>(item));
    }

    private void addVisibleItem(ObservableValue<R> cellValue) {
        if (cellValue != null) {
            this.visibleValuesDupeCounter.add(cellValue.getValue());
        }
    }

    private void removeVisibleItem(ObservableValue<R> cellValue) {
        if (cellValue != null) {
            this.visibleValuesDupeCounter.remove(cellValue.getValue());
        }
    }

    private void initializeListeners() {
        this.tableFilter.getBackingList().addListener(lc -> {
            while (lc.next()) {
                if (lc.wasAdded()) {
                    lc.getAddedSubList().stream().forEach(t -> this.addBackingItem(t, this.tableColumn.getCellObservableValue(t)));
                }
                if (!lc.wasRemoved()) continue;
                lc.getRemoved().stream().forEach(t -> this.removeBackingItem(t, this.tableColumn.getCellObservableValue(t)));
            }
        });
        this.tableFilter.getTableView().getItems().addListener(lc -> {
            while (lc.next()) {
                if (lc.wasAdded()) {
                    lc.getAddedSubList().stream().map(arg_0 -> this.tableColumn.getCellObservableValue(arg_0)).forEach(this::addVisibleItem);
                }
                if (!lc.wasRemoved()) continue;
                lc.getRemoved().stream().map(arg_0 -> this.tableColumn.getCellObservableValue(arg_0)).forEach(this::removeVisibleItem);
            }
        });
        this.filterValues.addListener(lc -> {
            while (lc.next()) {
                if (lc.wasRemoved()) {
                    lc.getRemoved().stream().filter(v -> !v.selectedProperty().get()).forEach(this.unselectedValues::remove);
                }
                if (!lc.wasUpdated()) continue;
                int from = lc.getFrom();
                int to = lc.getTo();
                lc.getList().subList(from, to).forEach(v -> {
                    boolean value = v.selectedProperty().getValue();
                    if (!value) {
                        this.isDirty = true;
                        this.unselectedValues.add(v.getValue());
                    } else {
                        this.isDirty = true;
                        this.unselectedValues.remove(v.getValue());
                    }
                });
            }
        });
    }

    private void attachContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        CustomMenuItem item = FilterPanel.getInMenuItem(this, contextMenu);
        contextMenu.getStyleClass().add((Object)"column-filter");
        contextMenu.getItems().add((Object)item);
        this.tableColumn.setContextMenu(contextMenu);
        contextMenu.setOnShowing(ae -> this.initialize());
    }

    private static final class CellIdentity<T> {
        private final T item;

        CellIdentity(T item) {
            this.item = item;
        }

        public boolean equals(Object other) {
            return this.item == ((CellIdentity)other).item;
        }

        public int hashCode() {
            return System.identityHashCode(this.item);
        }
    }
}

