/*
 * Decompiled with CFR 0.152.
 */
package impl.com.flexganttfx.skin.util;

import com.flexganttfx.model.Activity;
import impl.com.flexganttfx.skin.util.Cluster;
import impl.com.flexganttfx.skin.util.Placement;
import impl.com.flexganttfx.skin.util.ResolverResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;

public final class Resolver {
    protected Resolver() {
    }

    public static <A extends Activity> ResolverResult<A> resolve(List<A> activities) {
        return Resolver.resolve(activities, activity -> true);
    }

    public static <A extends Activity> ResolverResult<A> resolve(List<A> activities, Predicate<A> filter) {
        int maxColumns = 0;
        HashMap<Activity, Placement<A>> placements = new HashMap<Activity, Placement<A>>();
        if (activities.size() == 1) {
            Activity activity = (Activity)activities.get(0);
            placements.put(activity, new Placement<Activity>(activity, 0, 1));
            maxColumns = 1;
        } else {
            ArrayList clusters = new ArrayList();
            Cluster<Activity> cluster = null;
            for (Activity activity : activities) {
                if (cluster == null || !cluster.intersects(activity)) {
                    cluster = new Cluster<Activity>();
                    clusters.add(cluster);
                }
                cluster.add(activity);
            }
            for (Cluster c2 : new ArrayList(clusters)) {
                if (c2.getActivities().size() == 1) {
                    Activity activity = (Activity)c2.getActivities().get(0);
                    placements.put(activity, new Placement<Activity>(activity, 0, 1));
                    maxColumns = Math.max(maxColumns, 1);
                    continue;
                }
                placements.putAll(c2.resolve(filter));
                maxColumns = Math.max(maxColumns, c2.getColumnCount());
            }
        }
        return new ResolverResult(placements, maxColumns);
    }
}

