/*
 * Decompiled with CFR 0.152.
 */
package impl.com.flexganttfx.skin.util;

import com.flexganttfx.model.layout.AgendaLayout;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;

public final class AgendaHelper {
    private AgendaHelper() {
    }

    private static double getTimeLocation(LocalTime time, LocalTime startTime, LocalTime endTime, double height) {
        long startNano = startTime.toNanoOfDay();
        long endNano = endTime.toNanoOfDay();
        double npp = (double)(endNano - startNano) / height;
        return (double)(time.toNanoOfDay() - startNano) / npp;
    }

    public static LocalTime getTimeAt(double y, double availableHeight, LocalTime startTime, LocalTime endTime) {
        long startNano = startTime.toNanoOfDay();
        long endNano = endTime.toNanoOfDay();
        double npp = (double)(endNano - startNano) / availableHeight;
        return LocalTime.ofNanoOfDay(Math.max(LocalTime.MIN.toNanoOfDay(), Math.min(LocalTime.MAX.toNanoOfDay(), (long)(y * npp) + startNano)));
    }

    public static List<AgendaLineLocation> getLineLocations(AgendaLayout layout, double yOffset, double height) {
        ArrayList<AgendaLineLocation> result = new ArrayList<AgendaLineLocation>();
        LocalTime startTime = layout.getStartTime().withMinute(0);
        LocalTime endTime = layout.getEndTime();
        if (endTime.isBefore(startTime)) {
            throw new IllegalArgumentException("the end time of the agenda layout is BEFORE the start time, start = " + layout.getStartTime() + ", end = " + layout.getEndTime());
        }
        LocalTime time = startTime;
        LocalTime lastTime = null;
        long stepRate = AgendaHelper.computeStepRate(layout, height);
        boolean nextDay = false;
        do {
            AgendaHelper.createLinesForTime(layout, yOffset, height, result, time, lastTime);
            lastTime = time;
            LocalTime nextTime = time.plusHours(stepRate);
            if (nextTime.isBefore(time)) {
                nextDay = true;
                continue;
            }
            time = nextTime;
        } while (!time.isAfter(endTime) && !nextDay);
        if (!time.minusHours(stepRate).equals(layout.getEndTime())) {
            time = layout.getEndTime();
            AgendaHelper.createLinesForTime(layout, yOffset, height, result, time, lastTime);
        }
        return result;
    }

    private static void createLinesForTime(AgendaLayout layout, double yOffset, double height, List<AgendaLineLocation> result, LocalTime time, LocalTime lastTime) {
        LocalTime startTime = layout.getStartTime().withMinute(0);
        LocalTime endTime = layout.getEndTime();
        double y = yOffset + AgendaHelper.getTimeLocation(time, startTime, endTime, height);
        result.add(new AgendaLineLocation(time, y, false));
        if (lastTime != null) {
            long minutesUntil = lastTime.until(time, ChronoUnit.MINUTES) / 2L;
            LocalTime minorTime = time.minusMinutes(minutesUntil);
            double minorY = yOffset + AgendaHelper.getTimeLocation(minorTime, startTime, endTime, height);
            result.add(new AgendaLineLocation(minorTime, minorY, true));
        }
    }

    static long computeStepRate(AgendaLayout layout, double height) {
        long rate;
        long st = layout.getStartTime().getHour();
        long et = layout.getEndTime().getHour();
        if (layout.getEndTime().equals(LocalTime.MAX)) {
            et = 24L;
        }
        long hours = et - st;
        for (rate = 1L; rate <= 12L; ++rate) {
            if (hours % rate != 0L || !(height / (double)(hours / rate) >= layout.getMinLineSpacing())) continue;
            return rate;
        }
        for (rate = 1L; rate <= 12L; ++rate) {
            if (!(height / (double)(hours / rate) >= layout.getMinLineSpacing())) continue;
            return rate;
        }
        return -1L;
    }

    public static final class AgendaLineLocation {
        private final LocalTime time;
        private final double location;
        private final boolean minor;

        public AgendaLineLocation(LocalTime time, double location, boolean minor) {
            this.time = time;
            this.location = (double)((int)location) + 0.5;
            this.minor = minor;
        }

        public LocalTime getTime() {
            return this.time;
        }

        public double getLocation() {
            return this.location;
        }

        public boolean isMinor() {
            return this.minor;
        }
    }
}

