/*
 * Decompiled with CFR 0.152.
 */
package impl.com.flexganttfx.skin.graphics;

import com.flexganttfx.model.ActivityRef;
import com.flexganttfx.model.Row;
import com.flexganttfx.view.graphics.ActivityBounds;
import com.flexganttfx.view.graphics.SplitPaneGraphics;
import impl.com.flexganttfx.skin.graphics.GraphicsBaseSkin;
import impl.com.flexganttfx.skin.graphics.RowCanvas;
import impl.com.flexganttfx.skin.graphics.RowPane;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.SplitPane;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;
import javafx.util.Callback;

public class SplitPaneGraphicsSkin<R extends Row<?, ?, ?>>
extends GraphicsBaseSkin<SplitPaneGraphics<R>, R> {
    private final SplitPane splitPane;

    public SplitPaneGraphicsSkin(SplitPaneGraphics<R> graphics) {
        super(graphics);
        this.splitPane = graphics.getSplitPane();
        graphics.getRows().addListener(evt -> this.updateSplitPane());
        this.updateSplitPane();
    }

    private void updateSplitPane() {
        this.splitPane.getItems().clear();
        SplitPaneGraphics graphics = (SplitPaneGraphics)this.getSkinnable();
        graphics.getRowPanes().clear();
        Callback resizableCallback = graphics.getResizableCallback();
        for (Row row : graphics.getRows()) {
            Boolean resizable;
            RowPane rowPane = new RowPane(graphics);
            rowPane.getStyleClass().add((Object)"splitpane-row-pane");
            if (resizableCallback != null && (resizable = (Boolean)resizableCallback.call((Object)row)) != null) {
                SplitPane.setResizableWithParent(rowPane, (Boolean)resizable);
            }
            rowPane.setRow(row);
            this.splitPane.getItems().add(rowPane);
            graphics.getRowPanes().add(rowPane);
        }
    }

    @Override
    protected Region createRowPaneRegion() {
        SplitPaneGraphics graphics = (SplitPaneGraphics)this.getSkinnable();
        SplitPane splitPane = graphics.getSplitPane();
        splitPane.setOrientation(Orientation.VERTICAL);
        return splitPane;
    }

    @Override
    protected RowPane<R> getRowPaneAt(double y) {
        for (Node node : this.splitPane.getItems()) {
            if (!(node instanceof RowPane)) continue;
            Point2D point = this.splitPane.localToScene(0.0, y);
            Bounds sceneNodeBounds = node.localToScene(node.getBoundsInLocal());
            if (!sceneNodeBounds.contains(point)) continue;
            return (RowPane)node;
        }
        return null;
    }

    @Override
    protected boolean isRowAboveViewport(R row) {
        return false;
    }

    @Override
    protected List<Row<?, ?, ?>> findLassoSelectedRows() {
        ArrayList rows = new ArrayList();
        Rectangle lasso = this.getLasso();
        Bounds localLassoBounds = lasso.getBoundsInLocal();
        Bounds sceneLassoBounds = lasso.localToScene(localLassoBounds);
        this.splitPane.getItems().stream().filter(node -> node instanceof RowPane).forEach(node -> {
            RowPane pane;
            Object row;
            Bounds sceneNodeBounds = node.localToScene(node.getBoundsInLocal());
            if (sceneNodeBounds.intersects(sceneLassoBounds) && (row = (pane = (RowPane)((Object)node)).getRow()) != null) {
                rows.add((Row<?, ?, ?>)row);
            }
        });
        return rows;
    }

    @Override
    protected List<ActivityRef<?>> findLassoSelectedActivities() {
        ArrayList selection = new ArrayList();
        Rectangle lasso = this.getLasso();
        Bounds localLassoBounds = lasso.getBoundsInLocal();
        Bounds sceneLassoBounds = lasso.localToScene(localLassoBounds);
        for (Node node : this.splitPane.getItems()) {
            Bounds sceneNodeBounds;
            if (!(node instanceof RowPane) || !(sceneNodeBounds = node.localToScene(node.getBoundsInLocal())).intersects(sceneLassoBounds)) continue;
            RowPane rowPane = (RowPane)node;
            RowCanvas rowCanvas = rowPane.getCanvas();
            double x = localLassoBounds.getMinX();
            double y = Math.max(0.0, sceneLassoBounds.getMinY() - sceneNodeBounds.getMinY());
            double w = localLassoBounds.getWidth();
            double h = localLassoBounds.getHeight();
            if (sceneNodeBounds.getMinY() > sceneLassoBounds.getMinY()) {
                y -= sceneNodeBounds.getMinY() - sceneLassoBounds.getMinY();
            }
            List<ActivityBounds> activityBounds = rowCanvas.getActivityBounds(x, y, w, h);
            List refs = activityBounds.stream().map(ActivityBounds::getActivityRef).collect(Collectors.toList());
            selection.addAll(refs);
        }
        return selection;
    }
}

