/*
 * Decompiled with CFR 0.152.
 */
package impl.com.flexganttfx.skin.graphics;

import com.flexganttfx.model.ActivityRef;
import com.flexganttfx.model.Row;
import com.flexganttfx.view.graphics.ActivityBounds;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.SingleRowGraphics;
import impl.com.flexganttfx.skin.graphics.GraphicsBaseSkin;
import impl.com.flexganttfx.skin.graphics.RowCanvas;
import impl.com.flexganttfx.skin.graphics.RowPane;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;

public class SingleRowGraphicsSkin<R extends Row<?, ?, ?>>
extends GraphicsBaseSkin<SingleRowGraphics<R>, R> {
    private RowPane<R> rowPane;

    public SingleRowGraphicsSkin(SingleRowGraphics<R> graphics) {
        super(graphics);
    }

    @Override
    protected final Region createRowPaneRegion() {
        this.rowPane = new RowPane((GraphicsBase)this.getSkinnable());
        ((SingleRowGraphics)this.getSkinnable()).prefHeightProperty().bind((ObservableValue)this.rowPane.prefHeightProperty());
        Row row = (Row)((SingleRowGraphics)this.getSkinnable()).getRows().get(0);
        this.rowPane.setRow(row);
        this.rowPane.getStyleClass().add((Object)"single-row-pane");
        ((SingleRowGraphics)this.getSkinnable()).getRowPanes().add(this.rowPane);
        return this.rowPane;
    }

    @Override
    protected final List<Row<?, ?, ?>> findLassoSelectedRows() {
        ArrayList list = new ArrayList();
        R row = this.rowPane.getRow();
        if (row != null) {
            list.add((Row<?, ?, ?>)row);
        }
        return list;
    }

    @Override
    protected final List<ActivityRef<?>> findLassoSelectedActivities() {
        Rectangle lasso = this.getLasso();
        Bounds lassoBounds = lasso.getBoundsInLocal();
        RowCanvas<R> canvas = this.rowPane.getCanvas();
        List<ActivityBounds> selections = canvas.getActivityBounds(lasso.getBoundsInLocal().getMinX(), Math.max(0.0, lassoBounds.getMinY()), lasso.getBoundsInLocal().getWidth(), lasso.getBoundsInLocal().getHeight());
        return selections.stream().map(ActivityBounds::getActivityRef).collect(Collectors.toList());
    }

    @Override
    protected final RowPane<R> getRowPaneAt(double y) {
        return this.rowPane;
    }

    @Override
    protected boolean isRowAboveViewport(R row) {
        return false;
    }
}

