/*
 * Decompiled with CFR 0.152.
 */
package impl.com.flexganttfx.skin.graphics;

import com.flexganttfx.core.LoggingDomain;
import com.flexganttfx.model.Activity;
import com.flexganttfx.model.ActivityRef;
import com.flexganttfx.model.ActivityRepository;
import com.flexganttfx.model.Layer;
import com.flexganttfx.model.Layout;
import com.flexganttfx.model.Row;
import com.flexganttfx.model.activity.ChartActivity;
import com.flexganttfx.model.activity.HighLowChartActivity;
import com.flexganttfx.model.exception.IllegalLineIndexException;
import com.flexganttfx.model.exception.RepositoryException;
import com.flexganttfx.model.layout.AgendaLayout;
import com.flexganttfx.model.layout.ChartLayout;
import com.flexganttfx.model.layout.GanttLayout;
import com.flexganttfx.model.timeline.TimelineModel;
import com.flexganttfx.model.util.ActivityHelper;
import com.flexganttfx.view.graphics.ActivityBounds;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.layer.SystemLayer;
import com.flexganttfx.view.graphics.renderer.ActivityRenderer;
import com.flexganttfx.view.timeline.Dateline;
import com.flexganttfx.view.timeline.Timeline;
import com.flexganttfx.view.util.Position;
import impl.com.flexganttfx.skin.graphics.MissingActivityBoundsException;
import impl.com.flexganttfx.skin.graphics.RowCanvasBehaviour;
import impl.com.flexganttfx.skin.util.Placement;
import impl.com.flexganttfx.skin.util.Resolver;
import impl.com.flexganttfx.skin.util.ResolverResult;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.logging.Level;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.WeakListChangeListener;
import javafx.geometry.Rectangle2D;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public final class RowCanvas<R extends Row<?, ?, ?>>
extends Canvas {
    private final GraphicsBase<R> graphics;
    private final List<ActivityBounds> activityBounds = new ArrayList<ActivityBounds>();
    private Map<Integer, List<ActivityEntry>> agendaColumnMap;
    private Map<LocalDate, List<Activity>> dateActivitiesMap;
    private Map<LocalDate, Map<Activity, Placement<Activity>>> datePlacementsMap;
    private Rectangle2D debugRectangle;
    private RowCanvasBehaviour<?> rowCanvasBehaviour;
    private final ChangeListener<ActivityRef<?>> activityRedrawListener = (observable, oldRef, newRef) -> {
        if (oldRef != null && oldRef.getRow() == this.getRow() || newRef != null && newRef.getRow() == this.getRow()) {
            if (observable instanceof ReadOnlyProperty && LoggingDomain.RENDERING.isLoggable(Level.FINE)) {
                LoggingDomain.RENDERING.fine("redraw because of property change, property = " + ((ReadOnlyProperty)observable).getName());
            }
            this.draw();
        }
    };
    private final InvalidationListener editModeListener = it -> {
        if (this.getGraphics().getEditMode().equals((Object)GraphicsBase.EditMode.NONE)) {
            this.rowCanvasBehaviour.stopEdit();
        }
    };
    private final ListChangeListener<ActivityRef<?>> selectedActivitiesListener = change -> {
        while (change.next()) {
            for (ActivityRef ref : change.getAddedSubList()) {
                if (ref.getRow() != this.getRow()) continue;
                this.draw();
                return;
            }
            for (ActivityRef ref : change.getRemoved()) {
                if (ref.getRow() != this.getRow()) continue;
                this.draw();
                return;
            }
        }
    };
    private final ChangeListener<Number> redrawListener = (value, oldSize, newSize) -> this.draw();
    private final ObjectProperty<R> row = new SimpleObjectProperty((Object)this, "row");
    private boolean safeRendering;
    private Rectangle2D lookupBounds;
    private final BooleanProperty snapToPixel = new SimpleBooleanProperty((Object)this, "snapToPixel", true);

    public RowCanvas(GraphicsBase<R> graphics) {
        Objects.requireNonNull(graphics);
        this.graphics = graphics;
        this.getStyleClass().add((Object)"row-canvas");
        this.widthProperty().addListener(this.redrawListener);
        this.heightProperty().addListener(this.redrawListener);
        this.rowCanvasBehaviour = new RowCanvasBehaviour(this);
        this.rowProperty().addListener(evt -> this.draw());
        WeakChangeListener weakActivityRedrawListener = new WeakChangeListener(this.activityRedrawListener);
        graphics.editModeProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.editModeListener));
        graphics.hoverActivityProperty().addListener((ChangeListener)weakActivityRedrawListener);
        graphics.pressedActivityProperty().addListener((ChangeListener)weakActivityRedrawListener);
        graphics.getSelectedActivities().addListener((ListChangeListener)new WeakListChangeListener(this.selectedActivitiesListener));
        InvalidationListener pseudoStateRedrawListener = observable -> this.draw();
        this.hoverProperty().addListener(pseudoStateRedrawListener);
        this.pressedProperty().addListener(pseudoStateRedrawListener);
        this.focusedProperty().addListener(pseudoStateRedrawListener);
    }

    public final GraphicsBase<R> getGraphics() {
        return this.graphics;
    }

    public final ObjectProperty<R> rowProperty() {
        return this.row;
    }

    public final void setRow(R row) {
        this.rowProperty().set(row);
    }

    public final R getRow() {
        return (R)((Row)this.rowProperty().get());
    }

    public final TimelineModel<?> getTimelineModel() {
        return this.graphics.getTimeline().getModel();
    }

    public final boolean isResizable() {
        return true;
    }

    public final double prefHeight(double width) {
        return this.getHeight();
    }

    public final double prefWidth(double height) {
        return this.getWidth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void draw() {
        if (LoggingDomain.RENDERING.isLoggable(Level.FINEST)) {
            LoggingDomain.RENDERING.finest("drawing canvas of row " + this.getRow());
        }
        this.activityBounds.clear();
        double width = this.getWidth();
        double height = this.getHeight();
        if (width <= 0.0 || height <= 0.0) {
            return;
        }
        GraphicsContext gc = this.getGraphicsContext2D();
        gc.clearRect(0.0, 0.0, width, height);
        TimelineModel<?> timelineModel = this.getTimelineModel();
        int extraPixels = this.graphics.getExtraPixels();
        double startLocation = -extraPixels;
        double endLocation = width + (double)extraPixels;
        Instant startTime = timelineModel.calculateTimeForLocation(startLocation);
        Instant endTime = timelineModel.calculateTimeForLocation(endLocation);
        this.safeRendering = this.getGraphics().isSafeRendering();
        try {
            if (this.safeRendering) {
                gc.save();
            }
            for (SystemLayer layer : this.graphics.getBackgroundSystemLayers()) {
                if (!layer.isVisible()) continue;
                if (this.safeRendering) {
                    gc.save();
                }
                this.drawSystemLayer(layer, gc, startTime, endTime);
                if (!this.safeRendering) continue;
                gc.restore();
            }
            this.drawModelLayers();
            for (SystemLayer layer : this.graphics.getForegroundSystemLayers()) {
                if (!layer.isVisible()) continue;
                if (this.safeRendering) {
                    gc.save();
                }
                this.drawSystemLayer(layer, gc, startTime, endTime);
                if (!this.safeRendering) continue;
                gc.restore();
            }
        }
        catch (IllegalLineIndexException | MissingActivityBoundsException ex) {
            ex.printStackTrace();
        }
        finally {
            if (this.safeRendering) {
                gc.restore();
            }
        }
        if (this.lookupBounds != null && this.graphics.isDebugMode()) {
            gc.setStroke((Paint)Color.MAGENTA);
            gc.strokeRect(this.lookupBounds.getMinX(), this.lookupBounds.getMinY(), this.lookupBounds.getWidth(), this.lookupBounds.getHeight());
        }
        if (this.agendaColumnMap != null) {
            this.agendaColumnMap.clear();
        }
    }

    private void drawSystemLayer(SystemLayer<R> layer, GraphicsContext gc, Instant startTime, Instant endTime) {
        double opacity = layer.getOpacity();
        if (opacity > 0.0) {
            gc.setGlobalAlpha(opacity);
            layer.drawLayer(this, startTime, endTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawModelLayers() throws IllegalLineIndexException, MissingActivityBoundsException {
        R row = this.getRow();
        this.dateActivitiesMap = null;
        this.datePlacementsMap = null;
        if (row != null) {
            GraphicsContext gc = this.getGraphicsContext2D();
            for (Layer layer : this.graphics.getLayers()) {
                if (!(layer.getFadeInOutOpacity() > 0.0)) continue;
                try {
                    if (this.safeRendering) {
                        gc.save();
                    }
                    this.drawLayer((Row)row, layer, false);
                }
                finally {
                    if (!this.safeRendering) continue;
                    gc.restore();
                }
            }
            if (this.dateActivitiesMap != null) {
                for (LocalDate date : this.dateActivitiesMap.keySet()) {
                    List<Activity> activities = this.dateActivitiesMap.get(date);
                    ResolverResult<Activity> result = Resolver.resolve(activities);
                    Map<Activity, Placement<Activity>> placements = result.getPlacements();
                    if (this.datePlacementsMap == null) {
                        this.datePlacementsMap = new HashMap<LocalDate, Map<Activity, Placement<Activity>>>();
                    }
                    this.datePlacementsMap.put(date, placements);
                }
                for (Layer layer : this.graphics.getLayers()) {
                    if (!(layer.getFadeInOutOpacity() > 0.0)) continue;
                    try {
                        if (this.safeRendering) {
                            gc.save();
                        }
                        this.drawLayer((Row)row, layer, true);
                    }
                    finally {
                        if (this.safeRendering) {
                            gc.restore();
                        }
                    }
                }
            }
            switch (this.graphics.getEditMode()) {
                case DRAGGING: 
                case DRAGGING_VERTICAL: {
                    break;
                }
            }
        }
    }

    private void drawLayer(Row row, Layer layer, boolean secondPass) throws IllegalLineIndexException, MissingActivityBoundsException {
        List<ActivityBounds> bounds;
        ActivityRef<?> editedActivity;
        ActivityRepository repository;
        Iterator activities;
        Timeline timeline = this.graphics.getTimeline();
        TimelineModel<?> timelineModel = timeline.getModel();
        Instant startTime = timelineModel.getStartTime();
        Instant endTime = timelineModel.calculateTimeForLocation(timeline.getWidth());
        TemporalUnit temporalUnit = timeline.getDateline().getPrimaryTemporalUnit();
        ZoneId zoneId = row.getZoneId();
        if (this.isUsingAgendaLayout(row)) {
            Dateline dateline = timeline.getDateline();
            ZoneId datelineZoneId = dateline.getZoneId();
            ZonedDateTime st = ZonedDateTime.ofInstant(startTime, datelineZoneId);
            ZonedDateTime et = ZonedDateTime.ofInstant(endTime, datelineZoneId);
            st = st.truncatedTo(ChronoUnit.DAYS);
            et = et.truncatedTo(ChronoUnit.DAYS).plusDays(1L).minusNanos(1L);
            startTime = Instant.from(st);
            endTime = Instant.from(et);
        }
        if ((activities = (repository = row.getRepository()).getActivities(layer, startTime, endTime, temporalUnit, zoneId)) == null) {
            throw new RepositoryException(MessageFormat.format("the repository of type {0} returned a NULL iterator for its activities, this is not allowed.", repository.getClass().getName()));
        }
        double rowHeight = this.getHeight();
        Predicate<Activity> activityFilter = this.graphics.getActivityFilter();
        while (activities.hasNext()) {
            ActivityRef<Activity> ref;
            List<ActivityBounds> bounds2;
            int lineIndex;
            Activity activity = (Activity)activities.next();
            if (activityFilter != null && !activityFilter.test(activity) || (lineIndex = row.getLineIndex(activity)) >= 0 && lineIndex >= row.getLineCount() || (bounds2 = this.drawActivity(ref = new ActivityRef<Activity>(row, layer, activity), timelineModel, zoneId, rowHeight, secondPass)) == null || bounds2.isEmpty()) continue;
            this.activityBounds.addAll(bounds2);
            if (!this.graphics.isDebugMode()) continue;
            for (ActivityBounds b2 : bounds2) {
                this.getGraphicsContext2D().setStroke((Paint)Color.MAGENTA);
                this.getGraphicsContext2D().strokeRect(b2.getMinX(), b2.getMinY(), b2.getWidth(), b2.getHeight());
            }
            if (this.debugRectangle == null) continue;
            this.getGraphicsContext2D().setStroke((Paint)Color.CYAN);
            this.getGraphicsContext2D().strokeRect(this.debugRectangle.getMinX(), this.debugRectangle.getMinY(), this.debugRectangle.getWidth(), this.debugRectangle.getHeight());
        }
        if (secondPass && (editedActivity = this.graphics.getEditedActivity()) != null && editedActivity.getRow() == row && (bounds = this.drawActivity(editedActivity, timelineModel, zoneId, rowHeight, secondPass)) != null && !bounds.isEmpty()) {
            this.activityBounds.addAll(bounds);
            if (this.graphics.isDebugMode()) {
                for (ActivityBounds b3 : bounds) {
                    this.getGraphicsContext2D().setStroke((Paint)Color.MAGENTA);
                    this.getGraphicsContext2D().strokeRect(b3.getMinX(), b3.getMinY(), b3.getWidth(), b3.getHeight());
                }
            }
        }
    }

    private boolean isUsingAgendaLayout(Row<?, ?, ?> row) throws IllegalLineIndexException {
        if (row.getLayout() instanceof AgendaLayout) {
            return true;
        }
        int lineCount = row.getLineCount();
        if (lineCount > 0) {
            for (int index = 0; index < lineCount; ++index) {
                Layout layout = row.getLineLayout(index);
                if (!(layout instanceof AgendaLayout)) continue;
                return true;
            }
        }
        return false;
    }

    private List<ActivityBounds> drawActivity(ActivityRef ref, TimelineModel<?> timelineModel, ZoneId zoneId, double rowHeight, boolean secondPass) throws IllegalLineIndexException, MissingActivityBoundsException {
        ArrayList<ActivityBounds> boundsList = new ArrayList<ActivityBounds>();
        Row row = ref.getRow();
        Layout layout = row.getLayout();
        Object activity = ref.getActivity();
        int lineIndex = row.getLineIndex(activity);
        double yOffset = 0.0;
        double availableHeight = rowHeight;
        if (lineIndex >= 0) {
            yOffset = row.getLineLocation(lineIndex);
            availableHeight = row.getLineHeight(lineIndex);
            layout = row.getLineLayout(lineIndex);
        }
        if (secondPass && !(layout instanceof AgendaLayout)) {
            return Collections.emptyList();
        }
        double x1 = timelineModel.calculateLocationForTime(activity.getStartTime());
        double x2 = timelineModel.calculateLocationForTime(activity.getEndTime());
        boolean selected = this.graphics.getSelectedActivities().contains((Object)ref);
        boolean focused = ref.equals(this.graphics.getHoverActivity());
        boolean pressed = ref.equals(this.graphics.getPressedActivity());
        boolean highlighted = false;
        if (!this.graphics.getHighlightedActivities().isEmpty() && this.graphics.isHighlighted()) {
            highlighted = this.graphics.getHighlightedActivities().contains((Object)ref);
        }
        yOffset += layout.getPadding();
        if ((availableHeight -= 2.0 * layout.getPadding()) <= 0.0) {
            return null;
        }
        ActivityRenderer<?> renderer = this.graphics.getActivityRenderer(activity.getClass(), layout.getClass());
        if (renderer == null) {
            throw new IllegalStateException("no renderer found for activity of type " + activity.getClass() + " and layout of type " + layout.getClass());
        }
        if (!renderer.isEnabled()) {
            return Collections.emptyList();
        }
        GraphicsContext gc = this.getGraphicsContext2D();
        double layerOpacity = ref.getLayer().getOpacity();
        double fadeInOutOpacity = ref.getLayer().getFadeInOutOpacity();
        double totalOpacity = layerOpacity * fadeInOutOpacity;
        double alpha = gc.getGlobalAlpha();
        gc.setGlobalAlpha(totalOpacity);
        if (layout instanceof AgendaLayout) {
            AgendaLayout agendaLayout = (AgendaLayout)layout;
            if (this.agendaColumnMap == null) {
                this.agendaColumnMap = new HashMap<Integer, List<ActivityEntry>>();
            }
            ZonedDateTime zonedStartDateTime = ZonedDateTime.ofInstant(activity.getStartTime(), zoneId);
            ZonedDateTime zonedEndDateTime = ZonedDateTime.ofInstant(activity.getEndTime(), zoneId);
            ZonedDateTime startOfDayTime = zonedStartDateTime.with(LocalTime.MIN);
            ZonedDateTime endOfDayTime = zonedEndDateTime.with(LocalTime.MAX);
            long repeats = startOfDayTime.until(endOfDayTime, ChronoUnit.DAYS) + 1L;
            int column = 0;
            while ((long)column < repeats) {
                startOfDayTime = startOfDayTime.with(agendaLayout.getStartTime());
                endOfDayTime = startOfDayTime.with(agendaLayout.getEndTime());
                Position position = repeats == 1L ? Position.ONLY : (column == 0 ? Position.FIRST : ((long)column == repeats - 1L ? Position.LAST : Position.MIDDLE));
                if (ActivityHelper.intersect(zonedStartDateTime.toInstant(), zonedEndDateTime.toInstant(), startOfDayTime.toInstant(), endOfDayTime.toInstant())) {
                    ZonedDateTime truncatedDateTime = zonedStartDateTime.truncatedTo(ChronoUnit.DAYS).plus(column, ChronoUnit.DAYS);
                    x1 = timelineModel.calculateLocationForTime(Instant.from(truncatedDateTime));
                    x2 = timelineModel.calculateLocationForTime(Instant.from(truncatedDateTime.plus(1L, ChronoUnit.DAYS)));
                    AgendaLayout.LayoutStrategy layoutStrategy = agendaLayout.getLayoutStrategy();
                    switch (layoutStrategy) {
                        case OVERLAPPING: {
                            List<ActivityEntry> columnActivities = this.agendaColumnMap.get((int)x1);
                            if (columnActivities == null) {
                                columnActivities = new ArrayList<ActivityEntry>();
                                this.agendaColumnMap.put((int)x1, columnActivities);
                            }
                            int insetLevel = this.computeInsetLevel((Activity)activity, columnActivities);
                            ActivityEntry entry = new ActivityEntry();
                            entry.activity = activity;
                            entry.indentLevel = insetLevel;
                            columnActivities.add(entry);
                            x1 += (double)insetLevel * agendaLayout.getOverlapOffset();
                            break;
                        }
                        case PARALLEL: 
                        case PARALLEL_OVERLAPPING: {
                            if (secondPass) break;
                            if (this.dateActivitiesMap == null) {
                                this.dateActivitiesMap = new HashMap<LocalDate, List<Activity>>();
                            }
                            LocalDate date = startOfDayTime.toLocalDate();
                            List dateActivities = this.dateActivitiesMap.computeIfAbsent(date, it -> new ArrayList());
                            dateActivities.add(activity);
                        }
                    }
                    if (layoutStrategy.equals((Object)AgendaLayout.LayoutStrategy.OVERLAPPING) || secondPass) {
                        double yy1 = yOffset;
                        if (column == 0) {
                            yy1 = yOffset + this.calculateVerticalTimeLocation(zonedStartDateTime.toLocalTime(), agendaLayout, availableHeight);
                        }
                        double yy2 = yOffset + availableHeight;
                        if ((long)column == repeats - 1L) {
                            yy2 = yOffset + this.calculateVerticalTimeLocation(zonedEndDateTime.toLocalTime(), agendaLayout, availableHeight);
                        }
                        double columnWidth = x2 - x1;
                        switch (layoutStrategy) {
                            case PARALLEL: 
                            case PARALLEL_OVERLAPPING: {
                                Placement<Activity> placement;
                                LocalDate date;
                                Map<Activity, Placement<Activity>> dateMap;
                                if (this.datePlacementsMap == null || (dateMap = this.datePlacementsMap.get(date = truncatedDateTime.toLocalDate())) == null || (placement = dateMap.get(activity)) == null) break;
                                x1 += (double)placement.getColumnIndex() * (columnWidth /= (double)placement.getColumnCount());
                                if (!layoutStrategy.equals((Object)AgendaLayout.LayoutStrategy.PARALLEL_OVERLAPPING)) break;
                                double offset = Math.min(0.5, agendaLayout.getOverlapOffset());
                                double extraWidth = columnWidth * offset / 2.0;
                                if (placement.getColumnCount() > 1) {
                                    columnWidth += extraWidth;
                                }
                                if (placement.getColumnIndex() <= 0) break;
                                x1 -= (double)(column + 1) * extraWidth;
                                break;
                            }
                        }
                        ActivityBounds bounds = renderer.draw(ref, position, gc, this.snapPosition(x1), this.snapPosition(yy1), this.snapPosition(columnWidth), Math.max(1.0, this.snapPosition(yy2) - this.snapPosition(yy1) - 1.0), selected, focused, highlighted, pressed);
                        if (bounds == null) {
                            throw new MissingActivityBoundsException(renderer, (Activity)activity, row, lineIndex);
                        }
                        bounds.setPosition(position);
                        bounds.setLayout(layout);
                        boundsList.add(bounds);
                    }
                }
                startOfDayTime = startOfDayTime.plusDays(1L);
                ++column;
            }
        } else if (layout instanceof GanttLayout) {
            ActivityBounds bounds = renderer.draw(ref, Position.ONLY, gc, x1 + 0.25, yOffset + 0.5, x2 - x1, availableHeight - 1.0, selected, focused, highlighted, pressed);
            if (bounds == null) {
                throw new MissingActivityBoundsException(renderer, (Activity)activity, row, lineIndex);
            }
            bounds.setPosition(Position.ONLY);
            bounds.setLayout(layout);
            boundsList.add(bounds);
        } else if (layout instanceof ChartLayout) {
            if (activity instanceof ChartActivity) {
                yOffset += this.calculateChartOffset((ChartActivity)activity, (ChartLayout)layout, availableHeight);
                availableHeight = this.calculateChartActivityHeight((ChartActivity)activity, (ChartLayout)layout, availableHeight);
            } else if (activity instanceof HighLowChartActivity) {
                HighLowChartActivity highLow = (HighLowChartActivity)activity;
                double offsetHigh = this.calculateChartValueOffset(highLow.getHigh(), (ChartLayout)layout, availableHeight);
                double offsetLow = this.calculateChartValueOffset(highLow.getLow(), (ChartLayout)layout, availableHeight);
                yOffset += offsetHigh;
                availableHeight = offsetLow - offsetHigh;
            }
            ActivityBounds bounds = renderer.draw(ref, Position.ONLY, gc, x1 + 0.25, yOffset + 0.5, x2 - x1, availableHeight - 1.0, selected, focused, highlighted, pressed);
            if (bounds == null) {
                throw new MissingActivityBoundsException(renderer, (Activity)activity, row, lineIndex);
            }
            bounds.setPosition(Position.ONLY);
            bounds.setLayout(layout);
            boundsList.add(bounds);
        }
        if (!this.safeRendering) {
            gc.setGlobalAlpha(alpha);
        }
        return boundsList;
    }

    private double calculateChartValueOffset(double value, ChartLayout layout, double availableHeight) {
        double range = layout.getMaxValue() - layout.getMinValue();
        double ppv = availableHeight / range;
        double zeroLineLocation = layout.getMaxValue() * ppv;
        return zeroLineLocation - value * ppv;
    }

    private double calculateChartOffset(ChartActivity chartActivity, ChartLayout layout, double availableHeight) {
        double range = layout.getMaxValue() - layout.getMinValue();
        double ppv = availableHeight / range;
        double zeroLineLocation = layout.getMaxValue() * ppv;
        if (chartActivity.getChartValue() < 0.0) {
            return zeroLineLocation;
        }
        return zeroLineLocation - chartActivity.getChartValue() * ppv;
    }

    private double calculateChartActivityHeight(ChartActivity chartActivity, ChartLayout layout, double availableHeight) {
        double range = layout.getMaxValue() - layout.getMinValue();
        double ppv = availableHeight / range;
        return Math.abs(chartActivity.getChartValue()) * ppv;
    }

    private int computeInsetLevel(Activity activity, List<ActivityEntry> columnActivities) {
        int level = 0;
        for (ActivityEntry entry : columnActivities) {
            if (!ActivityHelper.intersect(entry.activity, activity)) continue;
            level = entry.indentLevel + 1;
        }
        return level;
    }

    private double calculateVerticalTimeLocation(LocalTime time, AgendaLayout layout, double availableHeight) {
        LocalTime st = layout.getStartTime();
        LocalTime et = layout.getEndTime();
        long millis = st.until(et, ChronoUnit.MILLIS);
        double mpp = (double)millis / availableHeight;
        return Math.min(availableHeight, Math.max(0.0, (double)(time.get(ChronoField.MILLI_OF_DAY) - st.get(ChronoField.MILLI_OF_DAY)) / mpp));
    }

    public final List<ActivityBounds> getAllActivityBounds() {
        return this.activityBounds;
    }

    public final List<ActivityBounds> getAllActivityBounds(double x, double y) {
        ArrayList<ActivityBounds> result = new ArrayList<ActivityBounds>();
        for (ActivityBounds bounds : this.activityBounds) {
            if (!bounds.contains(x, y)) continue;
            result.add(bounds);
        }
        return result;
    }

    public final ActivityBounds getActivityBounds(double x, double y) {
        List<ActivityBounds> allBounds = this.getAllActivityBounds(x, y);
        int s = allBounds.size();
        if (s > 0) {
            return allBounds.get(s - 1);
        }
        return null;
    }

    public final ActivityBounds getActivityBounds(ActivityRef<?> activityRef) {
        if (activityRef.getRow().equals(this.getRow())) {
            for (ActivityBounds bounds : this.activityBounds) {
                if (!bounds.getActivityRef().equals(activityRef)) continue;
                return bounds;
            }
            try {
                List<ActivityBounds> firstPassBounds = this.drawActivity(activityRef, this.getTimelineModel(), activityRef.getRow().getZoneId(), activityRef.getRow().getHeight(), false);
                List<ActivityBounds> secondPassBounds = this.drawActivity(activityRef, this.getTimelineModel(), activityRef.getRow().getZoneId(), activityRef.getRow().getHeight(), true);
                if (secondPassBounds != null && !secondPassBounds.isEmpty()) {
                    return secondPassBounds.get(0);
                }
                if (firstPassBounds != null && !firstPassBounds.isEmpty()) {
                    return firstPassBounds.get(0);
                }
            }
            catch (IllegalLineIndexException | MissingActivityBoundsException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public final List<ActivityBounds> getActivityBounds(double x, double y, double w, double h) {
        this.lookupBounds = this.graphics.isDebugMode() ? new Rectangle2D(x, y, w, h) : null;
        GraphicsBase.LassoSelectionBehaviour behaviour = this.graphics.getLassoSelectionBehaviour();
        Rectangle2D selectionRectangle = new Rectangle2D(x, y, w, h);
        Timeline timeline = this.graphics.getTimeline();
        TimelineModel<?> timelineModel = timeline.getModel();
        Instant st = timelineModel.calculateTimeForLocation(x);
        Instant et = timelineModel.calculateTimeForLocation(x + w);
        ArrayList<ActivityBounds> result = new ArrayList<ActivityBounds>();
        for (ActivityBounds bounds : this.activityBounds) {
            switch (behaviour) {
                case INTERSECTION: {
                    if (!selectionRectangle.intersects((Rectangle2D)bounds)) break;
                    result.add(bounds);
                    break;
                }
                case BOUNDS_CONTAINMENT: {
                    if (!selectionRectangle.contains((Rectangle2D)bounds)) break;
                    result.add(bounds);
                    break;
                }
                case TIME_INTERVAL_CONTAINMENT: {
                    Activity activity = bounds.getActivity();
                    Instant activityStart = activity.getStartTime();
                    Instant activityEnd = activity.getEndTime();
                    if (!st.equals(activityStart) && !st.isBefore(activityStart) || !et.equals(activityEnd) && !et.isAfter(activityEnd)) break;
                    result.add(bounds);
                }
            }
        }
        return result;
    }

    public final Layout getLayoutAt(double y) {
        Layout layout = null;
        R row = this.getRow();
        if (row != null) {
            int lineCount = ((Row)row).getLineCount();
            if (lineCount <= 0) {
                layout = ((Row)row).getLayout();
            } else {
                for (int lineIndex = 0; lineIndex < lineCount; ++lineIndex) {
                    double lineLocation = ((Row)row).getLineLocation(lineIndex);
                    double lineHeight = ((Row)row).getLineHeight(lineIndex);
                    if (!(y >= lineLocation) || !(y <= lineLocation + lineHeight)) continue;
                    layout = ((Row)row).getLineLayout(lineIndex);
                    break;
                }
            }
        }
        return layout;
    }

    public final Rectangle2D getLayoutBoundsAt(double y) {
        Rectangle2D bounds = null;
        R row = this.getRow();
        if (row != null) {
            int lineCount = ((Row)row).getLineCount();
            if (lineCount <= 0) {
                bounds = new Rectangle2D(0.0, 0.0, this.getWidth(), this.getHeight());
            } else {
                for (int lineIndex = 0; lineIndex < lineCount; ++lineIndex) {
                    double lineLocation = ((Row)row).getLineLocation(lineIndex);
                    double lineHeight = ((Row)row).getLineHeight(lineIndex);
                    if (!(y >= lineLocation) || !(y <= lineLocation + lineHeight)) continue;
                    bounds = new Rectangle2D(0.0, lineLocation, this.getWidth(), lineHeight);
                    break;
                }
            }
        }
        if (this.graphics.isDebugMode()) {
            this.debugRectangle = bounds;
            this.draw();
        }
        return bounds;
    }

    public final void setSnapToPixel(boolean snap) {
        this.snapToPixel.set(snap);
    }

    public final boolean isSnapToPixel() {
        return this.snapToPixel.get();
    }

    protected double snapPosition(double value) {
        return this.snapPosition(value, this.isSnapToPixel());
    }

    protected double snapSpace(double value) {
        return this.snapSpace(value, this.isSnapToPixel());
    }

    protected double snapSize(double value) {
        return this.snapSize(value, this.isSnapToPixel());
    }

    private double snapSpace(double value, boolean snapToPixel) {
        return snapToPixel ? (double)Math.round(value) : value;
    }

    private double snapSize(double value, boolean snapToPixel) {
        return snapToPixel ? Math.ceil(value) : value;
    }

    private double snapPosition(double value, boolean snapToPixel) {
        return snapToPixel ? (double)Math.round(value) + 0.5 : value;
    }

    class ActivityEntry {
        int indentLevel;
        Activity activity;

        ActivityEntry() {
        }
    }
}

