/*
 * Decompiled with CFR 0.152.
 */
package impl.com.flexganttfx.skin.graphics;

import com.flexganttfx.model.ActivityLink;
import com.flexganttfx.model.ActivityRef;
import com.flexganttfx.model.Layer;
import com.flexganttfx.model.Row;
import com.flexganttfx.model.timeline.TimelineModel;
import com.flexganttfx.view.graphics.ActivityEvent;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.timeline.Timeline;
import impl.com.flexganttfx.skin.graphics.GraphicsBaseSkin;
import impl.com.flexganttfx.skin.graphics.PathBuilder;
import java.time.Instant;
import java.util.function.Predicate;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.geometry.Rectangle2D;
import javafx.scene.layout.Region;
import javafx.scene.shape.Path;

public class LinksPane<R extends Row<?, ?, ?>>
extends Region {
    private GraphicsBase<R> graphics;
    private final ListChangeListener<Row<?, ?, ?>> rowListChangedListener = c2 -> this.graphics.redraw();
    private final WeakListChangeListener<Row<?, ?, ?>> weakRowListChangedListener = new WeakListChangeListener(this.rowListChangedListener);
    private final InvalidationListener redrawListener = observable -> this.requestLayout();
    private final WeakInvalidationListener weakRedrawListener = new WeakInvalidationListener(this.redrawListener);
    private final PathBuilder pathBuilder = new PathBuilder();

    public LinksPane(GraphicsBase<R> graphics) {
        this.graphics = graphics;
        this.setMinSize(0.0, 0.0);
        this.visibleProperty().bind((ObservableValue)Bindings.isEmpty(graphics.getRowsEditing()));
        this.setMouseTransparent(true);
        Timeline timeline = graphics.getTimeline();
        TimelineModel<?> timelineModel = timeline.getModel();
        timelineModel.startTimeProperty().addListener((InvalidationListener)new WeakInvalidationListener((InvalidationListener)this.weakRedrawListener));
        timeline.getModel().millisPerPixelProperty().addListener((InvalidationListener)this.weakRedrawListener);
        timeline.modelProperty().addListener((observable, oldModel, newModel) -> {
            if (oldModel != null) {
                oldModel.startTimeProperty().removeListener((InvalidationListener)this.weakRedrawListener);
                oldModel.millisPerPixelProperty().removeListener((InvalidationListener)this.weakRedrawListener);
            }
            if (newModel != null) {
                newModel.startTimeProperty().addListener((InvalidationListener)this.weakRedrawListener);
                newModel.millisPerPixelProperty().removeListener((InvalidationListener)this.weakRedrawListener);
            }
        });
        graphics.addEventFilter(ActivityEvent.ACTIVITY_CHANGE, event -> this.requestLayout());
        graphics.getRows().addListener(this.weakRowListChangedListener);
        graphics.getLinks().addListener(evt -> this.requestLayout());
    }

    protected void layoutChildren() {
        this.getChildren().clear();
        this.graphics.getLinks().forEach(this::layoutLink);
    }

    private void layoutLink(ActivityLink<?> link) {
        ActivityRef<?> targetRef;
        ActivityRef<?> sourceRef = link.getSourceActivityRef();
        if (!this.isShowing(sourceRef, targetRef = link.getTargetActivityRef())) {
            return;
        }
        GraphicsBaseSkin skin = (GraphicsBaseSkin)this.graphics.getSkin();
        if (skin != null) {
            Rectangle2D sourceBounds = skin.getActivityBounds(sourceRef);
            Rectangle2D targetBounds = skin.getActivityBounds(targetRef);
            if (sourceBounds != null && targetBounds != null) {
                Layer sourceLayer = sourceRef.getLayer();
                PathBuilder.PathBuilderResult result = null;
                switch (link.getType()) {
                    case END_TO_END: {
                        result = this.pathBuilder.buildPathEndToEnd(sourceBounds, targetBounds);
                        break;
                    }
                    case END_TO_START: {
                        result = this.pathBuilder.buildPathEndToStart(sourceBounds, targetBounds);
                        break;
                    }
                    case START_TO_END: {
                        result = this.pathBuilder.buildPathStartToEnd(sourceBounds, targetBounds);
                        break;
                    }
                    case START_TO_START: {
                        result = this.pathBuilder.buildPathStartToStart(sourceBounds, targetBounds);
                        break;
                    }
                }
                if (result != null) {
                    Path path = result.getPath();
                    path.opacityProperty().bind((ObservableValue)sourceLayer.opacityProperty());
                    path.setManaged(false);
                    path.setMouseTransparent(true);
                    path.getStyleClass().add((Object)"link");
                    this.getChildren().add((Object)path);
                    Region startRegion = new Region();
                    startRegion.opacityProperty().bind((ObservableValue)sourceLayer.opacityProperty());
                    startRegion.setManaged(false);
                    startRegion.setMouseTransparent(true);
                    startRegion.getStyleClass().add((Object)"link-start-handle");
                    this.getChildren().add((Object)startRegion);
                    startRegion.applyCss();
                    double startRegionWidth = startRegion.getPrefWidth();
                    startRegion.resizeRelocate(result.getStart().getX(), result.getStart().getY(), startRegionWidth, startRegion.getPrefHeight());
                    Region endRegion = new Region();
                    endRegion.opacityProperty().bind((ObservableValue)sourceLayer.opacityProperty());
                    endRegion.setManaged(false);
                    endRegion.setMouseTransparent(true);
                    endRegion.getStyleClass().add((Object)"link-end-handle");
                    this.getChildren().add((Object)endRegion);
                    endRegion.applyCss();
                    double endRegionWidth = endRegion.getPrefWidth();
                    endRegion.resizeRelocate(result.getEnd().getX(), result.getEnd().getY(), endRegionWidth, endRegion.getPrefHeight());
                    switch (link.getType()) {
                        case START_TO_END: 
                        case START_TO_START: {
                            startRegion.setRotate(180.0);
                            startRegion.getStyleClass().add((Object)"link-start-handle-rotated");
                            break;
                        }
                    }
                    switch (link.getType()) {
                        case END_TO_END: 
                        case START_TO_END: {
                            endRegion.setRotate(180.0);
                            endRegion.getStyleClass().add((Object)"link-end-handle-rotated");
                            break;
                        }
                    }
                    if (result.getStart().getY() == result.getEnd().getY() && result.getEnd().getX() - result.getStart().getX() < startRegionWidth + endRegionWidth) {
                        startRegion.setVisible(false);
                    }
                }
            }
        }
    }

    private boolean isShowing(ActivityRef<?> sourceRef, ActivityRef<?> targetRef) {
        if (!sourceRef.isPathExpanded() || !targetRef.isPathExpanded()) {
            return false;
        }
        if (!sourceRef.getLayer().isVisible() && !targetRef.getLayer().isVisible()) {
            return false;
        }
        ObservableList<R> rows = this.graphics.getRows();
        int firstIndex = 0;
        int lastIndex = rows.size() - 1;
        R firstRow = this.graphics.getRowAt(5.0);
        R lastRow = this.graphics.getRowAt(this.getHeight() - 5.0);
        if (firstRow != null) {
            firstIndex = rows.indexOf(firstRow);
        }
        if (lastRow != null) {
            lastIndex = rows.indexOf(lastRow);
        }
        Row<?, ?, ?> sourceRow = sourceRef.getRow();
        Row<?, ?, ?> targetRow = targetRef.getRow();
        int sourceIndex = rows.indexOf(sourceRow);
        int targetIndex = rows.indexOf(targetRow);
        if (sourceIndex < firstIndex && targetIndex < firstIndex) {
            return false;
        }
        if (sourceIndex > lastIndex && targetIndex > lastIndex) {
            return false;
        }
        Predicate rowFilter = this.graphics.getRowFilter();
        if (rowFilter != null) {
            boolean targetRowShowing;
            boolean sourceRowShowing = rowFilter.test(sourceRow) || sourceRow.hasChildren(rowFilter);
            boolean bl = targetRowShowing = rowFilter.test(targetRow) || targetRow.hasChildren(rowFilter);
            if (!sourceRowShowing || !targetRowShowing) {
                return false;
            }
        }
        Timeline timeline = this.graphics.getTimeline();
        Instant visibleStart = timeline.getVisibleStartTime();
        Instant visibleEnd = timeline.getVisibleEndTime();
        Object sourceActivity = sourceRef.getActivity();
        Object targetActivity = targetRef.getActivity();
        if (sourceActivity.getEndTime().isBefore(visibleStart) && targetActivity.getEndTime().isBefore(visibleStart)) {
            return false;
        }
        return !sourceActivity.getStartTime().isAfter(visibleEnd) || !targetActivity.getStartTime().isAfter(visibleEnd);
    }
}

