/*
 * Decompiled with CFR 0.152.
 */
package impl.com.flexganttfx.skin.graphics;

import com.flexganttfx.model.Row;
import com.flexganttfx.view.graphics.GraphicsBase;
import impl.com.flexganttfx.skin.graphics.RowPane;
import java.util.Objects;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.value.WritableValue;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Orientation;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.util.Duration;

public class FlipPane<R extends Row<?, ?, ?>>
extends StackPane {
    private final StackPane front;
    private final StackPane back;
    private final Rotate rotate = new Rotate(0.0, Rotate.Y_AXIS);
    private final Rotate backRotate;
    private final Timeline flipToFront;
    private final Timeline flipToBack;
    private double flipTime;
    private final Orientation flipDirection;
    private RowPane<R> rowCell;
    private R row;
    private double previousRowHeight;
    private Node controlsNode;

    FlipPane(RowPane<R> rowCell) {
        this(Orientation.VERTICAL);
        Objects.requireNonNull(rowCell);
        this.rowCell = rowCell;
        this.getStyleClass().add((Object)"flip-pane");
    }

    private FlipPane(Orientation FLIP_DIRECTION) {
        this.getTransforms().add((Object)this.rotate);
        this.backRotate = new Rotate(180.0, Orientation.HORIZONTAL == FLIP_DIRECTION ? Rotate.Y_AXIS : Rotate.X_AXIS);
        this.front = new StackPane();
        this.back = new StackPane();
        this.back.setVisible(false);
        this.getChildren().setAll((Object[])new Node[]{this.back, this.front});
        this.flipToFront = new Timeline();
        this.flipToBack = new Timeline();
        this.flipTime = 666.0;
        this.flipDirection = FLIP_DIRECTION;
        this.registerListeners();
        this.setMinSize(0.0, 0.0);
        this.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
    }

    public final void setRow(R row) {
        if (this.row != row) {
            this.row = row;
            this.getBack().getChildren().clear();
            if (row != null) {
                GraphicsBase<R> graphics = this.rowCell.getGraphics();
                GraphicsBase.RowEditorParameter<R> param = new GraphicsBase.RowEditorParameter<R>(graphics, row);
                Node node = (Node)graphics.getRowEditorFactory().call(param);
                if (node != null) {
                    this.getBack().getChildren().add((Object)node);
                }
            }
        }
        this.row = row;
    }

    private void registerListeners() {
        InvalidationListener adjustRotationListener = it -> this.adjustRotationAxis();
        this.front.widthProperty().addListener(adjustRotationListener);
        this.front.heightProperty().addListener(adjustRotationListener);
        this.back.widthProperty().addListener(adjustRotationListener);
        this.back.heightProperty().addListener(adjustRotationListener);
        this.rotate.angleProperty().addListener((ov, o, n) -> {
            if (Double.compare(o.doubleValue(), 90.0) < 0 && Double.compare(n.doubleValue(), 90.0) >= 0) {
                this.front.setVisible(false);
                this.back.setVisible(true);
            }
            if (Double.compare(o.doubleValue(), 90.0) > 0 && Double.compare(n.doubleValue(), 90.0) <= 0) {
                this.back.setVisible(false);
                this.front.setVisible(true);
            }
        });
    }

    private void hideControlsNode() {
        this.controlsNode = this.rowCell.getControlsNode();
        if (this.controlsNode != null) {
            this.controlsNode.setVisible(false);
        }
    }

    private void showControlsNode() {
        if (this.controlsNode != null) {
            this.controlsNode.setVisible(true);
        }
    }

    public final StackPane getFront() {
        return this.front;
    }

    public final StackPane getBack() {
        return this.back;
    }

    public final void flipToFrontImmediately() {
        this.showControlsNode();
        ((Row)this.row).setHeight(this.previousRowHeight);
        this.rotate.setAngle(0.0);
        this.back.setVisible(false);
        this.front.setVisible(true);
    }

    public final void flipToBackImmediately() {
        this.hideControlsNode();
        this.previousRowHeight = ((Row)this.row).getHeight();
        ((Row)this.row).setHeight(this.calculatePrefHeightOfBack());
        this.rotate.setAngle(180.0);
        this.back.setVisible(true);
        this.front.setVisible(false);
    }

    public final void flipToFront() {
        if (Double.compare(this.rotate.getAngle(), 0.0) == 0) {
            return;
        }
        KeyValue kvRowHeight = new KeyValue((WritableValue)((Row)this.row).heightProperty(), (Object)this.previousRowHeight);
        KeyValue kvRotateStart = new KeyValue((WritableValue)this.rotate.angleProperty(), (Object)180, Interpolator.EASE_IN);
        KeyValue kvRotateStop = new KeyValue((WritableValue)this.rotate.angleProperty(), (Object)0, Interpolator.EASE_OUT);
        KeyValue kvScaleXStart = new KeyValue((WritableValue)this.scaleXProperty(), (Object)1);
        KeyValue kvScaleYStart = new KeyValue((WritableValue)this.scaleYProperty(), (Object)1);
        KeyValue kvScaleXMiddle = new KeyValue((WritableValue)this.scaleXProperty(), (Object)0.8, Interpolator.EASE_BOTH);
        KeyValue kvScaleYMiddle = new KeyValue((WritableValue)this.scaleYProperty(), (Object)0.8, Interpolator.EASE_BOTH);
        KeyValue kvScaleXStop = new KeyValue((WritableValue)this.scaleXProperty(), (Object)1);
        KeyValue kvScaleYStop = new KeyValue((WritableValue)this.scaleYProperty(), (Object)1);
        KeyFrame kfStart = new KeyFrame(Duration.ZERO, new KeyValue[]{kvRotateStart, kvScaleXStart, kvScaleYStart});
        KeyFrame kfMiddle = new KeyFrame(Duration.millis((double)(this.flipTime / 4.0)), new KeyValue[]{kvScaleXMiddle, kvScaleYMiddle});
        KeyFrame kfStop = new KeyFrame(Duration.millis((double)this.flipTime), new KeyValue[]{kvRotateStop, kvScaleXStop, kvScaleYStop, kvRowHeight});
        this.flipToFront.getKeyFrames().setAll((Object[])new KeyFrame[]{kfStart, kfMiddle, kfStop});
        this.front.setCache(true);
        this.front.setCacheHint(CacheHint.SCALE_AND_ROTATE);
        this.back.setCache(true);
        this.back.setCacheHint(CacheHint.SCALE_AND_ROTATE);
        this.flipToFront.setOnFinished(event -> {
            this.front.setCache(false);
            this.back.setCache(false);
            this.fireEvent(new FlipEvent((Object)this, (EventTarget)this, FlipEvent.FLIP_TO_FRONT_FINISHED));
            this.getScene().setCamera(null);
            this.showControlsNode();
        });
        this.flipToFront.play();
    }

    public final void flipToBack() {
        this.hideControlsNode();
        if (Double.compare(this.rotate.getAngle(), 180.0) == 0) {
            return;
        }
        this.previousRowHeight = ((Row)this.row).getHeight();
        KeyValue kvRowHeight = new KeyValue((WritableValue)((Row)this.row).heightProperty(), (Object)this.calculatePrefHeightOfBack());
        KeyValue kvRotateStart = new KeyValue((WritableValue)this.rotate.angleProperty(), (Object)0, Interpolator.EASE_IN);
        KeyValue kvRotateStop = new KeyValue((WritableValue)this.rotate.angleProperty(), (Object)180, Interpolator.EASE_OUT);
        KeyValue kvScaleXStart = new KeyValue((WritableValue)this.scaleXProperty(), (Object)1);
        KeyValue kvScaleYStart = new KeyValue((WritableValue)this.scaleYProperty(), (Object)1);
        KeyValue kvScaleXMiddle = new KeyValue((WritableValue)this.scaleXProperty(), (Object)0.8, Interpolator.EASE_BOTH);
        KeyValue kvScaleYMiddle = new KeyValue((WritableValue)this.scaleYProperty(), (Object)0.8, Interpolator.EASE_BOTH);
        KeyValue kvScaleXStop = new KeyValue((WritableValue)this.scaleXProperty(), (Object)1);
        KeyValue kvScaleYStop = new KeyValue((WritableValue)this.scaleYProperty(), (Object)1);
        KeyFrame kfStart = new KeyFrame(Duration.ZERO, new KeyValue[]{kvRotateStart, kvScaleXStart, kvScaleYStart});
        KeyFrame kfMiddle = new KeyFrame(Duration.millis((double)(this.flipTime / 4.0)), new KeyValue[]{kvScaleXMiddle, kvScaleYMiddle});
        KeyFrame kfStop = new KeyFrame(Duration.millis((double)this.flipTime), new KeyValue[]{kvRotateStop, kvScaleXStop, kvScaleYStop, kvRowHeight});
        this.flipToBack.getKeyFrames().setAll((Object[])new KeyFrame[]{kfStart, kfMiddle, kfStop});
        this.front.setCache(true);
        this.front.setCacheHint(CacheHint.SCALE_AND_ROTATE);
        this.back.setCache(true);
        this.back.setCacheHint(CacheHint.SCALE_AND_ROTATE);
        this.flipToBack.setOnFinished(event -> {
            this.front.setCache(false);
            this.back.setCache(false);
            this.fireEvent(new FlipEvent((Object)this, (EventTarget)this, FlipEvent.FLIP_TO_BACK_FINISHED));
            this.getScene().setCamera(null);
        });
        this.flipToBack.play();
    }

    private double calculatePrefHeightOfBack() {
        return this.getBack().prefHeight(this.rowCell.getWidth());
    }

    public final boolean isFrontVisible() {
        return this.front.isVisible();
    }

    public final boolean isBackVisible() {
        return this.back.isVisible();
    }

    public final void setFlipTime(double FLIP_TIME) {
        this.flipTime = this.clamp(100.0, 2000.0, FLIP_TIME);
    }

    private void adjustRotationAxis() {
        if (this.front.getWidth() < 0.0 || this.back.getWidth() < 0.0 || this.front.getHeight() < 0.0 || this.back.getHeight() < 0.0) {
            return;
        }
        double width = this.front.getWidth() > this.back.getWidth() ? this.front.getWidth() : this.back.getWidth();
        double height = this.front.getHeight() > this.back.getHeight() ? this.front.getHeight() : this.back.getHeight();
        this.setPrefSize(width, height);
        if (Orientation.HORIZONTAL == this.flipDirection) {
            this.backRotate.setAngle(0.0);
            this.backRotate.setAxis(Rotate.Y_AXIS);
            this.backRotate.setPivotX(0.5 * width);
            this.backRotate.setAngle(180.0);
            this.back.getTransforms().setAll((Object[])new Transform[]{this.backRotate});
            this.rotate.setAxis(Rotate.Y_AXIS);
            this.rotate.setPivotX(0.5 * width);
        } else {
            this.backRotate.setAngle(0.0);
            this.backRotate.setAxis(Rotate.X_AXIS);
            this.backRotate.setPivotY(0.5 * height);
            this.backRotate.setAngle(180.0);
            this.back.getTransforms().setAll((Object[])new Transform[]{this.backRotate});
            this.rotate.setAxis(Rotate.X_AXIS);
            this.rotate.setPivotY(0.5 * height);
        }
    }

    private double clamp(double MIN, double MAX, double VALUE) {
        if (VALUE < MIN) {
            return MIN;
        }
        if (VALUE > MAX) {
            return MAX;
        }
        return VALUE;
    }

    public static class FlipEvent
    extends Event {
        private static final long serialVersionUID = 2323146240921802205L;
        public static final EventType<FlipEvent> FLIP_TO_FRONT_FINISHED = new EventType(ANY, "flipToFrontFinished");
        public static final EventType<FlipEvent> FLIP_TO_BACK_FINISHED = new EventType(ANY, "flipToBackFinished");

        public FlipEvent(Object SOURCE, EventTarget TARGET, EventType<FlipEvent> EVENT_TYPE) {
            super(SOURCE, TARGET, EVENT_TYPE);
        }
    }
}

