/*
 * Decompiled with CFR 0.152.
 */
package impl.com.flexganttfx.skin.container;

import com.flexganttfx.view.GanttChart;
import com.flexganttfx.view.GanttChartBase;
import com.flexganttfx.view.container.ContainerBase;
import com.flexganttfx.view.timeline.Timeline;
import com.flexganttfx.view.util.Position;
import impl.com.flexganttfx.skin.container.ContainerSkinBase;
import impl.com.flexganttfx.skin.util.Binder;
import javafx.collections.ObservableList;

public abstract class MultiGanttChartContainerSkinBase<T extends ContainerBase>
extends ContainerSkinBase<T> {
    public MultiGanttChartContainerSkinBase(T container) {
        super(container);
        this.updatePositions();
        ((ContainerBase)this.getSkinnable()).getGanttCharts().addListener(observable -> this.updatePositions());
    }

    private void updatePositions() {
        ObservableList ganttCharts = ((ContainerBase)this.getSkinnable()).getGanttCharts();
        int size = ganttCharts.size();
        if (size == 0) {
            return;
        }
        if (size == 1) {
            ((GanttChartBase)((Object)ganttCharts.get(0))).setPosition(Position.ONLY);
            return;
        }
        GanttChartBase primaryGantt = (GanttChartBase)((Object)ganttCharts.get(0));
        Timeline masterTimeline = primaryGantt.getTimeline();
        for (int i = 0; i < size; ++i) {
            GanttChartBase ganttChart = (GanttChartBase)((Object)ganttCharts.get(i));
            ganttChart.setMasterTimeline(masterTimeline);
            if (ganttChart instanceof GanttChart) {
                ((GanttChart)ganttChart).getTreeTable().getStyleClass().remove((Object)"gantt-tree-table-view-first");
                ((GanttChart)ganttChart).getTreeTable().getStyleClass().remove((Object)"gantt-tree-table-view-middle");
                ((GanttChart)ganttChart).getTreeTable().getStyleClass().remove((Object)"gantt-tree-table-view-last");
            }
            ganttChart.getTimeline().getStyleClass().remove((Object)"timeline-first");
            ganttChart.getTimeline().getStyleClass().remove((Object)"timeline-middle");
            ganttChart.getTimeline().getStyleClass().remove((Object)"timeline-last");
            if (i == 0) {
                ganttChart.setPosition(Position.FIRST);
                if (ganttChart instanceof GanttChart) {
                    ((GanttChart)ganttChart).getTreeTable().getStyleClass().add((Object)"gantt-tree-table-view-first");
                }
                ganttChart.getTimeline().getStyleClass().add((Object)"timeline-first");
                continue;
            }
            if (i == size - 1) {
                ganttChart.setPosition(Position.LAST);
                Binder.bind(primaryGantt, ganttChart, ((ContainerBase)this.getSkinnable()).isAutoBinding());
                if (ganttChart instanceof GanttChart) {
                    ((GanttChart)ganttChart).getTreeTable().getStyleClass().add((Object)"gantt-tree-table-view-last");
                }
                ganttChart.getTimeline().getStyleClass().add((Object)"timeline-last");
                continue;
            }
            ganttChart.setPosition(Position.MIDDLE);
            Binder.bind(primaryGantt, ganttChart, ((ContainerBase)this.getSkinnable()).isAutoBinding());
            if (ganttChart instanceof GanttChart) {
                ((GanttChart)ganttChart).getTreeTable().getStyleClass().add((Object)"gantt-tree-table-view-middle");
            }
            ganttChart.getTimeline().getStyleClass().add((Object)"timeline-middle");
        }
    }
}

