/*
 * Decompiled with CFR 0.152.
 */
package impl.com.flexganttfx.extras.skin;

import com.flexganttfx.extras.VirtualGridControl;
import com.flexganttfx.model.dateline.VirtualGrid;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.VBox;

public class VirtualGridControlSkin
extends SkinBase<VirtualGridControl> {
    private VBox vbox = new VBox();

    public VirtualGridControlSkin(VirtualGridControl control) {
        super((Control)control);
        this.vbox.setFillWidth(true);
        this.getChildren().add((Object)this.vbox);
        control.showNoGridOptionProperty().addListener(it -> this.updatePanel());
        control.getGrids().addListener(evt -> this.updatePanel());
        this.updatePanel();
    }

    private void updatePanel() {
        this.vbox.getChildren().clear();
        ToggleGroup toggleGroup = new ToggleGroup();
        if (((VirtualGridControl)this.getSkinnable()).isShowNoGridOption()) {
            ToggleButton noGrid = this.createButton(((VirtualGridControl)this.getSkinnable()).getNoGridText());
            noGrid.setOnAction(evt -> ((VirtualGridControl)this.getSkinnable()).setValue(null));
            this.vbox.getChildren().add((Object)noGrid);
            toggleGroup.getToggles().add((Object)noGrid);
        }
        for (VirtualGrid grid : ((VirtualGridControl)this.getSkinnable()).getGrids()) {
            ToggleButton button = this.createButton(grid.getName());
            button.setFocusTraversable(false);
            if (((VirtualGridControl)this.getSkinnable()).getValue() == grid) {
                button.setSelected(true);
            }
            button.setOnAction(evt -> ((VirtualGridControl)this.getSkinnable()).setValue(grid));
            toggleGroup.getToggles().add((Object)button);
            this.vbox.getChildren().add((Object)button);
        }
    }

    private ToggleButton createButton(String name) {
        ToggleButton button = new ToggleButton(name);
        button.getStyleClass().add((Object)"grid-button");
        button.setMaxWidth(Double.MAX_VALUE);
        return button;
    }
}

