/*
 * Decompiled with CFR 0.152.
 */
package impl.com.flexganttfx.extras.skin;

import com.flexganttfx.extras.LayersView;
import com.flexganttfx.extras.util.Messages;
import com.flexganttfx.model.Layer;
import com.flexganttfx.model.Row;
import com.flexganttfx.view.graphics.GraphicsBase;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Slider;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class LayersViewSkin<R extends Row<?, ?, ?>>
extends SkinBase<LayersView<R>> {
    private GridPane gridPane;
    private final InvalidationListener rebuildListener = observable -> this.buildControls();
    private final WeakInvalidationListener weakRebuildListener = new WeakInvalidationListener(this.rebuildListener);

    public LayersViewSkin(LayersView<R> view) {
        super(view);
        this.gridPane = new GridPane();
        this.gridPane.setAlignment(Pos.TOP_CENTER);
        this.gridPane.getStyleClass().add((Object)"layer-controls");
        this.gridPane.setHgap(10.0);
        this.gridPane.setVgap(10.0);
        this.buildControls();
        view.graphicsProperty().addListener(new ChangeListener<GraphicsBase<R>>(){

            public void changed(ObservableValue<? extends GraphicsBase<R>> observable, GraphicsBase<R> oldGraphics, GraphicsBase<R> newGraphics) {
                if (oldGraphics != null) {
                    oldGraphics.getLayers().removeListener((InvalidationListener)LayersViewSkin.this.weakRebuildListener);
                }
                if (newGraphics != null) {
                    newGraphics.getLayers().addListener((InvalidationListener)LayersViewSkin.this.weakRebuildListener);
                }
                LayersViewSkin.this.buildControls();
            }
        });
        GraphicsBase<R> graphics = view.getGraphics();
        if (graphics != null) {
            graphics.getLayers().addListener((InvalidationListener)this.weakRebuildListener);
        }
        this.getChildren().add((Object)this.gridPane);
    }

    private void buildControls() {
        this.gridPane.getChildren().clear();
        GraphicsBase graphics = ((LayersView)this.getSkinnable()).getGraphics();
        if (graphics != null) {
            ObservableList<Layer> modelLayers = graphics.getLayers();
            int row = modelLayers.size();
            for (int i = 0; i < modelLayers.size(); ++i) {
                Layer layer = (Layer)modelLayers.get(i);
                CheckBox checkBox = new CheckBox();
                Slider slider = new Slider();
                checkBox = new CheckBox();
                slider = new Slider(0.0, 1.0, 1.0);
                GridPane.setHgrow((Node)slider, (Priority)Priority.ALWAYS);
                checkBox.setText(layer.getName());
                checkBox.setSelected(layer.isVisible());
                slider.setValue(layer.getOpacity());
                Button moveToFront = new Button();
                Button moveToBack = new Button();
                Button moveForward = new Button();
                Button moveBackward = new Button();
                Button delete = new Button();
                this.gridPane.add((Node)checkBox, 0, row);
                this.gridPane.add((Node)slider, 1, row);
                if (i < modelLayers.size() - 1) {
                    this.gridPane.add((Node)moveToFront, 2, row);
                    this.gridPane.add((Node)moveForward, 3, row);
                }
                if (i > 0) {
                    this.gridPane.add((Node)moveBackward, 4, row);
                    this.gridPane.add((Node)moveToBack, 5, row);
                }
                this.gridPane.add((Node)delete, 6, row);
                moveToFront.getStyleClass().addAll((Object[])new String[]{"navigate-button", "navigate-up2-16"});
                moveToBack.getStyleClass().addAll((Object[])new String[]{"navigate-button", "navigate-down2-16"});
                moveForward.getStyleClass().addAll((Object[])new String[]{"navigate-button", "navigate-up-16"});
                moveBackward.getStyleClass().addAll((Object[])new String[]{"navigate-button", "navigate-down-16"});
                delete.getStyleClass().addAll((Object[])new String[]{"layers-navigate-button", "delete-16"});
                moveToFront.setTooltip(new Tooltip(Messages.getString("LayersViewSkin.TOOLTIP_MOVE_LAYER_TO_FRONT")));
                moveToBack.setTooltip(new Tooltip(Messages.getString("LayersViewSkin.TOOLTIP_MOVE_LAYER_TO_BACK")));
                moveForward.setTooltip(new Tooltip(Messages.getString("LayersViewSkin.TOOLTIP_MOVE_LAYER_FORWARD")));
                moveBackward.setTooltip(new Tooltip(Messages.getString("LayersViewSkin.TOOLTIP_MOVE_LAYER_BACK")));
                delete.setTooltip(new Tooltip(Messages.getString("LayersViewSkin.TOOLTIP_DELETE_LAYER")));
                moveToFront.setOnAction(this.moveToFront(layer));
                moveToBack.setOnAction(this.moveToBack(layer));
                moveForward.setOnAction(this.moveForward(layer));
                moveBackward.setOnAction(this.moveBackward(layer));
                delete.setOnAction(this.delete(layer));
                Bindings.bindBidirectional((Property)checkBox.selectedProperty(), (Property)layer.visibleProperty());
                Bindings.bindBidirectional((Property)checkBox.textProperty(), (Property)layer.nameProperty());
                Bindings.bindBidirectional((Property)slider.valueProperty(), (Property)layer.opacityProperty());
                delete.visibleProperty().bind((ObservableValue)layer.deletableProperty());
                --row;
            }
            HBox hBox = new HBox();
            hBox.setSpacing(10.0);
            hBox.setAlignment(Pos.CENTER_RIGHT);
            Button showAll = new Button(Messages.getString("LayersViewSkin.BUTTON_SHOW_ALL"));
            Button hideAll = new Button(Messages.getString("LayersViewSkin.BUTTON_HIDE_ALL"));
            hBox.getChildren().add((Object)hideAll);
            hBox.getChildren().add((Object)showAll);
            this.gridPane.add((Node)hBox, 0, modelLayers.size() + 1, 7, 1);
            GridPane.setMargin((Node)hBox, (Insets)new Insets(20.0, 0.0, 0.0, 0.0));
            showAll.setOnAction(this.showAll(modelLayers));
            hideAll.setOnAction(this.hideAll(modelLayers));
        }
        Label headerName = new Label(Messages.getString("LayersViewSkin.HEADER_LAYER_NAME"));
        Label headerOpacity = new Label(Messages.getString("LayersViewSkin.HEADER_OPACITY"));
        Label headerOrder = new Label(Messages.getString("LayersViewSkin.HEADER_ORDER"));
        headerName.setMaxWidth(Double.MAX_VALUE);
        headerOpacity.setMaxWidth(Double.MAX_VALUE);
        headerOrder.setMaxWidth(Double.MAX_VALUE);
        headerName.getStyleClass().add((Object)"layers-table-header");
        headerOpacity.getStyleClass().add((Object)"layers-table-header");
        headerOrder.getStyleClass().add((Object)"layers-table-header");
        GridPane.setHgrow((Node)headerOpacity, (Priority)Priority.ALWAYS);
        GridPane.setFillWidth((Node)headerName, (Boolean)true);
        GridPane.setFillWidth((Node)headerOpacity, (Boolean)true);
        GridPane.setFillWidth((Node)headerOrder, (Boolean)true);
        this.gridPane.add((Node)headerName, 0, 0);
        this.gridPane.add((Node)headerOpacity, 1, 0);
        this.gridPane.add((Node)headerOrder, 2, 0, 4, 1);
    }

    private EventHandler<ActionEvent> hideAll(ObservableList<Layer> modelLayers) {
        return event -> {
            for (Layer layer : modelLayers) {
                layer.setVisible(false);
            }
        };
    }

    private EventHandler<ActionEvent> showAll(ObservableList<Layer> modelLayers) {
        return event -> {
            for (Layer layer : modelLayers) {
                layer.setVisible(true);
            }
        };
    }

    private EventHandler<ActionEvent> delete(Layer layer) {
        return evt -> ((LayersView)this.getSkinnable()).getGraphics().getLayers().remove((Object)layer);
    }

    private EventHandler<ActionEvent> moveBackward(Layer layer) {
        return evt -> ((LayersView)this.getSkinnable()).getGraphics().moveLayerBackward(layer);
    }

    private EventHandler<ActionEvent> moveForward(Layer layer) {
        return evt -> ((LayersView)this.getSkinnable()).getGraphics().moveLayerForward(layer);
    }

    private EventHandler<ActionEvent> moveToBack(Layer layer) {
        return evt -> ((LayersView)this.getSkinnable()).getGraphics().moveLayerToBack(layer);
    }

    private EventHandler<ActionEvent> moveToFront(Layer layer) {
        return evt -> ((LayersView)this.getSkinnable()).getGraphics().moveLayerToFront(layer);
    }
}

