/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view.util;

import com.flexganttfx.core.LoggingDomain;
import com.flexganttfx.model.timeline.TimelineModel;
import com.flexganttfx.view.GanttChart;
import com.flexganttfx.view.timeline.Timeline;
import java.time.Duration;
import java.time.Instant;
import java.util.logging.Level;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.controlsfx.control.PlusMinusSlider;

public class TimelineScrollBar
extends PlusMinusSlider {
    private final ObjectProperty<Timeline> timeline = new SimpleObjectProperty((Object)this, "timeline");

    public TimelineScrollBar() {
        this.getStyleClass().add((Object)"time-slider");
        this.getStylesheets().add((Object)GanttChart.class.getResource("gantt.css").toExternalForm());
        this.addEventHandler(PlusMinusSlider.PlusMinusEvent.VALUE_CHANGED, evt -> {
            long st = this.getTimeline().getVisibleStartTime().toEpochMilli();
            long et = this.getTimeline().getVisibleEndTime().toEpochMilli();
            long delta = et - st;
            double value = evt.getValue();
            long millis = (long)(value * (double)delta) / 10L;
            TimelineModel<?> model = this.getTimeline().getModel();
            Instant time = model.getStartTime().plus(Duration.ofMillis(millis));
            if (LoggingDomain.NAVIGATION.isLoggable(Level.FINER)) {
                LoggingDomain.NAVIGATION.finer("visible start time: " + st);
                LoggingDomain.NAVIGATION.finer("visible end time: " + et);
                LoggingDomain.NAVIGATION.finer("plus minus slider value: " + value);
                LoggingDomain.NAVIGATION.finer("setting new time on timeline model to " + time);
            }
            model.setStartTime(time);
        });
    }

    public final ObjectProperty<Timeline> timelineProperty() {
        return this.timeline;
    }

    public final Timeline getTimeline() {
        return (Timeline)((Object)this.timeline.get());
    }

    public final void setTimeline(Timeline timeline) {
        this.timeline.set((Object)timeline);
    }
}

