/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view.util;

import com.flexganttfx.model.Activity;
import com.flexganttfx.model.ActivityRepository;
import com.flexganttfx.model.Layer;
import com.flexganttfx.model.Row;
import com.flexganttfx.model.layout.EqualLinesManager;
import com.flexganttfx.view.graphics.GraphicsBase;
import impl.com.flexganttfx.skin.util.Placement;
import impl.com.flexganttfx.skin.util.Resolver;
import impl.com.flexganttfx.skin.util.ResolverResult;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class AutoLinesManager<R extends Row<?, ?, A>, A extends Activity>
extends EqualLinesManager<R, A> {
    private final GraphicsBase<R> graphics;
    private ResolverResult<A> resolverResult;
    private Predicate<A> filter;

    public AutoLinesManager(R row, GraphicsBase<R> graphics) {
        super(row);
        this.graphics = Objects.requireNonNull(graphics);
        this.layout();
    }

    public final GraphicsBase<R> getGraphics() {
        return this.graphics;
    }

    public final void setFilter(Predicate<A> filter) {
        this.filter = filter;
    }

    public final void layout() {
        Object row = this.getRow();
        ActivityRepository repository = ((Row)row).getRepository();
        Instant st = repository.getEarliestTimeUsed();
        Instant et = repository.getLatestTimeUsed();
        if (st == null || et == null) {
            return;
        }
        ArrayList allActivities = new ArrayList();
        for (Layer layer : this.graphics.getLayers()) {
            Iterator activities = repository.getActivities(layer, st, et, this.graphics.getTimeline().getDateline().getPrimaryTemporalUnit(), ((Row)row).getZoneId());
            if (activities == null) continue;
            activities.forEachRemaining(allActivities::add);
        }
        this.resolverResult = Resolver.resolve(allActivities, this.filter);
        ((Row)row).setLineCount(this.resolverResult.getMaxColumns());
    }

    @Override
    public final int getLineIndex(A activity) {
        Placement<A> placement;
        Map<A, Placement<A>> placements;
        if (this.resolverResult != null && (placements = this.resolverResult.getPlacements()) != null && (placement = placements.get(activity)) != null) {
            return placement.getColumnIndex();
        }
        return -1;
    }
}

