/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view.timeline;

import com.flexganttfx.core.LoggingDomain;
import java.time.Instant;
import java.util.logging.Level;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;

public class TimeTracker
extends Thread {
    private boolean running = true;
    private long delay = 1000L;
    private boolean stopped;
    private final ReadOnlyObjectWrapper<Instant> time = new ReadOnlyObjectWrapper((Object)this, "time", (Object)Instant.now());

    public TimeTracker() {
        this.setName("Time Tracker");
        this.setDaemon(true);
    }

    public final ReadOnlyObjectProperty<Instant> timeProperty() {
        return this.time.getReadOnlyProperty();
    }

    public final Instant getTime() {
        return (Instant)this.time.get();
    }

    public final long getDelay() {
        return this.delay;
    }

    public final void setDelay(long millis) {
        if (millis <= 0L) {
            throw new IllegalArgumentException("delay must be larger than zero but was" + millis);
        }
        this.delay = millis;
    }

    public final void startTracking() {
        if (this.stopped) {
            throw new IllegalStateException("Time tracker has already been stopped and can not be started again.");
        }
        this.running = true;
        this.start();
    }

    @Override
    public void run() {
        while (this.running) {
            Platform.runLater(() -> this.time.set((Object)this.getNow()));
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException e) {
                LoggingDomain.CONFIG.log(Level.WARNING, "problem in update thread", e);
            }
        }
    }

    public final void stopTracking() {
        this.stopped = true;
        this.running = false;
    }

    protected Instant getNow() {
        return Instant.now();
    }
}

