/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view.graphics.renderer;

import com.flexganttfx.model.ActivityRef;
import com.flexganttfx.model.activity.CompletableActivity;
import com.flexganttfx.view.graphics.ActivityBounds;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.renderer.ActivityBarRenderer;
import com.flexganttfx.view.util.Position;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class CompletableActivityRenderer<A extends CompletableActivity>
extends ActivityBarRenderer<A> {
    private final ObjectProperty<Paint> fillCompletion = new SimpleObjectProperty((Object)this, "fillCompletion");
    private final ObjectProperty<Paint> fillCompletionHover = new SimpleObjectProperty((Object)this, "fillCompletionHover");
    private final ObjectProperty<Paint> fillCompletionHighlight = new SimpleObjectProperty((Object)this, "fillCompletionHighlight");
    private final ObjectProperty<Paint> fillCompletionSelected = new SimpleObjectProperty((Object)this, "fillCompletionSelected");
    private final ObjectProperty<Paint> fillCompletionPressed = new SimpleObjectProperty((Object)this, "fillCompletionPressed");

    public CompletableActivityRenderer(GraphicsBase<?> graphics, String name) {
        super(graphics, name);
        this.setFillCompletion((Paint)new Color(0.0, 0.0, 0.0, 0.3));
        this.setFillCompletionHover((Paint)new Color(0.0, 0.0, 0.0, 0.4));
        this.setFillCompletionPressed((Paint)new Color(0.0, 0.0, 0.0, 0.5));
        this.setFillCompletionSelected((Paint)new Color(0.0, 0.0, 0.0, 0.3));
        this.setFillCompletionHighlight((Paint)new Color(0.0, 0.0, 0.0, 0.2));
        this.redrawObservable((Observable)this.fillCompletionProperty());
        this.redrawObservable((Observable)this.fillCompletionHoverProperty());
        this.redrawObservable((Observable)this.fillCompletionPressedProperty());
        this.redrawObservable((Observable)this.fillCompletionSelectedProperty());
        this.redrawObservable((Observable)this.fillCompletionHighlightProperty());
    }

    @Override
    protected ActivityBounds drawActivity(ActivityRef<A> path, Position position, GraphicsContext gc, double x, double y, double w, double h, boolean selected, boolean hover, boolean highlighted, boolean pressed) {
        ActivityBounds bounds = super.drawActivity(path, position, gc, x, y, w, h, selected, hover, highlighted, pressed);
        this.drawCompletion(path, gc, x, y, w, h, selected, hover, highlighted, pressed);
        return bounds;
    }

    protected void drawCompletion(ActivityRef<A> activityRef, GraphicsContext gc, double x, double y, double w, double h, boolean selected, boolean hover, boolean highlighted, boolean pressed) {
        double percentage = ((CompletableActivity)activityRef.getActivity()).getPercentageComplete();
        double pw = percentage / 100.0 * w;
        double my = y + (h - this.getBarHeight()) / 2.0;
        gc.setFill(this.getFillCompletion(selected, hover, highlighted, pressed));
        if (this.isCornersRounded()) {
            gc.fillRoundRect(x, my, pw, this.getBarHeight(), this.getCornerRadius(), this.getCornerRadius());
        } else {
            gc.fillRect(x, my, pw, this.getBarHeight());
        }
    }

    protected Paint getFillCompletion(boolean selected, boolean hover, boolean highlighted, boolean pressed) {
        if (pressed) {
            return this.getFillCompletionPressed();
        }
        if (highlighted) {
            return this.getFillCompletionHighlight();
        }
        if (hover) {
            return this.getFillCompletionHover();
        }
        if (selected) {
            return this.getFillCompletionSelected();
        }
        return this.getFillCompletion();
    }

    public final ObjectProperty<Paint> fillCompletionProperty() {
        return this.fillCompletion;
    }

    public final void setFillCompletion(Paint fill) {
        this.fillCompletionProperty().set((Object)fill);
    }

    public final Paint getFillCompletion() {
        return (Paint)this.fillCompletionProperty().get();
    }

    public final ObjectProperty<Paint> fillCompletionHoverProperty() {
        return this.fillCompletionHover;
    }

    public final void setFillCompletionHover(Paint fill) {
        this.fillCompletionHoverProperty().set((Object)fill);
    }

    public final Paint getFillCompletionHover() {
        return (Paint)this.fillCompletionHoverProperty().get();
    }

    public final ObjectProperty<Paint> fillCompletionHighlightProperty() {
        return this.fillCompletionHighlight;
    }

    public final void setFillCompletionHighlight(Paint fill) {
        this.fillCompletionHighlightProperty().set((Object)fill);
    }

    public final Paint getFillCompletionHighlight() {
        return (Paint)this.fillCompletionHighlightProperty().get();
    }

    public final ObjectProperty<Paint> fillCompletionSelectedProperty() {
        return this.fillCompletionSelected;
    }

    public final void setFillCompletionSelected(Paint fill) {
        this.fillCompletionSelectedProperty().set((Object)fill);
    }

    public final Paint getFillCompletionSelected() {
        return (Paint)this.fillCompletionSelectedProperty().get();
    }

    public final ObjectProperty<Paint> fillCompletionPressedProperty() {
        return this.fillCompletionPressed;
    }

    public final void setFillCompletionPressed(Paint fill) {
        this.fillCompletionPressedProperty().set((Object)fill);
    }

    public final Paint getFillCompletionPressed() {
        return (Paint)this.fillCompletionPressedProperty().get();
    }
}

