/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view.graphics.renderer;

import com.flexganttfx.model.ActivityRef;
import com.flexganttfx.model.calendar.CalendarActivity;
import com.flexganttfx.view.graphics.ActivityBounds;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.renderer.ActivityRenderer;
import com.flexganttfx.view.util.Position;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class CalendarActivityRenderer<A extends CalendarActivity>
extends ActivityRenderer<A> {
    public CalendarActivityRenderer(GraphicsBase<?> graphics, String name) {
        super(graphics, name);
        this.setFill((Paint)new Color(0.0, 0.0, 0.0, 0.1));
        this.setStroke(this.getFill());
        this.setCornersRounded(false);
    }

    @Override
    protected ActivityBounds drawActivity(ActivityRef<A> activityRef, Position position, GraphicsContext gc, double x, double y, double w, double h, boolean selected, boolean hover, boolean highlighted, boolean pressed) {
        GraphicsBase<?> graphics = this.getGraphics();
        double alpha = gc.getGlobalAlpha();
        boolean safeRendering = graphics.isSafeRendering();
        if (safeRendering) {
            gc.save();
        }
        gc.setGlobalAlpha(alpha * this.getAlpha());
        this.drawBackground(activityRef, position, gc, x, y, w, h, selected, hover, highlighted, pressed);
        if (safeRendering) {
            gc.restore();
            gc.save();
        }
        gc.setGlobalAlpha(alpha * this.getAlpha());
        this.drawBorder(activityRef, position, gc, x, y, w, h, selected, hover, highlighted, pressed);
        if (safeRendering) {
            gc.restore();
        }
        gc.setGlobalAlpha(alpha);
        return null;
    }
}

