/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view.graphics.layer;

import com.flexganttfx.model.Layout;
import com.flexganttfx.model.Row;
import com.flexganttfx.model.layout.AgendaLayout;
import com.flexganttfx.model.layout.ChartLayout;
import com.flexganttfx.model.layout.GanttLayout;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.layer.SystemLayer;
import impl.com.flexganttfx.skin.graphics.RowCanvas;
import impl.com.flexganttfx.skin.util.AgendaHelper;
import java.text.NumberFormat;
import java.time.Instant;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.Rectangle2D;
import javafx.geometry.VPos;
import javafx.scene.SnapshotParameters;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.effect.BoxBlur;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;
import javafx.util.Duration;

public class ScaleLayer<R extends Row<?, ?, ?>>
extends SystemLayer<R> {
    private final BoxBlur blur = new BoxBlur();
    private WritableImage image;
    private final ObjectProperty<Font> font = new SimpleObjectProperty((Object)this, "font", (Object)Font.font((String)"System", (double)8.0));
    private final ObjectProperty<Paint> dividerLineStroke = new SimpleObjectProperty((Object)this, "dividerLineStroke");
    private final BooleanProperty bluredBackground = new SimpleBooleanProperty((Object)this, "bluredBackground", false);
    private final ObjectProperty<Paint> backgroundFill = new SimpleObjectProperty((Object)this, "backgroundFill");
    private final DoubleProperty prefWidth = new SimpleDoubleProperty((Object)this, "prefWidth", 60.0);
    private final ReadOnlyDoubleWrapper scaleWidth = new ReadOnlyDoubleWrapper((Object)this, "width", 0.0);
    private final BooleanProperty majorChartLabelsVisible = new SimpleBooleanProperty((Object)this, "majorChartLabelsVisible", true);
    private final BooleanProperty minorChartLabelsVisible = new SimpleBooleanProperty((Object)this, "minorChartLabelsVisible", true);
    private final BooleanProperty majorChartLinesVisible = new SimpleBooleanProperty((Object)this, "majorChartLinesVisible", true);
    private final ObjectProperty<Paint> majorChartLinesStroke = new SimpleObjectProperty((Object)this, "majorChartLinesStroke");
    private final ObjectProperty<Paint> majorChartLabelsFill = new SimpleObjectProperty((Object)this, "majorChartLabelsFill");
    private final ObjectProperty<Paint> minorChartLabelsFill = new SimpleObjectProperty((Object)this, "minorChartLabelsFill");
    private final DoubleProperty majorChartLinesLineWidth = new SimpleDoubleProperty((Object)this, "majorChartLinesLineWidth");
    private final DoubleProperty majorChartLinesSize = new SimpleDoubleProperty((Object)this, "majorChartLinesSize");
    private final BooleanProperty minorChartLinesVisible = new SimpleBooleanProperty((Object)this, "minorChartLinesVisible", true);
    private final ObjectProperty<Paint> minorChartLinesStroke = new SimpleObjectProperty((Object)this, "minorChartLinesStroke");
    private final DoubleProperty minorChartLinesLineWidth = new SimpleDoubleProperty((Object)this, "minorChartLinesLineWidth");
    private final DoubleProperty minorChartLinesSize = new SimpleDoubleProperty((Object)this, "minorChartLinesSize");
    private final BooleanProperty agendaLabelsVisible = new SimpleBooleanProperty((Object)this, "agendaLabelsVisible", true);
    private final DoubleProperty agendaLinesLineWidth = new SimpleDoubleProperty((Object)this, "agendaLinesLineWidth");
    private final DoubleProperty agendaLinesSize = new SimpleDoubleProperty((Object)this, "agendaLinesSize");
    private final ObjectProperty<Paint> agendaLinesStroke = new SimpleObjectProperty((Object)this, "agendaLinesStroke");
    private final ObjectProperty<Paint> agendaLabelsFill = new SimpleObjectProperty((Object)this, "agendaLabelsFill");
    private final BooleanProperty agendaLinesVisible = new SimpleBooleanProperty((Object)this, "agendaLinesVisible", true);
    private final ObjectProperty<DateTimeFormatter> dateTimeFormatter = new SimpleObjectProperty((Object)this, "dateTimeFormatter", (Object)DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT));
    private final ObjectProperty<NumberFormat> numberFormat = new SimpleObjectProperty<NumberFormat>((Object)this, "numberFormat"){

        public void set(NumberFormat newValue) {
            if (newValue == null) {
                throw new IllegalArgumentException("number format can not be null");
            }
            super.set((Object)newValue);
        }
    };

    public ScaleLayer(GraphicsBase<R> graphics) {
        super("Scale", graphics);
        this.setNumberFormat(NumberFormat.getIntegerInstance());
        this.setBackgroundFill((Paint)Color.rgb((int)77, (int)112, (int)128, (double)0.9));
        this.setDividerLineStroke((Paint)Color.rgb((int)255, (int)255, (int)255, (double)0.5));
        this.setMajorChartLinesLineWidth(0.5);
        this.setMajorChartLinesStroke((Paint)Color.WHITE);
        this.setMajorChartLinesVisible(true);
        this.setMajorChartLinesSize(15.0);
        this.setMajorChartLabelsFill((Paint)Color.WHITE);
        this.setMajorChartLabelsVisible(true);
        this.setMinorChartLinesLineWidth(0.5);
        this.setMinorChartLinesStroke((Paint)Color.LIGHTGRAY);
        this.setMinorChartLinesVisible(true);
        this.setMinorChartLinesSize(8.0);
        this.setMinorChartLabelsFill((Paint)Color.LIGHTGRAY);
        this.setMinorChartLabelsVisible(false);
        this.setAgendaLinesLineWidth(0.5);
        this.setAgendaLinesStroke((Paint)Color.WHITE);
        this.setAgendaLinesVisible(true);
        this.setAgendaLinesSize(15.0);
        this.setAgendaLabelsFill((Paint)Color.WHITE);
        this.setAgendaLabelsVisible(true);
        this.redrawObservable((Observable)this.backgroundFill);
        this.redrawObservable((Observable)this.bluredBackground);
        this.redrawObservable((Observable)this.prefWidth);
        this.redrawObservable((Observable)this.scaleWidth);
        this.redrawObservable((Observable)this.font);
        this.redrawObservable((Observable)this.dividerLineStroke);
        this.redrawObservable((Observable)this.dateTimeFormatter);
        this.redrawObservable((Observable)this.numberFormat);
        this.redrawObservable((Observable)this.majorChartLinesLineWidth);
        this.redrawObservable((Observable)this.majorChartLinesSize);
        this.redrawObservable((Observable)this.majorChartLinesStroke);
        this.redrawObservable((Observable)this.majorChartLinesVisible);
        this.redrawObservable((Observable)this.majorChartLabelsVisible);
        this.redrawObservable((Observable)this.majorChartLabelsFill);
        this.redrawObservable((Observable)this.minorChartLinesVisible);
        this.redrawObservable((Observable)this.minorChartLinesSize);
        this.redrawObservable((Observable)this.minorChartLinesLineWidth);
        this.redrawObservable((Observable)this.minorChartLinesStroke);
        this.redrawObservable((Observable)this.minorChartLabelsVisible);
        this.redrawObservable((Observable)this.minorChartLabelsFill);
        this.redrawObservable((Observable)this.agendaLinesLineWidth);
        this.redrawObservable((Observable)this.agendaLinesSize);
        this.redrawObservable((Observable)this.agendaLinesStroke);
        this.redrawObservable((Observable)this.agendaLinesVisible);
        this.redrawObservable((Observable)this.agendaLabelsFill);
        this.redrawObservable((Observable)this.agendaLabelsVisible);
        this.fadeInOutObservable((ObservableBooleanValue)graphics.showScaleLayerProperty());
        graphics.showScaleLayerProperty().addListener(observable -> {
            if (this.getGraphics().isShowScaleLayer()) {
                this.slide(this.getPrefWidth());
            } else {
                this.slide(0.0);
            }
        });
        if (graphics.isShowScaleLayer()) {
            this.scaleWidth.set(this.getPrefWidth());
        }
    }

    private void slide(double targetWidth) {
        if (this.getGraphics().isFadeInOutVisibilityChanges()) {
            KeyValue keyValue = new KeyValue((WritableValue)this.scaleWidth, (Object)targetWidth);
            KeyFrame keyFrame = new KeyFrame(Duration.millis((double)333.0), new KeyValue[]{keyValue});
            Timeline timeline = new Timeline(new KeyFrame[]{keyFrame});
            timeline.play();
        } else {
            this.scaleWidth.set(targetWidth);
        }
    }

    @Override
    public void drawLayer(RowCanvas<R> canvas, Instant startTime, Instant endTime) {
        double canvasHeight = canvas.getHeight();
        double width = this.getScaleWidth();
        if (width > 0.0) {
            GraphicsContext gc = canvas.getGraphicsContext2D();
            gc.setFont(this.getFont());
            if (this.isBluredBackground()) {
                this.updateBackground(canvas);
                if (this.image != null) {
                    gc.setEffect((Effect)this.blur);
                    gc.drawImage((Image)this.image, 0.0, 0.0);
                    gc.setEffect(null);
                }
            }
            gc.setFill(this.getBackgroundFill());
            gc.fillRect(0.0, 0.0, width, canvasHeight);
            R row = canvas.getRow();
            if (row != null) {
                double xOffset = 0.0;
                xOffset = this.drawLayoutSpecificHeader(xOffset, 0.0, canvasHeight, canvas, ((Row)row).getLayout());
                for (int lineIndex = 0; lineIndex < ((Row)row).getLineCount(); ++lineIndex) {
                    Layout lineLayout = ((Row)row).getLineLayout(lineIndex);
                    double lineOffset = ((Row)row).getLineLocation(lineIndex);
                    double lineHeight = ((Row)row).getLineHeight(lineIndex);
                    this.drawLayoutSpecificHeader(xOffset, lineOffset, lineHeight, canvas, lineLayout);
                    gc.setLineWidth(0.5);
                    gc.setStroke(this.getDividerLineStroke());
                    gc.strokeLine(0.0, (double)((int)lineOffset) + lineHeight - 0.5, this.getScaleWidth(), (double)((int)lineOffset) + lineHeight - 0.5);
                }
            }
            gc.setLineWidth(0.5);
            gc.setStroke(this.getDividerLineStroke());
            gc.strokeLine(0.0, (double)((int)canvasHeight) - 0.5, this.getScaleWidth(), (double)((int)canvasHeight) - 0.5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double drawLayoutSpecificHeader(double xOffset, double yOffset, double height, RowCanvas<R> canvas, Layout layout) {
        yOffset += layout.getPadding();
        height -= layout.getPadding() * 2.0;
        GraphicsContext gc = canvas.getGraphicsContext2D();
        GraphicsBase graphics = this.getGraphics();
        try {
            if (graphics.isSafeRendering()) {
                gc.save();
            }
            if (layout instanceof GanttLayout) {
                double d = this.drawLayoutHeaderGantt();
                return d;
            }
            if (layout instanceof AgendaLayout) {
                double d = this.drawLayoutHeaderAgenda(yOffset, height, canvas, (AgendaLayout)layout);
                return d;
            }
            if (layout instanceof ChartLayout) {
                double d = this.drawLayoutHeaderChart(yOffset, height, canvas, (ChartLayout)layout);
                return d;
            }
        }
        finally {
            if (graphics.isSafeRendering()) {
                gc.restore();
            }
        }
        return xOffset;
    }

    private double drawLayoutHeaderAgenda(double yOffset, double height, RowCanvas<R> canvas, AgendaLayout layout) {
        GraphicsContext gc = canvas.getGraphicsContext2D();
        DateTimeFormatter formatter = this.getDateTimeFormatter();
        double width = this.getScaleWidth();
        List<AgendaHelper.AgendaLineLocation> lines = AgendaHelper.getLineLocations(layout, yOffset, height);
        lines.stream().filter(loc -> !loc.isMinor()).forEach(loc -> {
            if (this.isAgendaLinesVisible()) {
                gc.setLineWidth(this.getAgendaLinesLineWidth());
                gc.setStroke(this.getAgendaLinesStroke());
                gc.strokeLine(width - this.getAgendaLinesSize(), loc.getLocation(), width, loc.getLocation());
            }
            if (this.isAgendaLabelsVisible()) {
                LocalTime time = loc.getTime();
                if (time.equals(LocalTime.MAX)) {
                    time = LocalTime.MIDNIGHT;
                }
                gc.setFill(this.getAgendaLabelsFill());
                gc.setTextAlign(TextAlignment.RIGHT);
                gc.setTextBaseline(VPos.CENTER);
                gc.fillText(formatter.format(time), width - this.getAgendaLinesSize() - 3.0, loc.getLocation());
            }
        });
        return this.getScaleWidth();
    }

    private double drawLayoutHeaderGantt() {
        return this.getScaleWidth();
    }

    private double drawLayoutHeaderChart(double yOffset, double height, RowCanvas<R> canvas, ChartLayout layout) {
        double y;
        double value;
        Object format;
        double y2;
        GraphicsContext gc = canvas.getGraphicsContext2D();
        double width = this.getScaleWidth();
        if (this.isMinorChartLinesVisible()) {
            gc.setStroke(this.getMinorChartLinesStroke());
            gc.setLineWidth(this.getMinorChartLinesLineWidth());
            Iterator iterator = layout.getMinorTicks().iterator();
            while (iterator.hasNext()) {
                double value2 = (Double)iterator.next();
                y2 = this.getChartValueLocation(value2, yOffset, height, layout);
                gc.strokeLine(width - this.getMinorChartLinesSize(), y2, width, y2);
            }
        }
        if (this.isMinorChartLabelsVisible()) {
            format = this.getNumberFormat();
            Iterator value2 = layout.getMinorTicks().iterator();
            while (value2.hasNext()) {
                value = (Double)value2.next();
                y = this.getChartValueLocation(value, yOffset, height, layout);
                gc.setTextAlign(TextAlignment.RIGHT);
                gc.setTextBaseline(VPos.CENTER);
                gc.setFill(this.getMinorChartLabelsFill());
                gc.fillText(((NumberFormat)format).format(value), width - this.getMinorChartLinesSize() - 3.0, y);
            }
        }
        if (this.isMajorChartLinesVisible()) {
            gc.setStroke(this.getMajorChartLinesStroke());
            gc.setLineWidth(this.getMajorChartLinesLineWidth());
            format = layout.getMajorTicks().iterator();
            while (format.hasNext()) {
                double value3 = (Double)format.next();
                y2 = this.getChartValueLocation(value3, yOffset, height, layout);
                gc.strokeLine(width - this.getMajorChartLinesSize(), y2, width, y2);
            }
        }
        if (this.isMajorChartLabelsVisible()) {
            format = this.getNumberFormat();
            Iterator iterator = layout.getMajorTicks().iterator();
            while (iterator.hasNext()) {
                value = (Double)iterator.next();
                y = this.getChartValueLocation(value, yOffset, height, layout);
                gc.setTextAlign(TextAlignment.RIGHT);
                gc.setTextBaseline(VPos.CENTER);
                gc.setFill(this.getMajorChartLabelsFill());
                gc.fillText(((NumberFormat)format).format(value), width - this.getMajorChartLinesSize() - 3.0, y);
            }
        }
        return this.getScaleWidth();
    }

    private double getChartValueLocation(double value, double yOffset, double height, ChartLayout layout) {
        double minChart = layout.getMinValue();
        double maxChart = layout.getMaxValue();
        double range = maxChart - minChart;
        double ppv = height / range;
        double zeroLineLocation = yOffset + layout.getMaxValue() * ppv;
        return (double)((int)(zeroLineLocation - value * ppv)) + 0.5;
    }

    private void updateBackground(RowCanvas<R> canvas) {
        int width = (int)this.getScaleWidth();
        int height = (int)canvas.getHeight();
        if (width <= 0 || height <= 0) {
            return;
        }
        if (this.image == null || width != (int)this.image.getWidth() || height != (int)this.image.getHeight()) {
            this.image = new WritableImage(width, height);
        }
        SnapshotParameters sp = new SnapshotParameters();
        Rectangle2D rect = new Rectangle2D(0.0, 0.0, (double)width, (double)height);
        sp.setViewport(rect);
        this.image = canvas.snapshot(sp, this.image);
    }

    public final ObjectProperty<Font> fontProperty() {
        return this.font;
    }

    public final void setFont(Font font) {
        Objects.requireNonNull(font);
        this.fontProperty().set((Object)font);
    }

    public final Font getFont() {
        return (Font)this.fontProperty().get();
    }

    public final ObjectProperty<Paint> dividerLineStrokeProperty() {
        return this.dividerLineStroke;
    }

    public final Paint getDividerLineStroke() {
        return (Paint)this.dividerLineStrokeProperty().get();
    }

    public final void setDividerLineStroke(Paint stroke) {
        Objects.requireNonNull(stroke);
        this.dividerLineStrokeProperty().set((Object)stroke);
    }

    public final BooleanProperty bluredBackgroundProperty() {
        return this.bluredBackground;
    }

    public final boolean isBluredBackground() {
        return this.bluredBackground.get();
    }

    public final void setBluredBackground(boolean blurred) {
        this.bluredBackground.set(blurred);
    }

    public final ObjectProperty<Paint> backgroundFillProperty() {
        return this.backgroundFill;
    }

    public final Paint getBackgroundFill() {
        return (Paint)this.backgroundFillProperty().get();
    }

    public final void setBackgroundFill(Paint fill) {
        Objects.requireNonNull(fill);
        this.backgroundFillProperty().set((Object)fill);
    }

    public final DoubleProperty prefWidthProperty() {
        return this.prefWidth;
    }

    public final double getPrefWidth() {
        return this.prefWidth.get();
    }

    public final void setPrefWidth(double width) {
        this.prefWidth.set(width);
    }

    public final ReadOnlyDoubleProperty scaleWidthProperty() {
        return this.scaleWidth.getReadOnlyProperty();
    }

    public final double getScaleWidth() {
        return this.scaleWidth.get();
    }

    public final BooleanProperty majorChartLabelsVisibleProperty() {
        return this.majorChartLabelsVisible;
    }

    public final void setMajorChartLabelsVisible(boolean visible) {
        this.majorChartLabelsVisibleProperty().set(visible);
    }

    public final boolean isMajorChartLabelsVisible() {
        return this.majorChartLabelsVisibleProperty().get();
    }

    public final BooleanProperty minorChartLabelsVisibleProperty() {
        return this.minorChartLabelsVisible;
    }

    public final void setMinorChartLabelsVisible(boolean visible) {
        this.minorChartLabelsVisibleProperty().set(visible);
    }

    public final boolean isMinorChartLabelsVisible() {
        return this.minorChartLabelsVisibleProperty().get();
    }

    public final BooleanProperty majorChartLinesVisibleProperty() {
        return this.majorChartLinesVisible;
    }

    public final void setMajorChartLinesVisible(boolean visible) {
        this.majorChartLinesVisibleProperty().set(visible);
    }

    public final boolean isMajorChartLinesVisible() {
        return this.majorChartLinesVisibleProperty().get();
    }

    public final ObjectProperty<Paint> majorChartLinesStrokeProperty() {
        return this.majorChartLinesStroke;
    }

    public final Paint getMajorChartLinesStroke() {
        return (Paint)this.majorChartLinesStrokeProperty().get();
    }

    public final void setMajorChartLinesStroke(Paint stroke) {
        Objects.requireNonNull(stroke);
        this.majorChartLinesStrokeProperty().set((Object)stroke);
    }

    public final ObjectProperty<Paint> majorChartLabelsFillProperty() {
        return this.majorChartLabelsFill;
    }

    public final Paint getMajorChartLabelsFill() {
        return (Paint)this.majorChartLabelsFillProperty().get();
    }

    public final void setMajorChartLabelsFill(Paint fill) {
        Objects.requireNonNull(fill);
        this.majorChartLabelsFillProperty().set((Object)fill);
    }

    public final ObjectProperty<Paint> minorChartLabelsFillProperty() {
        return this.minorChartLabelsFill;
    }

    public final Paint getMinorChartLabelsFill() {
        return (Paint)this.minorChartLabelsFillProperty().get();
    }

    public final void setMinorChartLabelsFill(Paint fill) {
        Objects.requireNonNull(fill);
        this.minorChartLabelsFillProperty().set((Object)fill);
    }

    public final DoubleProperty majorChartLinesLineWidthProperty() {
        return this.majorChartLinesLineWidth;
    }

    public final double getMajorChartLinesLineWidth() {
        return this.majorChartLinesLineWidthProperty().get();
    }

    public final void setMajorChartLinesLineWidth(double lineWidth) {
        this.majorChartLinesLineWidthProperty().set(lineWidth);
    }

    public final DoubleProperty majorChartLinesSizeProperty() {
        return this.majorChartLinesSize;
    }

    public final double getMajorChartLinesSize() {
        return this.majorChartLinesSizeProperty().get();
    }

    public final void setMajorChartLinesSize(double size) {
        this.majorChartLinesSizeProperty().set(size);
    }

    public final BooleanProperty minorChartLinesVisibleProperty() {
        return this.minorChartLinesVisible;
    }

    public final void setMinorChartLinesVisible(boolean visible) {
        this.minorChartLinesVisibleProperty().set(visible);
    }

    public final boolean isMinorChartLinesVisible() {
        return this.minorChartLinesVisibleProperty().get();
    }

    public final ObjectProperty<Paint> minorChartLinesStrokeProperty() {
        return this.minorChartLinesStroke;
    }

    public final Paint getMinorChartLinesStroke() {
        return (Paint)this.minorChartLinesStrokeProperty().get();
    }

    public final void setMinorChartLinesStroke(Paint stroke) {
        Objects.requireNonNull(stroke);
        this.minorChartLinesStrokeProperty().set((Object)stroke);
    }

    public final DoubleProperty minorChartLinesLineWidthProperty() {
        return this.minorChartLinesLineWidth;
    }

    public final double getMinorChartLinesLineWidth() {
        return this.minorChartLinesLineWidthProperty().get();
    }

    public final void setMinorChartLinesLineWidth(double lineWidth) {
        this.minorChartLinesLineWidthProperty().set(lineWidth);
    }

    public final DoubleProperty minorChartLinesSizeProperty() {
        return this.minorChartLinesSize;
    }

    public final double getMinorChartLinesSize() {
        return this.minorChartLinesSizeProperty().get();
    }

    public final void setMinorChartLinesSize(double size) {
        this.minorChartLinesSizeProperty().set(size);
    }

    public final BooleanProperty agendaLabelsVisibleProperty() {
        return this.agendaLabelsVisible;
    }

    public final void setAgendaLabelsVisible(boolean visible) {
        this.agendaLabelsVisibleProperty().set(visible);
    }

    public final boolean isAgendaLabelsVisible() {
        return this.agendaLabelsVisibleProperty().get();
    }

    public final DoubleProperty agendaLinesLineWidthProperty() {
        return this.agendaLinesLineWidth;
    }

    public final double getAgendaLinesLineWidth() {
        return this.agendaLinesLineWidthProperty().get();
    }

    public final void setAgendaLinesLineWidth(double lineWidth) {
        this.agendaLinesLineWidthProperty().set(lineWidth);
    }

    public final DoubleProperty agendaLinesSizeProperty() {
        return this.agendaLinesSize;
    }

    public final double getAgendaLinesSize() {
        return this.agendaLinesSizeProperty().get();
    }

    public final void setAgendaLinesSize(double size) {
        this.agendaLinesSizeProperty().set(size);
    }

    public final ObjectProperty<Paint> agendaLinesStrokeProperty() {
        return this.agendaLinesStroke;
    }

    public final Paint getAgendaLinesStroke() {
        return (Paint)this.agendaLinesStrokeProperty().get();
    }

    public final void setAgendaLinesStroke(Paint stroke) {
        Objects.requireNonNull(stroke);
        this.agendaLinesStrokeProperty().set((Object)stroke);
    }

    public final ObjectProperty<Paint> agendaLabelsFillProperty() {
        return this.agendaLabelsFill;
    }

    public final Paint getAgendaLabelsFill() {
        return (Paint)this.agendaLabelsFillProperty().get();
    }

    public final void setAgendaLabelsFill(Paint fill) {
        Objects.requireNonNull(fill);
        this.agendaLabelsFillProperty().set((Object)fill);
    }

    public final BooleanProperty agendaLinesVisibleProperty() {
        return this.agendaLinesVisible;
    }

    public final void setAgendaLinesVisible(boolean visible) {
        this.agendaLinesVisibleProperty().set(visible);
    }

    public final boolean isAgendaLinesVisible() {
        return this.agendaLinesVisibleProperty().get();
    }

    public final ObjectProperty<DateTimeFormatter> dateTimeFormatterProperty() {
        return this.dateTimeFormatter;
    }

    public final void setDateTimeFormatter(DateTimeFormatter formatter) {
        this.dateTimeFormatterProperty().set((Object)formatter);
    }

    public final DateTimeFormatter getDateTimeFormatter() {
        return (DateTimeFormatter)this.dateTimeFormatter.get();
    }

    public final ObjectProperty<NumberFormat> numberFormatProperty() {
        return this.numberFormat;
    }

    public final void setNumberFormat(NumberFormat format) {
        this.numberFormatProperty().set((Object)format);
    }

    public final NumberFormat getNumberFormat() {
        return (NumberFormat)this.numberFormatProperty().get();
    }
}

