/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view.graphics.layer;

import com.flexganttfx.core.LoggingDomain;
import com.flexganttfx.model.Row;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.layer.SystemLayer;
import com.flexganttfx.view.graphics.renderer.RowRenderer;
import impl.com.flexganttfx.skin.graphics.RowCanvas;
import java.time.Instant;
import java.util.Objects;
import javafx.beans.Observable;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.scene.canvas.GraphicsContext;

public class RowLayer<R extends Row<?, ?, ?>>
extends SystemLayer<R> {
    private final ObservableMap<Class<?>, RowRenderer<?>> rowRendererMap = FXCollections.observableHashMap();
    private final ObservableMap<Class<?>, RowRenderer<?>> rendererCache = FXCollections.observableHashMap();

    public RowLayer(GraphicsBase<R> graphics) {
        super("Row", graphics);
        this.setRowRenderer(Row.class, new RowRenderer(graphics, "Rows"));
        this.fadeInOutObservable((ObservableBooleanValue)graphics.showRowLayerProperty());
        this.redrawObservable((Observable)this.rowRendererMap);
        this.rowRendererMap.addListener(evt -> graphics.updatePropertySheet());
    }

    @Override
    public void drawLayer(RowCanvas<R> canvas, Instant startTime, Instant endTime) {
        RowRenderer<?> renderer;
        R row = canvas.getRow();
        if (row != null && (renderer = this.getRowRenderer(row.getClass())) != null) {
            GraphicsBase graphics = this.getGraphics();
            GraphicsContext gc = canvas.getGraphicsContext2D();
            boolean selected = false;
            boolean hover = canvas.isHover();
            boolean highlight = graphics.getHighlightedRows().contains(row);
            boolean pressed = canvas.isPressed();
            renderer.draw(row, gc, canvas.getWidth(), canvas.getHeight(), selected, hover, highlight, pressed);
        }
    }

    public final void setRowRenderer(Class<Row> clazz, RowRenderer<?> renderer) {
        this.rendererCache.clear();
        if (renderer != null) {
            LoggingDomain.CONFIG.fine("class = " + clazz + ", renderer = " + renderer.getClass().getName());
        } else {
            LoggingDomain.CONFIG.fine("class = " + clazz + ", renderer = null");
        }
        Objects.requireNonNull(clazz);
        this.rowRendererMap.put(clazz, renderer);
    }

    public final <RT extends Row<?, ?, ?>> RowRenderer<RT> getRowRenderer(Class<RT> clazz) {
        RowRenderer cachedRenderer = (RowRenderer)this.rendererCache.get(clazz);
        if (cachedRenderer != null) {
            return cachedRenderer;
        }
        RowRenderer<RT> renderer = this.doGetRowRenderer(clazz);
        this.rendererCache.put(clazz, renderer);
        return renderer;
    }

    private RowRenderer<?> doGetRowRenderer(Class<?> clazz) {
        if (clazz != null) {
            RowRenderer renderer = (RowRenderer)this.rowRendererMap.get(clazz);
            if (renderer == null) {
                return this.doGetRowRenderer(clazz.getSuperclass());
            }
            return renderer;
        }
        return null;
    }
}

