/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view.graphics.layer;

import com.flexganttfx.model.Row;
import com.flexganttfx.model.timeline.TimelineModel;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.layer.SystemLayer;
import impl.com.flexganttfx.skin.graphics.RowCanvas;
import java.time.Instant;
import java.util.Objects;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Paint;

public class NowLineLayer<R extends Row<?, ?, ?>>
extends SystemLayer<R> {
    private final ObjectProperty<Paint> stroke = new SimpleObjectProperty((Object)this, "stroke");
    private final DoubleProperty lineWidth = new SimpleDoubleProperty((Object)this, "lineWidth");

    public NowLineLayer(GraphicsBase<R> graphics) {
        super("Now Line", graphics);
        this.strokeProperty().bindBidirectional(graphics.timeNowColorProperty());
        this.setLineWidth(2.5);
        this.redrawObservable((Observable)this.strokeProperty());
        this.redrawObservable((Observable)this.lineWidthProperty());
        this.fadeInOutObservable((ObservableBooleanValue)graphics.showNowLineLayerProperty());
    }

    public final ObjectProperty<Paint> strokeProperty() {
        return this.stroke;
    }

    public final Paint getStroke() {
        return (Paint)this.strokeProperty().get();
    }

    public final void setStroke(Paint stroke) {
        Objects.requireNonNull(stroke);
        this.strokeProperty().set((Object)stroke);
    }

    public final DoubleProperty lineWidthProperty() {
        return this.lineWidth;
    }

    public final double getLineWidth() {
        return this.lineWidthProperty().get();
    }

    public final void setLineWidth(double lineWidth) {
        this.lineWidthProperty().set(lineWidth);
    }

    @Override
    public void drawLayer(RowCanvas<R> canvas, Instant startTime, Instant endTime) {
        GraphicsContext gc = canvas.getGraphicsContext2D();
        gc.setStroke(this.getStroke());
        gc.setLineWidth(this.getLineWidth());
        TimelineModel<?> model = canvas.getTimelineModel();
        Instant now = model.getNow();
        double nowLocation = this.snapPosition(model.calculateLocationForTime(now));
        gc.strokeLine(nowLocation, 0.0, nowLocation, canvas.getHeight());
    }
}

